/*
 * Decompiled with CFR 0.152.
 */
package org.globus.mds;

import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.io.Serializable;
import java.net.URLDecoder;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Properties;
import java.util.Vector;
import javax.naming.NamingEnumeration;
import javax.naming.NamingException;
import javax.naming.directory.Attribute;
import javax.naming.directory.Attributes;
import javax.naming.directory.BasicAttribute;
import javax.naming.directory.BasicAttributes;
import javax.naming.directory.SearchControls;
import javax.naming.directory.SearchResult;
import javax.naming.ldap.InitialLdapContext;
import javax.naming.ldap.LdapContext;
import org.globus.mds.MDSException;
import org.globus.mds.MDSResult;
import org.globus.util.GlobusURL;

public class MDS
implements Serializable {
    private String hostname = "mds11.globus.org";
    private String port = "391";
    private String baseDN = "o=globus, c=us";
    protected int limit = 0;
    protected int timeout = 0;
    protected int version = 3;
    public static final int SUBTREE_SCOPE = 2;
    public static final int ONELEVEL_SCOPE = 1;
    public static final int OBJECT_SCOPE = 0;
    protected static final String DEFAULT_CTX = "com.sun.jndi.ldap.LdapCtxFactory";
    protected LdapContext ctx = null;
    protected Properties env = null;
    private PropertyChangeSupport propertyChangeSupport = new PropertyChangeSupport(this);

    public void addPropertyChangeListener(PropertyChangeListener l) {
        this.propertyChangeSupport.addPropertyChangeListener(l);
    }

    public void removePropertyChangeListener(PropertyChangeListener l) {
        this.propertyChangeSupport.removePropertyChangeListener(l);
    }

    public MDS() {
        this.env = new Properties();
    }

    public MDS(String hostname, String port) {
        this.env = new Properties();
        this.setHostname(hostname);
        this.setPort(port);
    }

    public MDS(String hostname, String port, String baseDN) {
        this.env = new Properties();
        this.setHostname(hostname);
        this.setPort(port);
        this.setBaseDN(baseDN);
    }

    public MDS(GlobusURL spec) {
        this.env = new Properties();
        this.setHostname(spec.getHost());
        this.setPort(String.valueOf(spec.getPort()));
        try {
            this.setBaseDN(URLDecoder.decode(spec.getFile()));
        }
        catch (Exception e) {
            this.setBaseDN(spec.getFile());
        }
    }

    public void setBaseDN(String baseDN) {
        String oldBaseDN = this.baseDN;
        this.baseDN = baseDN;
        this.propertyChangeSupport.firePropertyChange("baseDN", oldBaseDN, baseDN);
    }

    public String getBaseDN() {
        return this.baseDN;
    }

    public void setPort(String port) {
        String oldPort = this.port;
        this.port = port;
        this.propertyChangeSupport.firePropertyChange("port", oldPort, port);
    }

    public String getPort() {
        return this.port;
    }

    public void setHostname(String hostname) {
        String oldHostname = this.hostname;
        this.hostname = hostname;
        this.propertyChangeSupport.firePropertyChange("hostname", oldHostname, hostname);
    }

    public String getHostname() {
        return this.hostname;
    }

    public String getURL() {
        return "ldap://" + this.hostname + ":" + this.port;
    }

    public void setSearchTimeout(int newTimeout) {
        this.timeout = newTimeout;
    }

    public int getSearchTimeout() {
        return this.timeout;
    }

    public void setSearchLimit(int newLimit) {
        this.limit = newLimit;
    }

    public int getSearchLimit() {
        return this.limit;
    }

    public void setLdapVersion(int newVersion) {
        this.version = newVersion;
    }

    public int getLdapVersion() {
        return this.version;
    }

    public synchronized void connect() throws MDSException {
        this.connect(null, null);
    }

    public synchronized void connect(String managerDN, String password) throws MDSException {
        if (managerDN != null && password != null) {
            ((Hashtable)this.env).put("java.naming.security.authentication", "simple");
            ((Hashtable)this.env).put("java.naming.security.principal", managerDN);
            ((Hashtable)this.env).put("java.naming.security.credentials", password);
        }
        ((Hashtable)this.env).put("java.naming.ldap.version", String.valueOf(this.getLdapVersion()));
        ((Hashtable)this.env).put("java.naming.factory.initial", DEFAULT_CTX);
        ((Hashtable)this.env).put("java.naming.provider.url", this.getURL());
        try {
            this.ctx = new InitialLdapContext(this.env, null);
        }
        catch (NamingException e) {
            ((Hashtable)this.env).clear();
            throw new MDSException("Failed to connect.", e);
        }
    }

    public synchronized void disconnect() throws MDSException {
        if (this.ctx != null) {
            try {
                this.ctx.close();
            }
            catch (NamingException e) {
                throw new MDSException("Failed to disconnect.", e);
            }
        }
        this.ctx = null;
        ((Hashtable)this.env).clear();
    }

    public synchronized void reconnect() throws MDSException {
        this.disconnect();
        this.connect();
    }

    public Hashtable search(String filter, int searchScope) throws MDSException {
        return this.search(this.baseDN, filter, null, searchScope);
    }

    public Hashtable search(String filter, String[] attrToReturn, int searchScope) throws MDSException {
        return this.search(this.baseDN, filter, attrToReturn, searchScope);
    }

    public Hashtable search(String baseDN, String filter, int searchScope) throws MDSException {
        return this.search(baseDN, filter, null, searchScope);
    }

    public Hashtable search(String baseDN, String filter, String[] attrToReturn, int searchScope) throws MDSException {
        if (this.ctx == null) {
            throw new MDSException("Error: search failed -- not connected to MDS", (String)null);
        }
        try {
            SearchControls controls = this.createConstraints(searchScope, attrToReturn);
            NamingEnumeration<SearchResult> results = this.ctx.search(baseDN, filter, controls);
            return this.convertSearchResultsH(results, baseDN);
        }
        catch (NamingException e) {
            throw new MDSException("Failed to search.", e);
        }
    }

    public NamingEnumeration searchl(String baseDN, String filter, String[] attrToReturn, int searchScope) throws NamingException {
        SearchControls controls = this.createConstraints(searchScope, attrToReturn);
        NamingEnumeration<SearchResult> results = this.ctx.search(baseDN, filter, controls);
        return results;
    }

    public Hashtable list(String baseDN) throws MDSException {
        try {
            SearchControls constraints = new SearchControls();
            constraints.setSearchScope(1);
            constraints.setReturningAttributes(new String[]{"objectclass"});
            NamingEnumeration<SearchResult> results = this.ctx.search(baseDN, "(objectclass=*)", constraints);
            return this.convertSearchResultsH(results, baseDN);
        }
        catch (NamingException e) {
            throw new MDSException("Failed to list.", e);
        }
    }

    public MDSResult getAttributes(String dn) throws MDSException {
        try {
            BasicAttributes attrs = (BasicAttributes)this.ctx.getAttributes(dn);
            return this.convertAttributes(attrs);
        }
        catch (NamingException e) {
            throw new MDSException("Failed to retreive attributes.", e);
        }
    }

    public MDSResult getAttributes(String dn, String[] attributes) throws MDSException {
        try {
            BasicAttributes attrs = (BasicAttributes)this.ctx.getAttributes(dn, attributes);
            return this.convertAttributes(attrs);
        }
        catch (NamingException e) {
            throw new MDSException("Failed to retreive attributes.", e);
        }
    }

    protected SearchControls createConstraints(int scope, String[] attrToReturn) {
        SearchControls constraints = new SearchControls();
        constraints.setSearchScope(scope);
        constraints.setCountLimit(this.limit);
        constraints.setTimeLimit(this.timeout);
        constraints.setReturningAttributes(attrToReturn);
        return constraints;
    }

    private Vector convertSearchResultsV(NamingEnumeration results, String base) throws NamingException {
        Vector<MDSResult> rs = new Vector<MDSResult>();
        while (results != null && results.hasMoreElements()) {
            SearchResult si = (SearchResult)results.next();
            MDSResult mdsResult = this.convertAttributes(si.getAttributes());
            String name = si.getName().trim();
            if (name.length() == 0) {
                mdsResult.add("dn", base);
            } else {
                mdsResult.add("dn", name + ", " + base);
            }
            rs.addElement(mdsResult);
        }
        return rs;
    }

    private Hashtable convertSearchResultsH(NamingEnumeration results, String base) throws NamingException {
        Hashtable<String, MDSResult> rs = new Hashtable<String, MDSResult>();
        while (results != null && results.hasMoreElements()) {
            SearchResult si = (SearchResult)results.next();
            MDSResult mdsResult = this.convertAttributes(si.getAttributes());
            String name = si.getName().trim();
            if (name.length() == 0) {
                rs.put(base, mdsResult);
                continue;
            }
            rs.put(name + ", " + base, mdsResult);
        }
        return rs;
    }

    private MDSResult convertAttributes(Attributes attrs) throws NamingException {
        MDSResult mdsResult = new MDSResult();
        NamingEnumeration<? extends Attribute> ae = attrs.getAll();
        while (ae.hasMoreElements()) {
            BasicAttribute attr = (BasicAttribute)ae.next();
            String attribute = attr.getID();
            Object[] values = new Object[attr.size()];
            int i = 0;
            NamingEnumeration<?> vals = attr.getAll();
            while (vals.hasMoreElements()) {
                values[i] = vals.nextElement();
                ++i;
            }
            mdsResult.add(attribute, values);
        }
        return mdsResult;
    }

    private Attributes convertAttributes(MDSResult attrs) {
        BasicAttributes atts = new BasicAttributes();
        Enumeration e = attrs.keys();
        while (e.hasMoreElements()) {
            String name = (String)e.nextElement();
            Vector values = attrs.get(name);
            if (name.equals("dn")) continue;
            BasicAttribute at = new BasicAttribute(name);
            int i = 0;
            while (i < values.size()) {
                at.add(values.elementAt(i));
                ++i;
            }
            atts.put(at);
        }
        return atts;
    }

    public void deleteEntry(String dn) throws MDSException {
        try {
            this.ctx.destroySubcontext(dn);
        }
        catch (NamingException e) {
            throw new MDSException("Failed to delete.", e);
        }
    }

    public void renameEntry(String oldDN, String newDN) throws MDSException {
        this.renameEntry(oldDN, newDN, false);
    }

    public void renameEntry(String oldDN, String newDN, boolean deleteOldDN) throws MDSException {
        ((Hashtable)this.env).put("java.naming.ldap.deleteRDN", String.valueOf(deleteOldDN));
        try {
            this.ctx.rename(oldDN, newDN);
        }
        catch (NamingException e) {
            throw new MDSException("Failed to rename.", e);
        }
    }

    public void updateEntry(String dn, MDSResult at) throws MDSException {
        try {
            Attributes ats = this.convertAttributes(at);
            this.ctx.modifyAttributes(dn, 2, ats);
        }
        catch (NamingException e) {
            throw new MDSException("Failed to add attributes for " + dn, e);
        }
    }

    public void addEntry(String dn, MDSResult at) throws MDSException {
        try {
            Attributes ats = this.convertAttributes(at);
            this.ctx.createSubcontext(dn, ats);
        }
        catch (NamingException e) {
            throw new MDSException("Failed to add new entry", e);
        }
    }

    public void deleteAttribute(String dn, String attr) throws MDSException {
        try {
            BasicAttributes ba = new BasicAttributes();
            ba.put(new BasicAttribute(attr));
            this.ctx.modifyAttributes(dn, 3, (Attributes)ba);
        }
        catch (NamingException e) {
            throw new MDSException("Failed to delete attributes for " + dn, e);
        }
    }

    public void deleteValues(String dn, MDSResult at) throws MDSException {
        try {
            Attributes ats = this.convertAttributes(at);
            this.ctx.modifyAttributes(dn, 3, ats);
        }
        catch (NamingException e) {
            throw new MDSException("Failed to delete attributes for " + dn, e);
        }
    }

    public void updateAttribute(String dn, MDSResult at) throws MDSException {
        try {
            Attributes ats = this.convertAttributes(at);
            this.ctx.modifyAttributes(dn, 2, ats);
        }
        catch (NamingException e) {
            throw new MDSException("Failed to update attributes for " + dn, e);
        }
    }

    public void addAttribute(String dn, MDSResult at) throws MDSException {
        try {
            Attributes ats = this.convertAttributes(at);
            this.ctx.modifyAttributes(dn, 1, ats);
        }
        catch (NamingException e) {
            throw new MDSException("Failed to add attributes for " + dn, e);
        }
    }

    public void deleteTree(String dn, boolean deleteItSelf) throws MDSException {
        Vector entries = new Vector();
        try {
            SearchControls constraints = new SearchControls();
            constraints.setSearchScope(2);
            constraints.setReturningAttributes(new String[]{"objectclass"});
            NamingEnumeration<SearchResult> results = this.ctx.search(dn, "(objectclass=*)", constraints);
            entries = this.convertSearchResultsV(results, dn);
            if (entries.size() > 0 && !deleteItSelf) {
                entries.removeElementAt(0);
            }
            int i = entries.size() - 1;
            while (i >= 0) {
                MDSResult mdsResult = (MDSResult)entries.elementAt(i);
                String mdsResultDN = (String)mdsResult.getFirstValue("dn");
                this.ctx.destroySubcontext(mdsResultDN);
                --i;
            }
        }
        catch (NamingException e) {
            throw new MDSException("Failed to delete tree.", e);
        }
    }
}

