/*
 * Decompiled with CFR 0.152.
 */
package org.globus.net;

import java.io.IOException;
import org.globus.common.CoGProperties;

public class PortRange {
    protected static final byte UNUSED = 0;
    protected static final byte USED = 1;
    private boolean portRange = false;
    private int minPort;
    private int maxPort;
    private byte[] ports;
    private static PortRange defaultPortRange = null;

    protected PortRange() {
        this.init();
    }

    public static synchronized PortRange getInstance() {
        if (defaultPortRange == null) {
            defaultPortRange = new PortRange();
        }
        return defaultPortRange;
    }

    public boolean isEnabled() {
        return this.portRange;
    }

    public int getFreePort(int lastPortNumber) throws IOException {
        int id = 0;
        if (lastPortNumber != 0 && (id = lastPortNumber - this.minPort) < 0) {
            throw new IOException("Port number out of range.");
        }
        int i = id;
        while (i < this.ports.length) {
            if (this.ports[i] != 1) {
                return this.minPort + i;
            }
            ++i;
        }
        throw new IOException("No free ports available.");
    }

    public void setUsed(int portNumber) {
        this.setPort(portNumber, (byte)1);
    }

    public void free(int portNumber) {
        this.setPort(portNumber, (byte)0);
    }

    private void setPort(int portNumber, byte type) {
        int id = portNumber - this.minPort;
        if (id < 0) {
            throw new IllegalArgumentException("Port number out of range: " + portNumber);
        }
        this.ports[id] = type;
    }

    private void init() {
        this.init(CoGProperties.getDefault().getTcpPortRange());
    }

    private void init(String portRangeStr) {
        int max;
        int min;
        this.portRange = false;
        if (portRangeStr == null) {
            return;
        }
        int pos = portRangeStr.indexOf(",");
        if (pos == -1) {
            throw new IllegalArgumentException("Missing comma in the port range property: " + portRangeStr);
        }
        try {
            min = Integer.parseInt(portRangeStr.substring(0, pos).trim());
        }
        catch (Exception e) {
            throw new IllegalArgumentException("The minimum port range value is invalid: " + e.getMessage());
        }
        try {
            max = Integer.parseInt(portRangeStr.substring(pos + 1).trim());
        }
        catch (Exception e) {
            throw new IllegalArgumentException("The maximum port range value is invalid: " + e.getMessage());
        }
        if (min >= max) {
            throw new IllegalArgumentException("The minimum port range value is greater then the maximum port range value.");
        }
        this.minPort = min;
        this.maxPort = max;
        this.ports = new byte[this.maxPort - this.minPort];
        this.portRange = true;
    }
}

