/*
 * Decompiled with CFR 0.152.
 */
package org.globus.tools;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.security.GeneralSecurityException;
import java.security.KeyStore;
import java.security.cert.X509Certificate;
import org.globus.common.CoGProperties;
import org.globus.common.Version;
import org.globus.gsi.CertUtil;
import org.globus.gsi.bc.BouncyCastleOpenSSLKey;
import org.globus.util.Util;

public class KeyStoreConvert {
    public static final String DEFAULT_ALIAS = "globus";
    public static final String DEFAULT_PASSWORD = "globus";
    public static final String DEFAULT_KEYSTORE_FILE = "globus.jks";
    private static final String message = "\nSyntax: java KeyStoreConvert [options]\n        java KeyStoreConvert -help\n\n\tConverts Globus credentials (user key and certificate) into \n\tJava keystore format (JKS format supported by Sun).\n\n\tOptions\n\t-help | -usage\n\t\tDisplays usage.\n\t-version\n\t\tDisplays version.\n\t-debug\n\t\tEnables extra debug output.\n\t-cert     <certfile>\n\t\tNon-standard location of user certificate.\n\t-key      <keyfile>\n\t\tNon-standard location of user key.\n\t-alias    <alias>\n\t\tKeystore alias entry. Defaults to 'globus'\n\t-password <password>\n\t\tKeystore password. Defaults to 'globus'\n\t-out      <keystorefile>\n\t\tLocation of the Java keystore file. Defaults to\n\t\t'globus.jks'\n\n";

    public static void main(String[] args) {
        File f;
        CoGProperties props = CoGProperties.getDefault();
        boolean error = false;
        boolean debug = false;
        String alias = "globus";
        String password = "globus";
        String keyFile = props.getUserKeyFile();
        String certFile = props.getUserCertFile();
        String keyStoreFile = DEFAULT_KEYSTORE_FILE;
        int i = 0;
        while (i < args.length) {
            if (args[i].equalsIgnoreCase("-debug")) {
                debug = true;
            } else if (args[i].equalsIgnoreCase("-out")) {
                keyStoreFile = args[++i];
            } else if (args[i].equalsIgnoreCase("-key")) {
                keyFile = args[++i];
            } else if (args[i].equalsIgnoreCase("-cert")) {
                certFile = args[++i];
            } else if (args[i].equalsIgnoreCase("-alias")) {
                alias = args[++i];
            } else if (args[i].equalsIgnoreCase("-pwd") || args[i].equalsIgnoreCase("-password")) {
                password = args[++i];
            } else if (args[i].equalsIgnoreCase("-version")) {
                System.err.println(Version.getVersion());
                System.exit(1);
            } else if (args[i].equalsIgnoreCase("-help") || args[i].equalsIgnoreCase("-usage")) {
                System.err.println(message);
                System.exit(1);
            } else {
                System.err.println("Error: Argument not recognized: " + args[i]);
                error = true;
            }
            ++i;
        }
        if (error) {
            return;
        }
        if (keyStoreFile == null) {
            System.err.println("Error: Java key store output file is not specified.");
            return;
        }
        if (debug) {
            System.out.println("### Current settings ###");
            System.out.println("       Certificate file : " + certFile);
            System.out.println("        SSLeay key file : " + keyFile);
            System.out.println("     Java keystore file : " + keyStoreFile);
            System.out.println("        Key entry Alias : " + alias);
            System.out.println(" Java keystore password : " + password);
        }
        if ((f = new File(keyStoreFile)).exists()) {
            System.err.println("Error: Output file (" + keyStoreFile + ") already exists.");
            return;
        }
        int rs = KeyStoreConvert.createKeyStore(certFile, keyFile, alias, password, keyStoreFile, debug);
        System.exit(rs);
    }

    /*
     * Unable to fully structure code
     */
    private static int createKeyStore(String certFile, String keyFile, String alias, String password, String keyStoreFile, boolean debug) {
        block19: {
            certs = new X509Certificate[1];
            key = null;
            try {
                certs[0] = CertUtil.loadCertificate(certFile);
            }
            catch (Exception e) {
                System.err.println("Failed to load certificate: " + e.getMessage());
                return -1;
            }
            try {
                sslkey = new BouncyCastleOpenSSLKey(keyFile);
                if (sslkey.isEncrypted()) {
                    pwd = Util.getInput("Enter pass phrase: ");
                    if (pwd == null) {
                        return -2;
                    }
                    sslkey.decrypt(pwd);
                }
                key = sslkey.getPrivateKey();
            }
            catch (IOException e) {
                System.err.println("Failed to load key: " + e.getMessage());
                return -1;
            }
            catch (GeneralSecurityException e) {
                System.err.println("Error: Wrong pass phrase");
                if (debug) {
                    e.printStackTrace();
                }
                return -1;
            }
            System.out.println("Creating Java keystore...");
            out = null;
            try {
                ks = KeyStore.getInstance("JKS", "SUN");
                ks.load(null, null);
                ks.setKeyEntry(alias, key, password.toCharArray(), certs);
                out = new FileOutputStream(keyStoreFile);
                ks.store(out, password.toCharArray());
                var12_14 = null;
                ** if (out == null) goto lbl-1000
            }
            catch (Throwable var11_21) {
                var12_16 = null;
                if (out != null) {
                    try {
                        out.close();
                    }
                    catch (IOException ee) {
                        // empty catch block
                    }
                }
                throw var11_21;
            }
lbl-1000:
            // 1 sources

            {
                try {
                    out.close();
                }
                catch (IOException ee) {}
            }
lbl-1000:
            // 2 sources

            {
                break block19;
                catch (Exception e) {
                    System.err.println("Failed to create Java key store: " + e.getMessage());
                    var10_20 = -1;
                    var12_15 = null;
                    if (out != null) {
                        try {
                            out.close();
                        }
                        catch (IOException ee) {
                            // empty catch block
                        }
                    }
                    return var10_20;
                }
            }
        }
        System.out.println("Java keystore file (" + keyStoreFile + ") successfully created.");
        return 0;
    }
}

