/*
 * Decompiled with CFR 0.152.
 */
package org.globus.tools.proxy;

import java.awt.Component;
import java.awt.Container;
import java.awt.Dialog;
import java.awt.Frame;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.FileOutputStream;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JPasswordField;
import javax.swing.JProgressBar;
import javax.swing.Timer;
import org.globus.gsi.CertUtil;
import org.globus.gsi.GlobusCredential;
import org.globus.tools.proxy.DefaultGridProxyModel;
import org.globus.tools.proxy.GridProxyModel;
import org.globus.tools.proxy.ProxyListener;
import org.globus.tools.proxy.ProxyOptionsWindow;
import org.globus.tools.ui.util.UITools;
import org.globus.util.Util;

public class GridProxyInit
extends JDialog
implements ActionListener {
    private static final String PKCS11_MODEL = "org.globus.tools.proxy.PKCS11GridProxyModel";
    private final int MAX = 10;
    private JPasswordField passwordTF;
    private JButton optionsButton;
    private JButton cancelButton;
    private JButton createButton;
    private JCheckBox PKCS11Box = null;
    private GridProxyModel model = null;
    private ProxyListener proxyListener = null;
    private GlobusCredential proxy = null;
    private boolean runAsApplication = false;
    private boolean closeOnSuccess = false;
    private boolean saveProxy = true;

    public GridProxyInit(Frame owner, boolean modal) {
        super(owner, modal);
        this.init();
    }

    public GridProxyInit() {
        this.init();
    }

    private void init() {
        this.setTitle("Grid Proxy Init");
        this.optionsButton = new JButton("Options");
        this.optionsButton.addActionListener(this);
        this.passwordTF = new JPasswordField(15);
        this.passwordTF.addActionListener(this);
        JPanel passPanel = new JPanel();
        passPanel.add(new JLabel("Password: "));
        passPanel.add(this.passwordTF);
        passPanel.add(this.optionsButton);
        JPanel buttonPanel = new JPanel(new GridLayout(1, 2, 2, 2));
        this.createButton = new JButton("Create");
        this.cancelButton = new JButton("Cancel");
        JPanel btPanel = new JPanel();
        btPanel.add(buttonPanel);
        buttonPanel.add(this.createButton);
        buttonPanel.add(this.cancelButton);
        this.createButton.addActionListener(this);
        this.cancelButton.addActionListener(this);
        JPanel ibutPanel = new JPanel();
        this.PKCS11Box = new JCheckBox("Use PKCS11 Device");
        ibutPanel.add(this.PKCS11Box);
        Container contentPane = this.getContentPane();
        BoxLayout bl = new BoxLayout(contentPane, 1);
        contentPane.setLayout(bl);
        contentPane.add(passPanel);
        contentPane.add(ibutPanel);
        contentPane.add(btPanel);
        this.checkPKCS11Support();
    }

    private void checkPKCS11Support() {
        try {
            Class<?> iClass = Class.forName(PKCS11_MODEL);
            this.PKCS11Box.setEnabled(true);
        }
        catch (Exception e) {
            this.PKCS11Box.setEnabled(false);
        }
    }

    private void setCloseButtonText() {
        if (this.runAsApplication) {
            this.cancelButton.setText("Exit");
        } else {
            this.cancelButton.setText("Cancel");
        }
    }

    public void actionPerformed(ActionEvent evt) {
        Object source = evt.getSource();
        if (source == this.passwordTF) {
            source = this.createButton;
        }
        if (source == this.createButton) {
            if (!this.validateSettings()) {
                return;
            }
            Thread th = new Thread(){

                public void run() {
                    GridProxyInit.this.createButton.setEnabled(false);
                    GridProxyInit.this.cancelButton.setEnabled(false);
                    GridProxyInit.this.optionsButton.setEnabled(false);
                    GridProxyInit.this.createProxy(GridProxyInit.this.PKCS11Box.isSelected());
                    GridProxyInit.this.createButton.setEnabled(true);
                    GridProxyInit.this.cancelButton.setEnabled(true);
                    GridProxyInit.this.optionsButton.setEnabled(true);
                }
            };
            th.start();
        } else if (source == this.optionsButton) {
            this.model = this.getModel(this.PKCS11Box.isSelected());
            ProxyOptionsWindow wind = new ProxyOptionsWindow((Dialog)this, true, this.PKCS11Box.isSelected());
            wind.setProperties(this.model.getProperties());
            wind.pack();
            UITools.center(this, wind);
            ((Component)wind).setVisible(true);
        } else if (source == this.cancelButton) {
            this.close(0);
        }
    }

    private boolean validateSettings() {
        char[] pwd = this.passwordTF.getPassword();
        if (pwd.length == 0) {
            JOptionPane.showMessageDialog(this, "Please enter your password.", "Need More Information", 2);
            return false;
        }
        return true;
    }

    private GridProxyModel getModel(boolean usePKCS11Device) {
        if (usePKCS11Device) {
            try {
                Class<?> iClass = Class.forName(PKCS11_MODEL);
                return (GridProxyModel)iClass.newInstance();
            }
            catch (Exception e) {
                return new DefaultGridProxyModel();
            }
        }
        return new DefaultGridProxyModel();
    }

    private void createProxy(boolean usePKCS11Device) {
        JLabel msgLabel = new JLabel("Creating proxy...");
        final JProgressBar progressBar = new JProgressBar(0, 10);
        progressBar.setValue(0);
        Object[] comp = new Object[]{msgLabel, progressBar};
        Object[] options = new Object[]{"Cancel"};
        JOptionPane pane = new JOptionPane(comp, -1, 1, null, options, options[0]);
        final JDialog dialog = pane.createDialog(this, "Creating Proxy");
        final Task task = new Task();
        Timer timer = new Timer(250, new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                if (task.isDone()) {
                    ((Component)dialog).setVisible(false);
                } else {
                    progressBar.setValue((progressBar.getValue() + 1) % 10);
                }
            }
        });
        timer.start();
        task.start();
        try {
            Thread.sleep(500L);
        }
        catch (Exception e) {
            // empty catch block
        }
        Object selectedValue = null;
        if (task.getException() == null) {
            dialog.show();
            selectedValue = pane.getValue();
        } else {
            selectedValue = JOptionPane.UNINITIALIZED_VALUE;
        }
        timer.stop();
        if (selectedValue == null || selectedValue == options[0]) {
            task.cancel();
            this.proxy = null;
        } else if (selectedValue == JOptionPane.UNINITIALIZED_VALUE) {
            Exception e = task.getException();
            if (e == null) {
                this.proxy = task.getProxy();
                JOptionPane.showMessageDialog(this, "Proxy was successfully created.", "Proxy Created", 1);
                if (this.closeOnSuccess) {
                    ((Component)this).setVisible(false);
                }
            } else {
                this.proxy = null;
                JOptionPane.showMessageDialog(this, "Failed to create proxy: " + e.getMessage(), "Proxy Create Error", 0);
            }
        } else {
            this.proxy = null;
        }
    }

    public void addProxyListener(ProxyListener listener) {
        this.proxyListener = listener;
    }

    public void setRunAsApplication(boolean runAsApp) {
        this.runAsApplication = runAsApp;
        this.setCloseButtonText();
    }

    public void setCloseOnSuccess(boolean close) {
        this.closeOnSuccess = close;
    }

    public void saveProxy(boolean saveProxy) {
        this.saveProxy = saveProxy;
    }

    public GlobusCredential getProxy() {
        return this.proxy;
    }

    private void close(int errorCode) {
        if (this.runAsApplication) {
            System.exit(errorCode);
        } else {
            ((Component)this).setVisible(false);
        }
    }

    public static void main(String[] args) {
        CertUtil.init();
        GridProxyInit gpiFrame = new GridProxyInit(null, true);
        gpiFrame.setRunAsApplication(true);
        gpiFrame.saveProxy(true);
        WindowAdapter l = new WindowAdapter(){

            public void windowClosing(WindowEvent e) {
                System.exit(0);
            }
        };
        gpiFrame.addWindowListener(l);
        gpiFrame.pack();
        UITools.center(null, gpiFrame);
        ((Component)gpiFrame).setVisible(true);
    }

    static /* synthetic */ GridProxyModel access$502(GridProxyInit x0, GridProxyModel x1) {
        x0.model = x1;
        return x0.model;
    }

    static /* synthetic */ GridProxyModel access$600(GridProxyInit x0, boolean x1) {
        return x0.getModel(x1);
    }

    static /* synthetic */ JPasswordField access$700(GridProxyInit x0) {
        return x0.passwordTF;
    }

    static /* synthetic */ GridProxyModel access$500(GridProxyInit x0) {
        return x0.model;
    }

    static /* synthetic */ boolean access$800(GridProxyInit x0) {
        return x0.saveProxy;
    }

    static /* synthetic */ ProxyListener access$900(GridProxyInit x0) {
        return x0.proxyListener;
    }

    class Task
    extends Thread {
        private boolean done = false;
        private Exception exception = null;
        private boolean cancel = false;
        private GlobusCredential proxy = null;

        Task() {
        }

        public boolean isDone() {
            return this.done;
        }

        public void cancel() {
            this.cancel = true;
        }

        public boolean isCancelled() {
            return this.cancel;
        }

        public GlobusCredential getProxy() {
            return this.proxy;
        }

        /*
         * Unable to fully structure code
         */
        public void run() {
            GridProxyInit.access$502(GridProxyInit.this, GridProxyInit.access$600(GridProxyInit.this, GridProxyInit.access$300(GridProxyInit.this).isSelected()));
            try {
                this.proxy = GridProxyInit.access$500(GridProxyInit.this).createProxy(new String(GridProxyInit.access$700(GridProxyInit.this).getPassword()));
            }
            catch (Exception e) {
                this.exception = e;
                this.done = true;
                return;
            }
            if (this.cancel) {
                return;
            }
            if (GridProxyInit.access$800(GridProxyInit.this)) {
                block17: {
                    out = null;
                    proxyFile = GridProxyInit.access$500(GridProxyInit.this).getProperties().getProxyFile();
                    try {
                        out = new FileOutputStream(proxyFile);
                        Util.setFilePermissions(proxyFile, 600);
                        this.proxy.save(out);
                        var5_4 = null;
                        ** if (out == null) goto lbl-1000
                    }
                    catch (Throwable var4_11) {
                        var5_6 = null;
                        if (out != null) {
                            try {
                                out.close();
                            }
                            catch (Exception e) {
                                // empty catch block
                            }
                        }
                        throw var4_11;
                    }
lbl-1000:
                    // 1 sources

                    {
                        try {
                            out.close();
                        }
                        catch (Exception e) {}
                    }
lbl-1000:
                    // 2 sources

                    {
                        break block17;
                        catch (Exception e) {
                            this.exception = e;
                            this.done = true;
                            var5_5 = null;
                            if (out != null) {
                                try {
                                    out.close();
                                }
                                catch (Exception e) {
                                    // empty catch block
                                }
                            }
                            return;
                        }
                    }
                }
                if (this.cancel) {
                    return;
                }
            }
            if (GridProxyInit.access$900(GridProxyInit.this) != null) {
                GridProxyInit.access$900(GridProxyInit.this).proxyCreated(this.proxy);
            }
            this.done = true;
        }

        public Exception getException() {
            return this.exception;
        }
    }
}

