/*
 * Decompiled with CFR 0.152.
 */
package org.globus.util;

import java.io.IOException;
import java.io.OutputStream;

public class PEMUtils {
    static final int LINE_LENGTH = 64;
    public static String lineSep = System.getProperty("line.separator");
    public static byte[] lineSepBytes = lineSep.getBytes();
    private static final char[] hex = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'A', 'B', 'C', 'D', 'E', 'F'};

    public static void writeBase64(OutputStream out, String header, byte[] base64Data, String footer) throws IOException {
        int length = 64;
        int offset = 0;
        if (header != null) {
            out.write(header.getBytes());
            out.write(lineSepBytes);
        }
        int size = base64Data.length;
        while (offset < size) {
            if (64 > size - offset) {
                length = size - offset;
            }
            out.write(base64Data, offset, length);
            out.write(lineSepBytes);
            offset += 64;
        }
        if (footer != null) {
            out.write(footer.getBytes());
            out.write(lineSepBytes);
        }
    }

    public static final String toHex(byte[] b) {
        char[] buf = new char[b.length * 2];
        int j = 0;
        int i = 0;
        while (i < b.length) {
            byte k = b[i];
            buf[j++] = hex[k >>> 4 & 0xF];
            buf[j++] = hex[k & 0xF];
            ++i;
        }
        return new String(buf);
    }
}

