/*
 * Decompiled with CFR 0.152.
 */
package cryptix.asn1.encoding;

import cryptix.asn1.encoding.BaseCoder;
import cryptix.asn1.encoding.CoderOperations;
import cryptix.asn1.encoding.PackageProperties;
import cryptix.asn1.lang.ASNAny;
import cryptix.asn1.lang.ASNBitString;
import cryptix.asn1.lang.ASNBoolean;
import cryptix.asn1.lang.ASNInteger;
import cryptix.asn1.lang.ASNNull;
import cryptix.asn1.lang.ASNObjectIdentifier;
import cryptix.asn1.lang.ASNOctetString;
import cryptix.asn1.lang.ASNPrintableString;
import cryptix.asn1.lang.ASNSequence;
import cryptix.asn1.lang.ASNSequenceOf;
import cryptix.asn1.lang.ASNSet;
import cryptix.asn1.lang.ASNSetOf;
import cryptix.asn1.lang.ASNTaggedType;
import cryptix.asn1.lang.ASNTime;
import cryptix.asn1.lang.Parser;
import cryptix.asn1.lang.SimpleNode;
import cryptix.asn1.lang.Tag;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.EOFException;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.math.BigInteger;
import java.util.Calendar;
import java.util.StringTokenizer;
import java.util.TimeZone;
import java.util.Vector;

public class DER
extends BaseCoder {
    private static final String NAME = "DER";
    private static final boolean IN = true;
    private static final boolean OUT = false;
    private static final boolean DEBUG = false;
    private static final int debuglevel = 0;
    private static final PrintWriter err = null;
    private static final boolean TRACE = PackageProperties.isTraceable("DER");

    private static void debug(String string) {
        ((PrintWriter)null).println(">>> DER: " + string);
    }

    public void decode(ASNAny aSNAny, InputStream inputStream) throws IOException {
        byte[] byArray = this.getTLV(inputStream);
        if (byArray != null) {
            aSNAny.setValue(byArray);
        }
    }

    public void decode(ASNBitString aSNBitString, InputStream inputStream) throws IOException {
        if (!this.isExpectedTag(3, inputStream)) {
            String string = "Not a BIT STRING";
            if (!aSNBitString.isOptional()) {
                throw new IOException(string);
            }
        } else {
            int n = DER.decodeLength(inputStream);
            byte[] byArray = new byte[n];
            int n2 = inputStream.read(byArray);
            if (n2 == -1) {
                throw new EOFException();
            }
            if (n2 != n) {
                throw new IOException("Length (" + n + ") mismatch: " + n2);
            }
            aSNBitString.setValue(byArray);
        }
    }

    public void decode(ASNBoolean aSNBoolean, InputStream inputStream) throws IOException {
        if (!this.isExpectedTag(1, inputStream)) {
            String string = "Not a BOOLEAN";
            if (!aSNBoolean.isOptional()) {
                throw new IOException(string);
            }
        } else {
            int n = DER.decodeLength(inputStream);
            if (n != 1) {
                throw new IOException("Incorrect BOOLEAN length: " + n);
            }
            int n2 = inputStream.read();
            if (n2 == -1) {
                throw new EOFException();
            }
            aSNBoolean.setValue(new Boolean(n2 != 0));
        }
    }

    public void decode(ASNInteger aSNInteger, InputStream inputStream) throws IOException {
        if (!this.isExpectedTag(2, inputStream)) {
            String string = "Not an INTEGER";
            if (!aSNInteger.isOptional()) {
                throw new IOException(string);
            }
        } else {
            int n = DER.decodeLength(inputStream);
            byte[] byArray = new byte[n];
            int n2 = inputStream.read(byArray);
            if (n2 == -1) {
                throw new EOFException();
            }
            if (n2 != n) {
                throw new IOException("Length (" + n + ") mismatch: " + n2);
            }
            aSNInteger.setValue(new BigInteger(1, byArray));
        }
    }

    public void decode(ASNNull aSNNull, InputStream inputStream) throws IOException {
        if (!this.isExpectedTag(5, inputStream)) {
            String string = "Not a NULL";
            if (!aSNNull.isOptional()) {
                throw new IOException(string);
            }
        } else {
            int n = DER.decodeLength(inputStream);
            if (n != 0) {
                throw new IOException("Incorrect NULL length: " + n);
            }
        }
    }

    public void decode(ASNObjectIdentifier aSNObjectIdentifier, InputStream inputStream) throws IOException {
        if (!this.isExpectedTag(6, inputStream)) {
            String string = "Not an OBJECT-IDENTIFIER";
            if (!aSNObjectIdentifier.isOptional()) {
                throw new IOException(string);
            }
        } else {
            int n;
            int n2;
            int n3 = DER.decodeLength(inputStream);
            StringBuffer stringBuffer = new StringBuffer();
            if (--n3 >= 0) {
                n2 = inputStream.read() & 0xFF;
                n = n2 < 40 ? 0 : (n2 < 80 ? 1 : 2);
                int n4 = n2 - n * 40;
                stringBuffer.append(n).append(".").append(n4);
            }
            while (n3 > 0) {
                stringBuffer.append(".");
                n2 = 0;
                do {
                    n = inputStream.read() & 0xFF;
                    n2 = n2 << 7 | n & 0x7F;
                } while (--n3 > 0 && (n & 0x80) == 128);
                stringBuffer.append(n2);
            }
            aSNObjectIdentifier.setValue(new String(stringBuffer));
        }
    }

    public void decode(ASNOctetString aSNOctetString, InputStream inputStream) throws IOException {
        if (!this.isExpectedTag(4, inputStream)) {
            String string = "Not an OCTET STRING";
            if (!aSNOctetString.isOptional()) {
                throw new IOException(string);
            }
        } else {
            int n = DER.decodeLength(inputStream);
            byte[] byArray = new byte[n];
            int n2 = inputStream.read(byArray);
            if (n2 == -1) {
                throw new EOFException();
            }
            if (n2 != n) {
                throw new IOException("Length (" + n + ") mismatch: " + n2);
            }
            aSNOctetString.setValue(byArray);
        }
    }

    public void decode(ASNPrintableString aSNPrintableString, InputStream inputStream) throws IOException {
        if (!this.isExpectedTag(19, inputStream)) {
            String string = "Not a PrintableString or IA5String";
            if (!aSNPrintableString.isOptional()) {
                throw new IOException(string);
            }
        } else {
            int n = DER.decodeLength(inputStream);
            byte[] byArray = new byte[n];
            int n2 = inputStream.read(byArray);
            if (n2 == -1) {
                throw new EOFException();
            }
            if (n2 != n) {
                throw new IOException("Length (" + n + ") mismatch: " + n2);
            }
            aSNPrintableString.setValue(new String(byArray, "ISO_8859-1"));
        }
    }

    public void decode(ASNSequence aSNSequence, InputStream inputStream) throws IOException {
        this.decodeSequence(aSNSequence, inputStream);
    }

    public void decode(ASNSequenceOf aSNSequenceOf, InputStream inputStream) throws IOException {
        this.decodeSequence(aSNSequenceOf, inputStream);
    }

    public void decode(ASNSet aSNSet, InputStream inputStream) throws IOException {
        this.decodeSet(aSNSet, inputStream);
    }

    public void decode(ASNSetOf aSNSetOf, InputStream inputStream) throws IOException {
        this.decodeSet(aSNSetOf, inputStream);
    }

    public void decode(ASNTaggedType aSNTaggedType, InputStream inputStream) throws IOException {
        Tag tag = aSNTaggedType.getTag();
        inputStream.mark(10);
        if (this.isExpectedTag(tag, inputStream)) {
            if (tag.isExplicit()) {
                this.decodeExplicitTaggedType(aSNTaggedType, inputStream);
            } else {
                inputStream.reset();
                this.decodeImplicitTaggedType(aSNTaggedType, inputStream);
            }
        } else {
            String string = "Failed to read a non-optional element";
            Object object = aSNTaggedType.getDefaultValue();
            if (object == null && !aSNTaggedType.isOptional()) {
                throw new IOException(string);
            }
            if (object != null) {
                aSNTaggedType.setValue(object);
            }
            inputStream.reset();
        }
    }

    public void decode(ASNTime aSNTime, InputStream inputStream) throws IOException {
        if (!this.isExpectedTag(23, inputStream)) {
            String string = "Not a UTC_TIME";
            if (!aSNTime.isOptional()) {
                throw new IOException(string);
            }
        } else {
            int n = DER.decodeLength(inputStream);
            byte[] byArray = new byte[n];
            int n2 = inputStream.read(byArray);
            if (n2 == -1) {
                throw new EOFException();
            }
            if (n2 != n) {
                throw new IOException("Length (" + n + ") mismatch: " + n2);
            }
            Calendar calendar = Calendar.getInstance(TimeZone.getTimeZone("UTC"));
            int n3 = (byArray[0] - 48) * 10 + (byArray[1] - 48);
            int n4 = (byArray[2] - 48) * 10 + (byArray[3] - 48) - 1;
            int n5 = (byArray[4] - 48) * 10 + (byArray[5] - 48);
            int n6 = (byArray[6] - 48) * 10 + (byArray[7] - 48);
            int n7 = (byArray[8] - 48) * 10 + (byArray[9] - 48);
            int n8 = 0;
            n3 += n3 <= 50 ? 2000 : 1900;
            if (byArray[10] != 90) {
                n8 = (byArray[10] - 48) * 10 + (byArray[11] - 48);
                if (byArray[12] != 90) {
                    throw new IOException("Bad date format");
                }
            }
            calendar.set(n3, n4, n5, n6, n7, n8);
            aSNTime.setValue(calendar.getTime());
        }
    }

    public void decode(InputStream inputStream, int n) throws IOException {
        Vector<Component> vector = new Vector<Component>();
        while (inputStream.available() != 0) {
            try {
                Tag tag = Tag.decode(inputStream);
                int n2 = DER.decodeLength(inputStream);
                byte[] byArray = new byte[n2];
                inputStream.read(byArray);
                vector.addElement(new Component(tag, n2, byArray));
            }
            catch (EOFException eOFException) {
                eOFException.printStackTrace((PrintWriter)null);
                break;
            }
        }
    }

    public void decodeExplicitTaggedType(ASNTaggedType aSNTaggedType, InputStream inputStream) throws IOException {
        int n = DER.decodeLength(inputStream);
        byte[] byArray = new byte[n];
        int n2 = inputStream.read(byArray);
        if (n2 == -1) {
            throw new EOFException();
        }
        if (n2 != n) {
            throw new IOException("Length (" + n + ") mismatch: " + n2);
        }
        CoderOperations coderOperations = BaseCoder.getInstance(NAME);
        coderOperations.init(new ByteArrayInputStream(byArray));
        aSNTaggedType.getParser();
        SimpleNode simpleNode = (SimpleNode)Parser.resolve(aSNTaggedType.getName());
        Object object = simpleNode.childrenAccept(coderOperations, null);
        String string = "********************* New value: XXX";
        aSNTaggedType.setValue(object);
    }

    public boolean decodeImplicitTaggedType(ASNTaggedType aSNTaggedType, InputStream inputStream) throws IOException {
        byte[] byArray = Tag.getTag(inputStream);
        Tag tag = aSNTaggedType.getTag();
        if (tag.isExplicit()) {
            return false;
        }
        int n = DER.decodeLength(inputStream);
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        if (aSNTaggedType.jjtGetNumChildren() != 1) {
            String string = "Implicitly Tagged types must have exactly one child";
            throw new IOException(string);
        }
        Tag tag2 = aSNTaggedType.getChild(0).getTag();
        if (tag2 == null) {
            byteArrayOutputStream.write(byArray);
        } else {
            byteArrayOutputStream.write(tag2.getValue());
        }
        DER.encodeLength(n, byteArrayOutputStream);
        byte[] byArray2 = byteArrayOutputStream.toByteArray();
        byte[] byArray3 = new byte[n + byArray2.length];
        System.arraycopy(byArray2, 0, byArray3, 0, byArray2.length);
        int n2 = inputStream.read(byArray3, byArray2.length, n);
        if (n2 == -1) {
            throw new EOFException();
        }
        if (n2 != n) {
            throw new IOException("Length (" + n + ") mismatch: " + n2);
        }
        CoderOperations coderOperations = BaseCoder.getInstance(NAME);
        coderOperations.init(new ByteArrayInputStream(byArray3));
        Object object = aSNTaggedType.childrenAccept(coderOperations, null);
        aSNTaggedType.setValue(object);
        return true;
    }

    private static int decodeLength(InputStream inputStream) throws IOException {
        int n;
        int n2 = inputStream.read();
        if ((n2 & 0x80) == 0) {
            n = n2;
        } else {
            if ((n2 &= 0x7F) > 4) {
                throw new IOException("ASN.1 DER object too large");
            }
            n = 0;
            while (n2-- > 0) {
                n = n << 8 | inputStream.read() & 0xFF;
            }
        }
        return n;
    }

    private void decodeSequence(SimpleNode simpleNode, InputStream inputStream) throws IOException {
        if (!this.isExpectedTag(16, inputStream) && !this.isExpectedTag(48, inputStream)) {
            String string = "Not a SEQUENCE [OF]";
            if (!simpleNode.isOptional()) {
                throw new IOException(string);
            }
        } else {
            int n = DER.decodeLength(inputStream);
            byte[] byArray = new byte[n];
            int n2 = inputStream.read(byArray);
            if (n2 == -1) {
                throw new EOFException();
            }
            if (n2 != n) {
                throw new IOException("Length (" + n + ") mismatch: " + n2);
            }
            CoderOperations coderOperations = BaseCoder.getInstance(NAME);
            ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(byArray);
            coderOperations.init(byteArrayInputStream);
            Vector<Object> vector = new Vector<Object>();
            while (byteArrayInputStream.available() != 0) {
                Object object = simpleNode.childrenAccept(coderOperations, null);
                if (object == null) continue;
                vector.addElement(object);
            }
            simpleNode.setValue(vector);
        }
    }

    private void decodeSet(SimpleNode simpleNode, InputStream inputStream) throws IOException {
        if (!this.isExpectedTag(17, inputStream) && !this.isExpectedTag(49, inputStream)) {
            String string = "Not a SET [OF]";
            if (!simpleNode.isOptional()) {
                throw new IOException(string);
            }
        } else {
            int n = DER.decodeLength(inputStream);
            byte[] byArray = new byte[n];
            int n2 = inputStream.read(byArray);
            if (n2 == -1) {
                throw new EOFException();
            }
            if (n2 != n) {
                throw new IOException("Length (" + n + ") mismatch: " + n2);
            }
            CoderOperations coderOperations = BaseCoder.getInstance(NAME);
            ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(byArray);
            coderOperations.init(byteArrayInputStream);
            Vector<Object> vector = new Vector<Object>();
            while (byteArrayInputStream.available() != 0) {
                Object object = simpleNode.childrenAccept(coderOperations, null);
                vector.addElement(object);
            }
            simpleNode.setValue(vector);
        }
    }

    public void encode(ASNBoolean aSNBoolean, OutputStream outputStream) throws IOException {
        boolean bl = (Boolean)aSNBoolean.getValue();
        outputStream.write(1);
        DER.encodeLength(1, outputStream);
        outputStream.write(bl ? 1 : 0);
    }

    public void encode(ASNNull aSNNull, OutputStream outputStream) throws IOException {
        outputStream.write(5);
        DER.encodeLength(0, outputStream);
    }

    public void encode(ASNObjectIdentifier aSNObjectIdentifier, OutputStream outputStream) throws IOException {
        String string = (String)aSNObjectIdentifier.getValue();
        StringTokenizer stringTokenizer = new StringTokenizer(string, ".");
        int[] nArray = new int[stringTokenizer.countTokens()];
        int n = 0;
        while (n < nArray.length) {
            nArray[n] = Integer.parseInt(stringTokenizer.nextToken());
            ++n;
        }
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        byteArrayOutputStream.write(nArray[0] * 40 + nArray[1]);
        int n2 = 2;
        while (n2 < nArray.length) {
            int n3 = nArray[n2];
            byte[] byArray = new byte[4];
            int n4 = 0;
            while (n4 < 4) {
                byArray[n4] = (byte)(n3 & 0x7F);
                if ((n3 >>>= 7) == 0) break;
                ++n4;
            }
            while (n4 > 0) {
                byteArrayOutputStream.write(byArray[n4] | 0x80);
                --n4;
            }
            byteArrayOutputStream.write(byArray[0]);
            ++n2;
        }
        outputStream.write(6);
        DER.encodeLength(byteArrayOutputStream.size(), outputStream);
        byteArrayOutputStream.writeTo(outputStream);
    }

    public void encode(ASNOctetString aSNOctetString, OutputStream outputStream) throws IOException {
        byte[] byArray = (byte[])aSNOctetString.getValue();
        outputStream.write(4);
        DER.encodeLength(byArray.length, outputStream);
        outputStream.write(byArray);
    }

    public void encode(ASNSequence aSNSequence, OutputStream outputStream) throws IOException {
        Object[] objectArray = (Object[])aSNSequence.getValue();
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        outputStream.write(16);
        DER.encodeLength(byteArrayOutputStream.size(), outputStream);
        byteArrayOutputStream.writeTo(outputStream);
    }

    public void encode(ASNTaggedType aSNTaggedType, OutputStream outputStream) throws IOException {
    }

    public void encode(ASNTime aSNTime, OutputStream outputStream) throws IOException {
    }

    private static void encodeLength(int n, OutputStream outputStream) throws IOException {
        if (n < 128) {
            outputStream.write((byte)n);
            return;
        }
        if (n < 256) {
            outputStream.write(-127);
            outputStream.write((byte)n);
            return;
        }
        if (n < 65536) {
            outputStream.write(-126);
            outputStream.write((byte)(n >> 8));
            outputStream.write((byte)n);
            return;
        }
        if (n < 0x1000000) {
            outputStream.write(-125);
            outputStream.write((byte)(n >> 16));
            outputStream.write((byte)(n >> 8));
            outputStream.write((byte)n);
            return;
        }
        outputStream.write(-124);
        outputStream.write((byte)(n >> 24));
        outputStream.write((byte)(n >> 16));
        outputStream.write((byte)(n >> 8));
        outputStream.write((byte)n);
    }

    private byte[] getTLV(InputStream inputStream) throws IOException {
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        byte[] byArray = Tag.getTag(inputStream);
        if (byArray == null) {
            return null;
        }
        int n = DER.decodeLength(inputStream);
        byteArrayOutputStream.write(byArray);
        DER.encodeLength(n, byteArrayOutputStream);
        byte[] byArray2 = byteArrayOutputStream.toByteArray();
        byte[] byArray3 = new byte[byArray2.length + n];
        System.arraycopy(byArray2, 0, byArray3, 0, byArray2.length);
        if (n > 0) {
            int n2 = inputStream.read(byArray3, byArray2.length, n);
            if (n2 == -1) {
                throw new EOFException();
            }
            if (n2 != n) {
                throw new IOException("Length (" + n + ") mismatch: " + n2);
            }
        }
        return byArray3;
    }

    private boolean isExpectedTag(int n, InputStream inputStream) throws IOException {
        Tag tag = Tag.getExpectedTag(n, inputStream);
        return tag != null;
    }

    private boolean isExpectedTag(Tag tag, InputStream inputStream) throws IOException {
        Tag tag2 = Tag.getExpectedTag(tag, inputStream);
        return tag2 != null;
    }

    private static void trace(String string) {
        if (TRACE) {
            ((PrintWriter)null).println("<=> DER." + string);
        }
    }

    private static void trace(boolean bl, String string) {
        if (TRACE) {
            ((PrintWriter)null).println(String.valueOf(bl ? "==> " : "<== ") + NAME + "." + string);
        }
    }

    class Component {
        Tag tag;
        int length;
        byte[] data;

        Component(Tag tag, int n, byte[] byArray) {
            this.tag = tag;
            this.length = n;
            this.data = (byte[])byArray.clone();
        }

        byte[] getData() {
            return (byte[])this.data.clone();
        }

        int getLength() {
            return this.length;
        }

        Tag getTag() {
            return this.tag;
        }
    }
}

