/*
 * Decompiled with CFR 0.152.
 */
import edu.sdsc.grid.io.FileFactory;
import edu.sdsc.grid.io.GeneralAccount;
import edu.sdsc.grid.io.GeneralFile;
import edu.sdsc.grid.io.GeneralFileSystem;
import edu.sdsc.grid.io.MetaDataCondition;
import edu.sdsc.grid.io.MetaDataRecordList;
import edu.sdsc.grid.io.MetaDataSelect;
import edu.sdsc.grid.io.MetaDataSet;
import edu.sdsc.grid.io.MetaDataTable;
import edu.sdsc.grid.io.srb.SRBAccount;
import edu.sdsc.grid.io.srb.SRBMetaDataRecordList;
import edu.sdsc.grid.io.srb.SRBMetaDataSet;
import java.net.URI;

public class MetaDataTest {
    GeneralAccount account = null;
    GeneralFileSystem fileSystem = null;
    GeneralFile file = null;
    MetaDataRecordList[] rl = null;

    public MetaDataTest() throws Throwable {
        this(new String[0]);
    }

    public MetaDataTest(GeneralFile generalFile) throws Throwable {
        if (generalFile != null) {
            this.file = generalFile;
            this.fileSystem = generalFile.getFileSystem();
            this.run();
        } else {
            String[] stringArray = new String[]{generalFile.toString()};
            new MetaDataTest(stringArray);
        }
    }

    public MetaDataTest(String[] stringArray) throws Throwable {
        if (stringArray == null) {
            stringArray = new String[]{};
        }
        System.out.println("\n Connect to the fileSystem.");
        if (stringArray.length == 1) {
            this.file = FileFactory.newFile(new URI(stringArray[0]));
            this.fileSystem = this.file.getFileSystem();
        } else if (stringArray.length == 0) {
            this.fileSystem = FileFactory.newFileSystem(new SRBAccount());
            String string = "myJARGONMetaDataTestFile";
            this.file = FileFactory.newFile(this.fileSystem, string);
        } else {
            throw new IllegalArgumentException("Wrong number of arguments sent to Test.");
        }
        this.run();
    }

    private void run() throws Throwable {
        this.file.createNewFile();
        String[] stringArray = new String[]{"sysadmin", "staff"};
        System.out.println("\n Query the file system for all files matching certain query conditions");
        MetaDataCondition[] metaDataConditionArray = new MetaDataCondition[]{MetaDataSet.newCondition("offset", 2, 5000), MetaDataSet.newCondition("size", 8, 0, 10000), MetaDataSet.newCondition("user type name", 6, stringArray), MetaDataSet.newCondition("directory name", 0, this.file.getParent())};
        String[] stringArray2 = new String[]{"file name", "file comments", "size", "user domain", "owner domain", "user name", "user group name"};
        MetaDataSelect[] metaDataSelectArray = MetaDataSet.newSelection(stringArray2);
        int n = 2;
        this.rl = this.fileSystem.query(metaDataConditionArray, metaDataSelectArray, n);
        MetaDataTest.printQueryResults(this.rl);
        System.out.println("\n Get further results from the query.");
        if (this.rl != null) {
            this.rl = !this.rl[this.rl.length - 1].isQueryComplete() ? this.rl[this.rl.length - 1].getMoreResults() : null;
        }
        MetaDataTest.printQueryResults(this.rl);
        System.out.println("\n Change the metadata of a file.");
        this.rl = new MetaDataRecordList[1];
        this.rl[0] = new SRBMetaDataRecordList(SRBMetaDataSet.getField("size"), 123);
        this.rl[0].addRecord(SRBMetaDataSet.getField("file comments"), "new comments go here.");
        this.file.modifyMetaData(this.rl[0]);
        System.out.println("\n Query a single file/directory.");
        this.rl = this.file.getParentFile().query(stringArray2);
        MetaDataTest.printQueryResults(this.rl);
        System.out.println("\n Set the definable metadata.");
        String[][] stringArray3 = new String[3][2];
        stringArray3[0][0] = "zxcv";
        stringArray3[0][1] = "123";
        stringArray3[1][0] = "asdf";
        stringArray3[1][1] = "999";
        stringArray3[2][0] = "qwer";
        stringArray3[2][1] = "111";
        int[] nArray = new int[stringArray3.length];
        nArray[0] = 0;
        nArray[1] = 4;
        nArray[2] = 5;
        MetaDataTable metaDataTable = new MetaDataTable(nArray, stringArray3);
        this.rl = new MetaDataRecordList[1];
        this.rl[0] = new SRBMetaDataRecordList(SRBMetaDataSet.getField("definable metadata for files"), metaDataTable);
        this.rl[0].addRecord(SRBMetaDataSet.getField("file comments"), "Hi.");
        this.file.modifyMetaData(this.rl[0]);
        this.rl = this.file.getParentFile().query(metaDataSelectArray);
        MetaDataTest.printQueryResults(this.rl);
        System.out.println("\n Using the user definable metadata.");
        metaDataConditionArray = new MetaDataCondition[]{MetaDataSet.newCondition("definable metadata for files", metaDataTable)};
        metaDataSelectArray[3] = MetaDataSet.newSelection("definable metadata for files");
        metaDataSelectArray[4] = MetaDataSet.newSelection("definable metadata for directories");
        metaDataSelectArray[5] = MetaDataSet.newSelection("definable metadata for users");
        metaDataSelectArray[6] = MetaDataSet.newSelection("definable metadata for resources");
        this.rl = this.fileSystem.query(metaDataConditionArray, metaDataSelectArray);
        MetaDataTest.printQueryResults(this.rl);
    }

    public static void printQueryResults(MetaDataRecordList[] metaDataRecordListArray) {
        if (metaDataRecordListArray != null) {
            System.out.print("\n");
            int n = 0;
            while (n < metaDataRecordListArray.length) {
                System.out.print("\n" + metaDataRecordListArray[n]);
                ++n;
            }
        }
        System.out.println("\n");
    }

    public static void main(String[] stringArray) {
        try {
            MetaDataTest metaDataTest = new MetaDataTest(stringArray);
        }
        catch (Throwable throwable) {
            System.out.println("\nJava Error Message: " + throwable.toString());
            throwable.printStackTrace();
            System.exit(1);
        }
        System.exit(0);
    }
}

