/*
 * Decompiled with CFR 0.152.
 */
package org.exolab.castor.xml.schema.reader;

import java.io.IOException;
import java.io.Reader;
import org.exolab.castor.net.URIResolver;
import org.exolab.castor.util.Configuration;
import org.exolab.castor.util.LocalConfiguration;
import org.exolab.castor.util.NestedIOException;
import org.exolab.castor.xml.ValidationException;
import org.exolab.castor.xml.XMLException;
import org.exolab.castor.xml.schema.Schema;
import org.exolab.castor.xml.schema.reader.Sax2ComponentReader;
import org.exolab.castor.xml.schema.reader.SchemaUnmarshaller;
import org.exolab.castor.xml.schema.reader.SchemaUnmarshallerState;
import org.xml.sax.EntityResolver;
import org.xml.sax.InputSource;
import org.xml.sax.Parser;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;

public class SchemaReader {
    private Configuration _config = LocalConfiguration.getInstance();
    private Parser _parser = null;
    private InputSource _source = null;
    private EntityResolver _resolver = null;
    private URIResolver _uriResolver;
    private Schema _schema = null;
    private boolean _validate = true;

    private SchemaReader() throws IOException {
        Parser parser = null;
        parser = this._config.getParser();
        if (parser == null) {
            throw new IOException("fatal error: unable to create SAX parser.");
        }
        this._parser = parser;
    }

    public SchemaReader(InputSource source) throws IOException {
        this();
        if (source == null) {
            throw new IllegalArgumentException("InputSource cannot be null");
        }
        this._source = source;
    }

    public SchemaReader(Reader reader, String filename) throws IOException {
        this();
        if (reader == null) {
            String err = "The argument 'reader' must not be null.";
            throw new IllegalArgumentException(err);
        }
        this._source = new InputSource(reader);
        if (filename == null) {
            filename = reader.toString();
        }
        this._source.setPublicId(filename);
    }

    public SchemaReader(String url) throws IOException {
        this();
        if (url == null) {
            String err = "The argument 'url' must not be null.";
            throw new IllegalArgumentException(err);
        }
        this._source = new InputSource(url);
    }

    public Schema read() throws IOException {
        if (this._schema != null) {
            return this._schema;
        }
        SchemaUnmarshaller schemaUnmarshaller = null;
        try {
            SchemaUnmarshallerState state = new SchemaUnmarshallerState();
            state.setConfiguration(this._config);
            schemaUnmarshaller = new SchemaUnmarshaller(state);
            if (this._uriResolver != null) {
                schemaUnmarshaller.setURIResolver(this._uriResolver);
            }
            Sax2ComponentReader handler = new Sax2ComponentReader(schemaUnmarshaller);
            this._parser.setDocumentHandler(handler);
            this._parser.setErrorHandler(handler);
            if (this._resolver != null) {
                this._parser.setEntityResolver(this._resolver);
            }
            this._parser.parse(this._source);
        }
        catch (XMLException ex) {
            this.handleException(ex);
        }
        catch (SAXException sx) {
            this.handleException(sx);
        }
        this._schema = schemaUnmarshaller.getSchema();
        if (this._validate) {
            try {
                this._schema.validate();
            }
            catch (ValidationException vx) {
                throw new NestedIOException(vx);
            }
        }
        return this._schema;
    }

    public void setValidation(boolean validate) {
        this._validate = validate;
    }

    public void setEntityResolver(EntityResolver resolver) {
        this._resolver = resolver;
    }

    public void setURIResolver(URIResolver uriresolver) {
        this._uriResolver = uriresolver;
    }

    private void handleException(XMLException xx) throws IOException {
        Exception except = xx.getException();
        if (except == null) {
            except = xx;
        } else if (except instanceof SAXException) {
            this.handleException((SAXException)except);
        } else if (except instanceof XMLException) {
            this.handleException((XMLException)except);
        }
        throw new NestedIOException(except);
    }

    private void handleException(SAXException sx) throws IOException {
        Exception except = sx.getException();
        if (except == null) {
            except = sx;
        } else {
            if (except instanceof SAXParseException) {
                SAXParseException spe = (SAXParseException)except;
                String filename = spe.getSystemId();
                if (filename == null) {
                    filename = spe.getPublicId();
                }
                if (filename == null) {
                    filename = "<filename unavailable>";
                }
                String err = spe.getMessage();
                err = err + "; " + filename + " [ line: " + spe.getLineNumber();
                err = err + ", column: " + spe.getColumnNumber() + ']';
                throw new NestedIOException(err, except);
            }
            if (except instanceof XMLException) {
                this.handleException((XMLException)except);
            }
        }
        throw new NestedIOException(except);
    }
}

