package org.ecoinformatics.ecogrid.lsid;

import java.io.InputStream;

import com.ibm.lsid.server.LSIDDataService;
import com.ibm.lsid.server.LSIDServerException;
import com.ibm.lsid.server.LSIDServiceConfig;
import com.ibm.lsid.server.LSIDRequestContext;

public class LSIDAuthorityData implements LSIDDataService {

	private LSIDDataLookup lookup = null;

	public InputStream getData(LSIDRequestContext lsid) throws LSIDServerException {
        System.out.println("Getting data (Metacat): " + lsid.getLsid().toString());
		if (lookup == null)
			throw new LSIDServerException(500, "Cannot query database");
		return lookup.lsidData(lsid.getLsid());
	}

	public InputStream getDataByRange(LSIDRequestContext lsid, int start, int end) throws LSIDServerException {
		if (lookup == null)
			throw new LSIDServerException(500, "Cannot query database");
		return lookup.lsidData(lsid.getLsid());
	}

	public void initService(LSIDServiceConfig cf) throws LSIDServerException {
        System.out.println("Starting LSIDAuthorityData (Metacat).");
		lookup = new LSIDDataLookup();
	}
}
