/**
 *    '$RCSfile: EcogridFactoryRegistryClient.java,v $'
 *
 *     '$Author: berkley $'
 *       '$Date: 2007-09-07 18:02:37 $'
 *   '$Revision: 1.5 $'
 *
 *  For Details: http://kepler.ecoinformatics.org
 *
 * Copyright (c) 2003 The Regents of the University of California.
 * All rights reserved.
 *
 * Permission is hereby granted, without written agreement and without
 * license or royalty fees, to use, copy, modify, and distribute this
 * software and its documentation for any purpose, provided that the
 * above copyright notice and the following two paragraphs appear in
 * all copies of this software.
 *
 * IN NO EVENT SHALL THE UNIVERSITY OF CALIFORNIA BE LIABLE TO ANY PARTY
 * FOR DIRECT, INDIRECT, SPECIAL, INCIDENTAL, OR CONSEQUENTIAL DAMAGES
 * ARISING OUT OF THE USE OF THIS SOFTWARE AND ITS DOCUMENTATION, EVEN
 * IF THE UNIVERSITY OF CALIFORNIA HAS BEEN ADVISED OF THE POSSIBILITY
 * OF SUCH DAMAGE.
 *
 * THE UNIVERSITY OF CALIFORNIA SPECIFICALLY DISCLAIMS ANY WARRANTIES,
 * INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES OF
 * MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE. THE SOFTWARE
 * PROVIDED HEREUNDER IS ON AN "AS IS" BASIS, AND THE UNIVERSITY
 * OF CALIFORNIA HAS NO OBLIGATION TO PROVIDE MAINTENANCE, SUPPORT,
 * UPDATES, ENHANCEMENTS, OR MODIFICATIONS.
 */

package org.ecoinformatics.ecogrid.client;

import org.ecoinformatics.ecogrid.*;
import org.apache.axis.message.MessageElement;
import org.apache.axis.types.URI;

import org.ecoinformatics.ecogrid.registry.stub.service.EcoRegInterfaceLevelOneServiceGridLocator;
import org.ecoinformatics.ecogrid.registry.stub.service.EcoRegInterfaceLevelOneServiceLocator;
import org.ecoinformatics.ecogrid.registry.stub.*;
import org.ecoinformatics.ecogrid.stub.service.EcoGridQueryLevelOneServiceGridLocator;

import org.ecoinformatics.ecogrid.EcogridUtils;


import org.globus.axis.gsi.GSIConstants;
import org.globus.gsi.proxy.IgnoreProxyPolicyHandler;
import org.globus.ogsa.impl.security.authentication.Constants;
import org.globus.ogsa.impl.security.authorization.NoAuthorization;
import org.globus.ogsa.utils.GridServiceFactory;
import org.globus.ogsa.ServiceProperties;
import org.gridforum.ogsi.ExtensibilityType;
import org.gridforum.ogsi.Factory;
import org.gridforum.ogsi.GridService;
import org.gridforum.ogsi.LocatorType;
import org.gridforum.ogsi.OGSIServiceGridLocator;
import org.gridforum.ogsi.WSDLReferenceType;

import java.io.*;
import java.net.URL;
import java.util.Iterator;

import javax.xml.rpc.Stub;

import org.apache.xerces.parsers.DOMParser;
import org.xml.sax.InputSource;
import org.w3c.dom.*;

import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMResult;
import javax.xml.transform.dom.DOMSource;

import org.w3c.dom.Document;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.InputSource;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Element;

/**
 * This class is a client class which can talk with registry factory web service
 * The client class includes add new entry to service, update enty and query service
 * 
 * @author tao
 *
 */
public class EcogridFactoryRegistryClient
{
  private URL serviceURL = null;;
  private EcoRegInterfaceLevelOnePortType ecogrid = null;

  final static int ADD_REG = 1;
  final static int UPDATE_REG = 2;
  final static int REMOVE_REG = 3;
  final static int GET_ALL = 4;
  final static int QUERY_REG = 5;

  public static void main(String[] args) throws Exception
  {
     String opMode  = "";
     int    intOpCode = 0;
     String sessionId = "";
     String localFilename = "";
     String gsh_str = "";
     String regName = "";
     String retStr;
     String queryField = "";
     String queryString = "";

     if(args.length < 2)
     {
        PrintRegistryClientUsage();
        System.exit(0);
     }

     
     opMode = args[0];

     if(opMode.compareToIgnoreCase("add") == 0 )
     {
           intOpCode = ADD_REG;
           if(args.length != 4)
           {
               PrintRegistryClientUsage();
               System.exit(0);
           }
           sessionId = args[1];
           localFilename = args[2];
           gsh_str = args[3];
     }
     else if(opMode.compareToIgnoreCase("update") == 0)
     {
           intOpCode = UPDATE_REG;
           if(args.length != 4)
           {
               PrintRegistryClientUsage();
               System.exit(0);
           }
           sessionId = args[1];
           localFilename = args[2];
           gsh_str = args[3];
     }
     else if(opMode.compareToIgnoreCase("remove") == 0)
     {
           intOpCode = REMOVE_REG;
           if(args.length != 3)
           {
               PrintRegistryClientUsage();
               System.exit(0);
           }
           sessionId = args[1];
           regName = args[2];
           gsh_str = args[3];
     }
     else if(opMode.compareToIgnoreCase("getAll") == 0)
     {
           intOpCode = GET_ALL;
           if(args.length != 2)
           {
               PrintRegistryClientUsage();
               System.exit(0);
           }
           gsh_str = args[1];
     }
     else if(opMode.compareToIgnoreCase("query") == 0)
     {
           intOpCode = QUERY_REG;
           if(args.length != 4)
           {
               PrintRegistryClientUsage();
               System.exit(0);
           }
           queryField = args[1];
           queryString = args[2];
           gsh_str = args[3];
     }
     else
     {
            PrintRegistryClientUsage();
            System.exit(0);
     }

     try
     {
          URL GSH = new URL(gsh_str);

          // create a client object
          EcogridFactoryRegistryClient client = new EcogridFactoryRegistryClient(GSH);

        
          switch(intOpCode)
          {
             case ADD_REG:

               client.AddRegEntry(sessionId, localFilename);
               break;

             case UPDATE_REG:

               client.UpdateRegistry(sessionId, localFilename);
               break;

             case REMOVE_REG:

               client.RemoveRegistry(sessionId, regName);
               break;

             case GET_ALL:

               client.GetAllRegistries();          
               break;

             case QUERY_REG:

               client.QueryRegistryServices(queryField, queryString);
               break;
          }

     }
     catch (Exception e)
     {
          System.out.println("Exception in main : "+ e.getMessage());

          if(EcogridUtils.printStackTraceByEnv())
            e.printStackTrace();
     }
            
  }//main

  /**
   * add a registry entry
   */
  public void AddRegEntry(String SessionId, String LocalFileName) throws Exception
  {
    
     EcogridRegEntryType myRegEntry = new EcogridRegEntryType();

     int i;

     String ServiceName, WsdlURL, ServiceType, EndPoint, ServiceClassification;

     Document doc = EcogridUtils.readXMLFile2DOM(LocalFileName);

     ServiceName = EcogridUtils.getEcogridConfigValue(doc,"serviceName");
     WsdlURL = EcogridUtils.getEcogridConfigValue(doc,"wsdlURL");
     ServiceType = EcogridUtils.getEcogridConfigValue(doc,"serviceType");
     EndPoint = EcogridUtils.getEcogridConfigValue(doc,"endPoint");
     ServiceClassification = EcogridUtils.getEcogridConfigValue(doc,"serviceClassification");
     
     if((ServiceName==null)||(ServiceName.length() == 0))
     {
        throw new Exception("<serviceName> is a required field.");
     }

     if((WsdlURL==null)||(WsdlURL.length() == 0))
     {
        throw new Exception("<wsdlURL> is a required field.");
     }

     if((ServiceType==null)||(ServiceType.length() == 0))
     {
        throw new Exception("<serviceType> is a required field.");
     }

     if((EndPoint==null)||(EndPoint.length() == 0))
     {
        throw new Exception("<endPoint> is a required field.");
     }

     myRegEntry.setServiceName(ServiceName);
     myRegEntry.setWsdlURL(WsdlURL);
     myRegEntry.setServiceType(ServiceType);
     myRegEntry.setEndPoint(EndPoint);
     myRegEntry.setServiceClassification(ServiceClassification);
    
     Element rootElement = doc.getDocumentElement();
     
     NodeList recordList = rootElement.getElementsByTagName("documentType");
     if((recordList != null) || (recordList.getLength() > 0))
     {
        EcogridRegEntryType_documentType[] aDocType = new EcogridRegEntryType_documentType[recordList.getLength()];
        for(i=0;i<recordList.getLength();i++)
        {
           Node recordNode = recordList.item(i);

           Node nameSpaceNode = EcogridUtils.findNode(recordNode, "namespace");
           Node labelNode = EcogridUtils.findNode(recordNode, "label");

           if(nameSpaceNode == null)
           {
              throw new Exception("<namespace> is required inside <documentType>.");
           }

           EcogridRegEntryType_documentType docType = new EcogridRegEntryType_documentType();

           docType.setNamespace(EcogridUtils.getNodeValue(nameSpaceNode));
           docType.setLabel(EcogridUtils.getNodeValue(labelNode));

           aDocType[i] = docType;
        }

        myRegEntry.setDocumentType(aDocType);
     }
     
     recordList = rootElement.getElementsByTagName("provider");
     if((recordList != null) || (recordList.getLength() > 0))
     {
        String[] sProviders = new String[recordList.getLength()];
        for(i=0;i<recordList.getLength();i++)
        {
           Node recordNode = recordList.item(i);
           sProviders[i] = EcogridUtils.getNodeValue(recordNode);
        }  

        myRegEntry.setProvider(sProviders);
     }
     if ( ecogrid != null)
     {
       ecogrid.addRegEntry(SessionId, myRegEntry);
     }
     
  }

  /**
   * update a registry entry
   */
  public void UpdateRegistry(String SessionId, String LocalFileName) throws Exception
  {
     // The implementation is pasued because the revision issue inside Metacat.
     EcogridRegEntryType myRegEntry = new EcogridRegEntryType();
     if (ecogrid != null)
     {
        ecogrid.updateRegEntry(SessionId, myRegEntry);
     }
  }
  
  /**
   * remove a registry entry
   */
  public void RemoveRegistry(String SessionId, String RegName) throws Exception
  {
      if (ecogrid != null)
      {
        ecogrid.removeRegEntry(SessionId, RegName);
      }
  }

  /**
   * get all of the registry entries
   */
  public EcogridRegEntryType[] GetAllRegistries() throws Exception
  {
     _EcogridGetAllRegServicesRequestElement allSviceRsqtElement = new _EcogridGetAllRegServicesRequestElement();
     // currently the sessionId is ignored.
     allSviceRsqtElement.setSessionId("ignored");
     if (ecogrid == null)
     {
         return null;
     }
     _EcogridGetAllRegServicesResponseElement getAllRspnsElement = ecogrid.getAllRegServices(allSviceRsqtElement);

     if(getAllRspnsElement == null)
     {
        System.out.println("No registry entry is found in database.");
        return null;
     }
  
     if(getAllRspnsElement.getGetAllServicesReturn() == null)
     {
        System.out.println("No registry entry is found in database.");
        return null;
     }

     EcogridRegEntryType[] regEntries = getAllRspnsElement.getGetAllServicesReturn().getRegEntry();

     if(regEntries == null)
     {
        System.out.println("No registry entry is found in database.");
        return null;
     }

     int i;
     for(i=0;i<regEntries.length;i++)
     {
        System.out.println(regEntries[i].getServiceName());
     }
     return regEntries;
  }

  /**
   * query for a registry service
   */
  public EcogridRegEntryType[] QueryRegistryServices(String QueryField, String QueryString) throws Exception
  {
     String sessionId = "ignored";
     if (ecogrid == null)
     {
         return null;
     }
     EcogridRegEntryArrayType regArray = ecogrid.queryRegServices(sessionId, QueryField, QueryString);

     if(regArray == null)
     {
         
         return null; 
     }
      
    
     EcogridRegEntryType[] regEntries = regArray.getRegEntry();

     if(regEntries == null)
     {
        
        return null;
     }
     
  
     int i;
     for(i=0;i<regEntries.length;i++)
     {
        System.out.println(regEntries[i].getServiceName());
     }
     return regEntries;
  }

  /**
   * constructor
   */
  public EcogridFactoryRegistryClient(URL serviceGSH) throws Exception
  {
     this.serviceURL = serviceGSH;
     EcogridUtils.setDebug(true);
     // Get a reference to the EcoGridQueryLevelOneService Factory
     long startFactory = System.currentTimeMillis();
     OGSIServiceGridLocator gridLocator = new
             OGSIServiceGridLocator();
     Factory factory = gridLocator.getFactoryPort(serviceURL);
     GridServiceFactory ecogridQueryFactory = new
             GridServiceFactory(factory);
     long endFacotry = System.currentTimeMillis();
     EcogridUtils.debugMessage("The time to create factory is ============= "+
                       (endFacotry-startFactory)/1000, 30);
     // Create a new EcoGridQueryLevelOneService instance and get a reference
     // to its getEcoGridQueryLevelOneServicePort
     LocatorType locator = ecogridQueryFactory.createService();
     EcoRegInterfaceLevelOneServiceGridLocator loc = new
                             EcoRegInterfaceLevelOneServiceGridLocator();
     ecogrid = loc.getEcoRegInterfaceLevelOnePort(locator);
     org.apache.axis.client.Stub stub = (org.apache.axis.client.Stub) ecogrid;
     stub.setTimeout(10000000);
     long endInstance = System.currentTimeMillis();
     EcogridUtils.debugMessage("The time to create instance is =========== "+
                        (endInstance - endFacotry)/1000, 30);
  }
  
  /**
   * Method to doestory the grid service instance which generate by factory.
   * this can remove the null instance in web service display.
   * @throws Exception
   */
  public void destroy() throws Exception
  {
      if (ecogrid != null)
      {
          ecogrid.destroy();
      }
  }
  
  /**
   * print a usage statement
   */
  static void PrintRegistryClientUsage()
  {
     System.out.println("Usage: java EcogridRegistryClient add session_id local_file GSH");
     System.out.println("Usage: java EcogridRegistryClient update session_id local_file GSH");
     System.out.println("Usage: java EcogridRegistryClient remove session_id reg_name GSH");
     System.out.println("Usage: java EcogridRegistryClient getAll GSH");
     System.out.println("Usage: java EcogridRegistryClient query query_field query_string GSH");
  }
  
}

