/**
 *  '$RCSfile: DigirImpl.java,v $'
 *    Purpose: A Class that implements replication for digir
 *  Copyright: 2004 Regents of the University of California and the
 *             National Center for Ecological Analysis and Synthesis
 *    Authors: Rod Spears
 *    Release: @release@
 *
 *   '$Author: leinfelder $'
 *     '$Date: 2008-01-22 16:46:33 $'
 * '$Revision: 1.17 $'
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 31, Boston, MA  02111-117  USA
 */
package org.ecoinformatics.ecogrid.digir.impl;

import java.io.IOException;
import java.rmi.RemoteException;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

import org.ecoinformatics.ecogrid.queryservice.stub.QueryServicePortType;
import org.ecoinformatics.ecogrid.queryservice.resultset.ResultsetType;
import org.ecoinformatics.ecogrid.queryservice.query.QueryType;

 /**
  * The class implements ecogrid query and get method for digir
  */
public class DigirImpl implements QueryServicePortType
{
   static Log logger = LogFactory.getLog(DigirImpl.class.getName());

   public DigirImpl(){
      
      if (logger.isDebugEnabled()) {
         logger.debug( "*******************************************" );
         logger.debug("DigirImpl has been created");
      }
      
   }
   
   /**
    * Performs a query to the Digir
    * @param query The Ecogrid query to be executed
    * @return returns an ecogrid resultset
    * @exception RemoteException
    */
   public ResultsetType query(QueryType query) 
      throws RemoteException
   {
      try {
         org.ecoinformatics.ecogrid.digir.impl.digirquery.DigirQuery _proxyImpl = new org.ecoinformatics.ecogrid.digir.impl.digirquery.DigirQuery();
         return _proxyImpl.query(query);
      }
      catch (Exception e ) {
         logger.fatal("Cannot create DigirProxyImpl",e);
         throw new RemoteException("Unable to create DigirProxyImpl",e);
      }
   } //query
   
   /**
    * Performs a get
    * @param identifier identifies the object to be "gotten"
    * @return returns bytes of identifier
    * @exception RemoteException
    */
   public byte[] get(String identifier) throws RemoteException
   {
      byte[] output = null;
      try {
         DigirGetImpl _proxyImpl = new DigirGetImpl();
         output = _proxyImpl.get(identifier);
         return output;
      } catch (IOException e ) {
         logger.fatal("Cannot create DigirProxyImpl",e);
         throw new RemoteException("Unable to create DigirProxyImpl",e);
      }
      
   } //get
   
}

