package org.ecoinformatics.ecogrid.digir.impl.digirquery;

import java.util.Iterator;
import java.util.Vector;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

import org.apache.commons.httpclient.HttpClient;
import org.apache.commons.httpclient.MultiThreadedHttpConnectionManager;

import org.ecoinformatics.ecogrid.digir.impl.EcogridJavaToDigirJavaQueryTransformer;
import org.ecoinformatics.ecogrid.digir.impl.providerinfo.ProviderInfo;
import org.ecoinformatics.ecogrid.digir.impl.servlet.DigirProviderServlet;
import org.ecoinformatics.ecogrid.digir.impl.threadpool.DaemonThreadFactory;
import org.ecoinformatics.ecogrid.queryservice.util.EcogridQueryTransformer;
import org.ecoinformatics.ecogrid.queryservice.query.QueryType;
import org.ecoinformatics.ecogrid.queryservice.resultset.ResultsetType;
import org.ecoinformatics.ecogrid.queryservice.util.EcogridQueryTransformer;

import edu.emory.mathcs.backport.java.util.concurrent.CountDownLatch;
import edu.emory.mathcs.backport.java.util.concurrent.ExecutorService;
import edu.emory.mathcs.backport.java.util.concurrent.Executors;


 /**
  * The class implements ecogrid query and get method for digir
  */
public class DigirQuery
{
   static Log logger = LogFactory.getLog(DigirQuery.class.getName());
   
   
   private static HttpClient client;
   private static ExecutorService pool;
   
   static {
	   logger.debug("begin DigirQuery static init");
      MultiThreadedHttpConnectionManager connMan = new MultiThreadedHttpConnectionManager();
      connMan.setMaxTotalConnections( 400 );
      connMan.setMaxConnectionsPerHost( 10 );
      client = new HttpClient( connMan );
      client.setConnectionTimeout(10000);
      client.setTimeout(30000);
      
      pool = Executors.newFixedThreadPool(400, new DaemonThreadFactory() );
	   logger.debug("end DigirQuery static init");
   }
   
  public DigirQuery()
  {
  }
  
  /**
   * Performs a query to the Digir
   * @param query The Ecogrid qury to be executed
   * @return returns an ecogrid resultset
   * @exception RemoteException
   */
   public ResultsetType query(QueryType query) throws Exception
   {
      if (logger.isDebugEnabled()) {
         logger.debug( "start query method in grid service" + this );
      }
    
      ResultsetType resultset = new ResultsetType();

      CountDownLatch latch = null;

      DigirResultsetTransformer resultsetTransformer = new DigirResultsetTransformer();

      resultsetTransformer.initializeFieldnames( query );

      if (logger.isDebugEnabled()) {
         String querystr = EcogridQueryTransformer.toXMLString( query );
         logger.debug( "QueryType is: " + querystr );
      }

      Vector providerList = DigirProviderServlet.getProviderList();

      // create a query transfer

      Iterator providerIt = providerList.iterator();
      
      latch = new CountDownLatch( providerList.size() );
      
      EcogridJavaToDigirJavaQueryTransformer ecogrid2DigirTransformer = new EcogridJavaToDigirJavaQueryTransformer();
      while ( providerIt.hasNext() ) {
         ProviderInfo pi = (ProviderInfo) providerIt.next();
         
         String digirQueryStr = ecogrid2DigirTransformer.transform(query, pi);
         
         if (digirQueryStr == null || digirQueryStr.length() == 0 ) {
            logger.info("digirQueryStr is null or empty");
            continue;
         } 
         
         pool.execute( new QueryFromDigirProvider( client, pi, digirQueryStr, resultsetTransformer, latch ) );
         
      }
      
      latch.await();

      logger.debug("Calling Transformer");
      resultset = resultsetTransformer.extractResultset();
      logger.debug("Transformer Done");

      return resultset;

   } //query
  
   
}

