package org.ecoinformatics.ecogrid.digir.impl.digiruddi;

import java.util.Iterator;
import java.util.Vector;

import org.apache.axis.client.Service;
import org.apache.commons.httpclient.HttpClient;
import org.apache.commons.httpclient.MultiThreadedHttpConnectionManager;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.ecoinformatics.ecogrid.digir.impl.providerinfo.DigirSchemaInfo;
import org.ecoinformatics.ecogrid.digir.impl.providerinfo.DigirSchemaMapping;
import org.ecoinformatics.ecogrid.digir.impl.providerinfo.ProviderInfo;
import org.ecoinformatics.ecogrid.digir.impl.threadpool.DaemonThreadFactory;

import uddi.api_v2.BindingDetail;
import uddi.api_v2.BindingTemplate;
import uddi.api_v2.Find_binding;
import uddi.api_v2.Find_service;
import uddi.api_v2.ServiceInfo;
import uddi.api_v2.ServiceList;
import uddi.api_v2.TModelBag;
import uddi.inquiry_v2.InquireSoapStub;
import edu.emory.mathcs.backport.java.util.concurrent.ExecutorService;
import edu.emory.mathcs.backport.java.util.concurrent.Executors;
import edu.emory.mathcs.backport.java.util.concurrent.TimeUnit;

public class DigirGetProviders {
    
   private static String gbifInquiryURL = "http://registry.gbif.net/uddi/inquiry";
   
   private static java.net.URL endpoint;
   private static HttpClient client;
     
   static Log logger = LogFactory.getLog(DigirGetProviders.class.getName());

   static {

      MultiThreadedHttpConnectionManager connMan = new MultiThreadedHttpConnectionManager();
      connMan.setMaxTotalConnections( 200 );
      connMan.setMaxConnectionsPerHost( 10 );
      client = new HttpClient( connMan );
      client.setConnectionTimeout(2000);
      client.setTimeout(30000);
      
      // Note:
      // mappingType: 0 = DecimalLongitude
      // mappingType: 1 = Longitude
      DigirSchemaMapping.add( new DigirSchemaInfo( "http://digir.net/schema/conceptual/darwin/manis/1.21/darwin2.xsd",
                                                   "http://digir.net/schema/conceptual/darwin/2003/1.0", 0 ) );
      DigirSchemaMapping.add( new DigirSchemaInfo( "http://http://digir.net/schema/conceptual/darwin/manis/1.21/darwin2.xsd",
                                                   "http://digir.net/schema/conceptual/darwin/2003/1.0", 0 ) );
      DigirSchemaMapping.add( new DigirSchemaInfo( "http://digir.net/schema/conceptual/darwin/2003/1.0/darwin2.xsd",
                                                   "http://digir.net/schema/conceptual/darwin/2003/1.0", 1 ) );
      DigirSchemaMapping.add( new DigirSchemaInfo( "http://digir.net/schema/conceptual/darwin/core/2.0/darwincore.xsd",
                                                   "http://digir.net/schema/conceptual/darwin/core/2.0", 1 ) );
      DigirSchemaMapping.add( new DigirSchemaInfo( "http://digir.sourceforge.net/schema/conceptual/darwin/2003/1.0/darwin2.xsd",
                                                   "http://digir.net/schema/conceptual/darwin/2003/1.0", 1 ) );
      DigirSchemaMapping.add( new DigirSchemaInfo( "http://bnhm.berkeley.museum/manis/DwC/darwin2jrw030315.xsd",
                                                   "http://digir.net/schema/conceptual/darwin/2003/1.0", 0 ) );
      DigirSchemaMapping.add( new DigirSchemaInfo( "http://bnhm.berkeley.edu/manis/DwC/darwin2jrw030315.xsd",
                                                   "http://digir.net/schema/conceptual/darwin/2003/1.0", 0 ) );
      DigirSchemaMapping.add( new DigirSchemaInfo( "http://digir.sourceforge.net/fed/beta3/darwin2.xsd",
                                                   "http://www.namespaceTBD.org/darwin2", 1 ) );
      DigirSchemaMapping.add( new DigirSchemaInfo( "http://www.iobis.org/obis/obis.xsd",
                                                   "http://digir.net/schema/conceptual/darwin/2003/1.0", 1 ) );
      DigirSchemaMapping.add( new DigirSchemaInfo( "http://www.iobis.org/obis.xsd",
                                                   "http://digir.net/schema/conceptual/darwin/2003/1.0", 1 ) );
      DigirSchemaMapping.add( new DigirSchemaInfo( "http://bnhm.berkeley.museum/DwC/bnhm_dc2_schema.xsd",
                                                   "http://digir.net/schema/conceptual/darwin/2003/1.0", 0 ) );
      DigirSchemaMapping.add( new DigirSchemaInfo( "http://bnhm.berkeley.edu/DwC/bnhm_dc2_schema.xsd",
                                                   "http://digir.net/schema/conceptual/darwin/2003/1.0", 0 ) );
      DigirSchemaMapping.add( new DigirSchemaInfo( "http://data.paleoportal.org/schema/conceptual/1.0/paleoportal.xsd",
                                                   "http://data.paleoportal.org/schema/conceptual/1.0", 1 ) );
      
   }
    
   public static Vector getProviderList() throws Exception {
        
      Vector providers = new Vector();

      ExecutorService pool = Executors.newFixedThreadPool(20, new DaemonThreadFactory() );
      
      endpoint = new java.net.URL( gbifInquiryURL );
      InquireSoapStub stub = new InquireSoapStub( endpoint, new Service() );

      String[] tModel = new String[1];
      tModel[0] = new String("uuid:a8012280-b3b8-11d7-b4bf-b8a03c50a862");
      TModelBag tModelBag = new TModelBag();
      tModelBag.setTModelKey( tModel );
      
      Find_service body = new Find_service();
      body.setTModelBag( tModelBag );
      body.setGeneric("2.0");
      body.setMaxRows(new Integer(200));
      
      ServiceList list = stub.find_service( body );
      
      ServiceInfo[] sInfo = list.getServiceInfos().getServiceInfo();
      
      for( int i=0; i< sInfo.length; i++ ){
         
         String name = "unknown";
         
         if ( sInfo[i].getName().length > 0 ) {
            name = sInfo[i].getName(0).get_value();
         }
         
         String [] urls = queryServiceForUrl( sInfo[i], tModelBag );
         
         if (urls != null ) {
            for ( int j=0; j<urls.length; j++ ) {
               pool.execute( new GetPropertiesFromDigirProvider(client,name,urls[j],providers));
            }
         }
      }
      
      pool.shutdown();

      pool.awaitTermination( Long.MAX_VALUE, TimeUnit.NANOSECONDS );

      return providers;
   }
   
   private static String[] queryServiceForUrl( ServiceInfo serviceKey, TModelBag tModelBag ) {
      
      String [] retval = null;
      
      try {
         InquireSoapStub stub = new InquireSoapStub( endpoint, new Service() );
         
         Find_binding body = new Find_binding();
         
         body.setGeneric("2.0");
         body.setMaxRows(new Integer(100));
         body.setTModelBag( tModelBag );
         body.setServiceKey(serviceKey.getServiceKey());
         
         BindingDetail detail = stub.find_binding( body );
         
         BindingTemplate[] templates = detail.getBindingTemplate();
         
         retval = new String[templates.length];
         
         for (int i = 0; i < templates.length; i++ ) {
            retval[i] = new String( templates[i].getAccessPoint().get_value());
         }
      }
      catch ( Exception e ) {
         logger.fatal("Error while quering for binding");
         logger.fatal(e);
         return null;
      }
      
      return retval;
   }
   
   public static void main(String[] args) throws Exception {
      
      Vector v = DigirGetProviders.getProviderList();
      
      Iterator i = v.iterator();
      System.out.println("Valid Providers:");
      
      while( i.hasNext() ) {
         ProviderInfo pi = (ProviderInfo) i.next();
         System.out.println( pi.getResourceCode() + "@" + pi.getUrl() );
      }
   }
}
