package org.ecoinformatics.ecogrid.digir.impl.digiruddi;
import java.io.InputStream;
import java.util.Vector;

import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;

import org.apache.commons.httpclient.DefaultMethodRetryHandler;
import org.apache.commons.httpclient.HttpClient;
import org.apache.commons.httpclient.methods.GetMethod;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.xpath.XPathAPI;
import org.w3c.dom.DOMImplementation;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.traversal.NodeIterator;

import org.ecoinformatics.ecogrid.digir.impl.providerinfo.DigirSchemaMapping;
import org.ecoinformatics.ecogrid.digir.impl.providerinfo.ProviderInfo;

public class GetPropertiesFromDigirProvider implements Runnable {

    HttpClient client;
    String name;
    String url;
    Vector resources;
   Vector providers;
    
   static Log logger = LogFactory.getLog(GetPropertiesFromDigirProvider.class.getName());

    public GetPropertiesFromDigirProvider( HttpClient client, String name, String url, Vector providers ) {
        resources = new Vector();
        this.client = client;
        this.name = name;
        this.url = url;        
        this.providers = providers;
    }

    public Vector getResources() {
        return resources;
    }
    
    /* (non-Javadoc)
     * @see java.lang.Runnable#run()
     */
    public void run() {

        GetMethod method = new GetMethod( url );
        DefaultMethodRetryHandler retries = new DefaultMethodRetryHandler();
        retries.setRetryCount(2);
        method.setMethodRetryHandler( retries );

        
        try {
            client.executeMethod( method );
            
            InputStream is = method.getResponseBodyAsStream();
            
            DocumentBuilder parser = DocumentBuilderFactory.newInstance().newDocumentBuilder();

            Document d;
            d = parser.parse( is );
         
            d.normalize();
            
            DOMImplementation namespaceMap = parser.getDOMImplementation();
            Document namespaceHolder = namespaceMap.createDocument( null, "namespaceMap", null );
            Element namespaceRoot = namespaceHolder.getDocumentElement();
            namespaceRoot.setAttributeNS("http://www.w3.org/2000/xmlns/","xmlns","http://digir.net/schema/protocol/2003/1.0");
            
            NodeIterator ni = XPathAPI.selectNodeIterator(d, "/response/content/metadata/provider/resource",
                    namespaceRoot );
            
            Node node;
            while ( ( node = ni.nextNode()) != null ) {
                Node codeNode = XPathAPI.selectSingleNode(node, "./code/text()",namespaceRoot);
                String code = codeNode.getNodeValue();
                Node schemaLocation = XPathAPI.selectSingleNode(node,"./conceptualSchema/@schemaLocation",namespaceRoot);
                String schema = schemaLocation.getNodeValue();
                if ( DigirSchemaMapping.get(schema) != null ) {
                    resources.add( new ProviderInfo( name, url, code, schema) );
                }
                else {
                    System.out.println(name + " " + url+ " Schema unknown " + schema );
                }
            }
        }
        catch ( Exception e) {
            logger.fatal( "Exception occurred contacting url " + url );
            logger.fatal( e );
        }
        finally {
           providers.addAll( resources );
           method.releaseConnection();
        }
        
    }
}
