package org.ecoinformatics.ecogrid.digir.impl.servlet;

import java.io.IOException;
import java.util.Vector;

import javax.naming.Context;
import javax.naming.InitialContext;
import javax.naming.NamingException;
import javax.servlet.RequestDispatcher;
import javax.servlet.ServletConfig;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

import org.ecoinformatics.ecogrid.digir.impl.digiruddi.DigirGetProviders;

public class DigirProviderServlet extends HttpServlet {
    
    private final static String PROVIDER_JNDI = "DigirProvider";
    private final static String VIEW_JSP_URL = "/Providers.jsp";
    
   static Log logger = LogFactory.getLog(DigirProviderServlet.class.getName());

    /* (non-Javadoc)
     * @see javax.servlet.GenericServlet#init(javax.servlet.ServletConfig)
     */
    public void init(ServletConfig arg0) throws ServletException {
        super.init(arg0);
        doReload();
    }
    
    /* (non-Javadoc)
     * @see javax.servlet.http.HttpServlet#doGet(javax.servlet.http.HttpServletRequest, javax.servlet.http.HttpServletResponse)
     */
    protected void doGet(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        doPost(request, response);
    }
    
    /* (non-Javadoc)
     * @see javax.servlet.http.HttpServlet#doPost(javax.servlet.http.HttpServletRequest, javax.servlet.http.HttpServletResponse)
     */
    protected void doPost(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        
        String reload = request.getParameter("reload");
        boolean doReload = false;
        if ( reload != null) doReload = Boolean.valueOf(reload).booleanValue();
        if (doReload) {
            doReload();
        }

        String view = request.getParameter("view");
        boolean doView = true;
        if ( view != null ) doView = Boolean.valueOf( view ).booleanValue();
        
        if (doView) {
            getServletContext().setAttribute("Providers",getProviderList());
        
            RequestDispatcher dispatcher = getServletContext().getRequestDispatcher(VIEW_JSP_URL);
            dispatcher.forward(request,response);
        }
        
    }
    
    private static void doReload() {
        try {
           Vector v = DigirGetProviders.getProviderList();
           //Vector v = new Vector();
           //v.add( new org.ecoinformatics.ecogrid.digir.impl.providerinfo.ProviderInfo( "FM", "http://digir.fieldmuseum.org:80/digir/DiGIR.php", "MammalsDwC2", "schema" ) );
            Context c = new InitialContext();
            
            c.rebind(PROVIDER_JNDI, v);
        }
        catch ( Exception e ) {
            logger.fatal("Unable to retrieve provider list");
            logger.fatal(e);
        }
    }
    
    public static Vector getProviderList() {
        try {
            Context initCtx = new InitialContext();
            
            Vector v = (Vector) initCtx.lookup(PROVIDER_JNDI);
            return v;
        }
        catch ( NamingException e) {
            return new Vector();
        }
    }
}

