/**
 * 
 */
package org.ecoinformatics.ecogrid.digir.impl.threadpool;

import edu.emory.mathcs.backport.java.util.concurrent.Executors;
import edu.emory.mathcs.backport.java.util.concurrent.ThreadFactory;

/**
 * @author Kevin Ruland
 *
 * DaemonThreadFactory is a simple ThreadFactory implementation which creates
 * Threads with Daemon == true.  This means the Threads will be shutdown when
 * the user threads in the server are killed.  Enables a clean shutdown when executed
 * in Tomcat.
 *
 */
public class DaemonThreadFactory implements ThreadFactory {

    static ThreadFactory defaultThreadFactory = Executors.defaultThreadFactory();
    /* (non-Javadoc)
     * @see edu.emory.mathcs.backport.java.util.concurrent.ThreadFactory#newThread(java.lang.Runnable)
     */
    public Thread newThread(Runnable arg0) {
        Thread t = defaultThreadFactory.newThread(arg0);
        t.setDaemon( true );
        return t;
    }

}
