/**
 *  '$RCSfile: GEONImpl.java,v $'
 *    Authors: Efrat Jaeger
 *    Release: @release@
 *
 *   '$Author: leinfelder $'
 *     '$Date: 2008-01-22 16:46:33 $'
 * '$Revision: 1.3 $'
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 */
package org.ecoinformatics.ecogrid.geon.impl;

//import org.ecoinformatics.ecogrid.EcogridUtils;

import org.apache.log4j.Logger; 
import org.ecoinformatics.ecogrid.queryservice.resultset.ResultsetType; 
import org.ecoinformatics.ecogrid.queryservice.stub.QueryServicePortType; 
import org.ecoinformatics.ecogrid.queryservice.query.QueryType; 

import org.w3c.dom.Document;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.InputSource;

//import java.io.File;
//import java.io.FileInputStream;
import java.rmi.RemoteException;

//import java.io.PrintWriter;
import java.io.StringReader;

import org.apache.axis.client.Call;
import org.apache.axis.client.Service;
//import org.apache.axis.encoding.XMLType;
//import org.apache.axis.utils.Options;
import org.apache.xpath.XPathAPI;

import javax.xml.namespace.QName;
import javax.xml.parsers.DocumentBuilderFactory;
//import javax.xml.rpc.ParameterMode;
//import java.net.URL;

 /**
  * The class implements ecogrid query and get method for geon
  */
public class GEONImpl implements QueryServicePortType
{

	private static final String formatXPATH = "//catalogEntries/catalog";
	private static Logger logger = Logger.getLogger("GEONImpl");

	public GEONImpl()
	{
		//super("GEON query");
	}

	/**
	 * Implementation of query type
	 */
	public ResultsetType query(QueryType query)
		throws RemoteException
	{
		logger.warn("start query method in web service");

		if (query == null)
			return null;

		ResultsetType records = new ResultsetType();

		try {
			// create a query transfer
			EcogridJavaToGEONJavaQueryTransformer queryTransformer = new
				EcogridJavaToGEONJavaQueryTransformer();
			logger.warn("before transforming query");
			String geonSearchQuery[] = queryTransformer.transform(query);
			logger.warn("after transforming query");
			// run metacat query
			logger.warn("before calling geonSearch service");

			// invoke service for each query (keywords and subjects).
			String results[] = new String[geonSearchQuery.length];
			for (int i=0; i<geonSearchQuery.length; i++) {
				results[i] = invokeGEONSearch(geonSearchQuery[i],"getDataResources");
			}
			logger.warn("after calling geonSearch service");

			// create result set tansfer
			logger.warn("calling result transformer");
			GEONJavaToEcogridJavaResultsetTransformer resultTransformer =
				new GEONJavaToEcogridJavaResultsetTransformer();
			records = resultTransformer.transform(results);
			logger.warn("after translating results");
		}//try
		catch (Exception e)
		{
			logger.warn("The exception is: " + e.getMessage());
			throw new RemoteException(e.getMessage());
		}//catch
		return records;
	}//query

  /** Implementation of get method
   * @param identifier  gId
   *
   */
	public byte[] get(String identifier) throws RemoteException {
		byte[] output;

		if (identifier == null)
		{
			throw new RemoteException("Please sepcify the identifier");
		}
		logger.warn("in get method");

		// get id and format.
		logger.warn("identifier is " + identifier);

		try {
			output = getOuputArrayFromGEON(identifier);
			//instantial a transfer object
			logger.warn("after get output array");
		} catch (Exception e) {
			logger.warn("in exception e" + e.getMessage());
			throw new RemoteException(e.getMessage());
		}
		return output;
	}//get

  /**
   * Read ADN metadata and DB schema and write it to output stream
   */
  private byte[] getOuputArrayFromGEON(String identifier)
                                        throws Exception
  {
    byte[] content = null;
    try
    {
    	String adn = "";
    	// get ADN document.
    	logger.warn("before getting adn metadata.");
    	adn = invokeGEONSearch(identifier,"getADNMetaData");
    	logger.warn("after getting adn metadata");

    	if (adn.equals("")) {
    		throw new Exception("No metadata available for id " + identifier);
    	}
    	// get dataset format
 		String format = "";
    	try {
    		logger.warn("before getting dataset format");
     		DocumentBuilderFactory dfactory = DocumentBuilderFactory.newInstance();
     		dfactory.setNamespaceAware(false);
     		InputSource in = new InputSource(new StringReader(adn));
     		Document doc = dfactory.newDocumentBuilder().parse(in);
     		NodeList formats = XPathAPI.selectNodeList(doc, formatXPATH);
     		for (int j=0; j<formats.getLength(); j++) {
     			Node formatNode = formats.item(j).getFirstChild();
     			String formatStr = formatNode.getNodeValue();
     			logger.warn("format string is " + formatStr);
     			if (formatStr.trim().toLowerCase().startsWith("relational")) {
     				format = "relational database";
     				break;
     			}
     		}
 		} catch (Exception ex) {
 			ex.printStackTrace();
 			throw new Exception("Exception in parsing adn metadata for id " + identifier +
 					"\n" + ex.getMessage());
 		}
 		logger.warn("after gettting dataset format. format is " + format);
    	// if database get schema.
 		String dbSchema = "";
    	if (!format.equals("")) { // it is a database
    		logger.warn("before getting database metadata");
    		dbSchema = invokeGEONSearch(identifier, "getDatabaseMetaData");
    		logger.warn("after getting database metadata");
    		int endAdnInd = adn.lastIndexOf("</itemRecord>");
		int schemaBeginInd = dbSchema.indexOf("<databaseMetaData>");
		StringBuffer tmp = new StringBuffer();
		tmp.append(adn.substring(0,endAdnInd));
		tmp.append(dbSchema.substring(schemaBeginInd));
		tmp.append(adn.substring(endAdnInd));
		adn = tmp.toString();  
	}
    	// the output is the adn metadata and the database schema
       // String xml = adn + dbSchema;
       // content = xml.getBytes();
	content = adn.getBytes();
    } catch (Exception except) {
      throw except;
    }
    return content;
  }

  	/** Invoke the GEON search service to get matching datasets
     * @param query   web service input.
     * @return
     */
    private String invokeGEONSearch(String query, String methodName) {
    	try {

	     // service's endpoint
	     String endPoint =
	         "http://geon01.sdsc.edu:8164/axis/services/GEONResources?wsdl";

	     // Set up the remote method call
	     Service  service = new Service();
	     Call call = (Call) service.createCall();
	     call.setTargetEndpointAddress( new java.net.URL(endPoint));
	     call.setOperationName( new QName("GEONResources", methodName) );

	     Object obj[] = new Object[1];
	     obj[0] = query;
	     // Perform the remote call
	     logger.warn("before invoking service");
	     String ret = (String)call.invoke(obj);
	     logger.warn("after invoking service");
	     return ret;
    	} catch (Exception e) {
    		e.printStackTrace();
    		return null;
    	}
    }
}
