/**
 *    Purpose: A Class that implements put service for metacat data mgmt system.
 *  Copyright: 2004 Regents of the University of California and
 *             San Diego Supercomputer Center
 *    Authors: Bing Zhu 
 *             Sept 14, 2004
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 */
package org.ecoinformatics.ecogrid.lsid;

import java.rmi.RemoteException;
import java.util.Vector;

import org.ecoinformatics.ecogrid.lsid.stub.IdentifierServicePortType;

import com.ibm.lsid.LSID;

import edu.ucsb.nceas.metacat.client.Metacat;
import edu.ucsb.nceas.metacat.client.MetacatFactory;
import edu.ucsb.nceas.metacat.properties.PropertyService;
import edu.ucsb.nceas.metacat.util.SystemUtil;

/**
 * The class implements the Ecogrid Identifier Service
 */
public class IdentifierService implements IdentifierServicePortType
{ 
  private static String metacatUrl="http://pacific.msi.ucsb.edu:8080/knb/metacat";
  static
  {
     
     try
     { 
         String tmp = SystemUtil.getServletURL();
         if (tmp != null && tmp.length() >0)
         {
             System.out.println("mecatulr is "+tmp);
             metacatUrl = tmp;
         }
     }
     catch (Exception e)
     {
         e.printStackTrace(System.err);
     }
  }
  /**
   * check to see if the given lsid is registered on the system
   */
  public java.lang.String isRegistered(java.lang.String parameter) 
    throws java.rmi.RemoteException
  { 
    String lsid = parameter;
    try
    {
      Metacat metacat = MetacatFactory.createMetacatConnection(metacatUrl);
      LSID klsid = new LSID(lsid);
      String docid = klsid.getNamespace() + "." + klsid.getObject() + "." + 
        klsid.getRevision();
      boolean b = metacat.isRegistered(docid);
      if(b)
      {
        return "true";
      }
      return "false";
    }
    catch(Exception e)
    {
      System.out.println("exception: " + e.getMessage());
      throw new RemoteException("Error accessing metacat: " + e.getMessage());
    }
  }
  
  /**
   * add and lsid to the system.  The only way to add an id to the metacat
   * system is to add a document, so this method will always throw a
   * RemoteException when used with the metacat system.
   */
  public java.lang.String addLSID(java.lang.String parameter) 
    throws java.rmi.RemoteException
  {
    throw new RemoteException("This method is not supported by metacat.  To "+ 
      "add a new LSID, add a document to metacat.");
  }
  
  /**
   * return the next usable revision of the lsid given.  this method is 
   * not synchronized so you may still get an exception when adding a 
   * document if someone else adds a document with the revision before you.
   */
  public java.lang.String getNextRevision(java.lang.String parameter) 
    throws java.rmi.RemoteException
  { 
    String lsid = parameter;
    try
    {
      Metacat metacat = MetacatFactory.createMetacatConnection(metacatUrl);
      LSID klsid = new LSID(lsid);
      int rev = metacat.getNewestDocRevision(klsid.getNamespace() + "." + 
        klsid.getObject());
      return "urn:lsid:" + klsid.getAuthority() + ":" + klsid.getNamespace() +
        ":" + klsid.getObject() + ":" + (rev + 1);
    }
    catch(Exception e)
    {
      throw new RemoteException("Error getting next revision for lsid " + 
        lsid + ": " + e.getMessage());
    }
  }
  
  /**
   * returns the next object number available in the storage system.  this 
   * method is not synchronized so you may still get an exception when adding a 
   * document if someone else adds a document with the revision before you.
   */
  public java.lang.String getNextObject(java.lang.String parameter) 
    throws java.rmi.RemoteException
  {
    String lsid = parameter;
    try
    {
      Metacat metacat = MetacatFactory.createMetacatConnection(metacatUrl);
      LSID klsid = new LSID(lsid);
      String obj = metacat.getLastDocid(klsid.getNamespace());
      if(obj == null || obj.equals("") || obj.equals("null"))
      {
        obj = "1";
      }
      else
      {
        obj = obj.substring(obj.indexOf(".") + 1, obj.lastIndexOf("."));
      }
      int intObj = new Integer(obj).intValue();
      return "urn:lsid:" + klsid.getAuthority() + ":" + klsid.getNamespace() +
        ":" + (intObj + 1) + ":1";
    }
    catch(Exception e)
    {
      throw new RemoteException("Error getting next object for lsid " + 
        lsid + ": " + e.getMessage());
    }
  }
  
  /**
   * returns a list of all docids in metacat.  The partial lsid is in the form:
   * <authority>:<namespace> where authority is required.  this is a total hack
   * because web services are kinda lame and they makes it impossible to pass 
   * two strings into a method.
   */
  public java.lang.String getAllIds(java.lang.String partialLSID) throws java.rmi.RemoteException
  {
    try
    {
      String namespace = null;
      String authority = null;
      if(partialLSID == null)
      {
        throw new RemoteException("partialLSID cannot be null.  it must include " +
          "at least an authority");
      }
      else
      {
        if(partialLSID.indexOf(":") != -1)
        {
          authority = partialLSID.substring(0, partialLSID.indexOf(":"));
          namespace = partialLSID.substring(partialLSID.indexOf(":") + 1, 
            partialLSID.length());
        }
        else
        {
          authority = partialLSID;
        }
      }
      Metacat metacat = MetacatFactory.createMetacatConnection(metacatUrl);
      Vector v = metacat.getAllDocids(namespace);
      String returnString = "";
      for(int i=0; i<v.size(); i++)
      {
        String id = (String)v.elementAt(i);
        id = id.replace('.', ':');
        String lsid = "urn:lsid:" + authority + ":" + id;
        returnString += lsid + "\n"; //return a string list...yuck...stupid soap
      }
      return returnString;
    }
    catch(Exception e)
    {
      throw new RemoteException("Error getting id list: " + e.getMessage());
    }
  }
}
