/**
 *    Purpose: A Class that implements put service for metacat data mgmt system.
 *  Copyright: 2004 Regents of the University of California and
 *             San Diego Supercomputer Center
 *    Authors: Bing Zhu 
 *             Sept 14, 2004
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 */
package org.ecoinformatics.ecogrid.metacat.auth;

import java.rmi.RemoteException;

import org.apache.log4j.Logger;
import org.ecoinformatics.ecogrid.auth.stub.AuthenticationServiceLoginRequestElementType;
import org.ecoinformatics.ecogrid.auth.stub.AuthenticationServicePortType;

import edu.ucsb.nceas.metacat.client.MetacatClient;
import edu.ucsb.nceas.metacat.client.MetacatFactory;
import edu.ucsb.nceas.metacat.properties.PropertyService;
import edu.ucsb.nceas.metacat.util.SystemUtil;


/**
 * The class implements Metacat authentication service
 */
public class MetacatAuthImpl implements AuthenticationServicePortType 
{
   // Actual value is set by metacat configuration
   private static String metacatUrl = "http://indus.nceas.ucsb.edu/knb-oracle/metacat";
   private static Logger logMetacat = Logger.getLogger(MetacatAuthImpl.class);
   static
        {
           
           try
           {
               
               String tmp = SystemUtil.getServletURL();
               if (tmp != null && tmp.length() >0)
               {
                   metacatUrl = tmp;
                   System.out.println("MetacatAuthImpl() - metacatUrl set to: " +  metacatUrl);
               }
           }
           catch (Exception e)
           {
               e.printStackTrace(System.err);
           }
        }
   public MetacatAuthImpl()
   {
      //super("Metacat Authetication Service");
   }

   // read metacat config file which is $TOMCAT_HOME/webapps/ogsa/WEB-INF/etc/MetacatConfig.xml.
   private void getMetacatConfig() throws Exception
   {
      
      
   }

   // EcogridUtils.debugMessage("UploadMetacatMetadata() exception: " + e.getMessage());
   // throw new RemoteException(e.getMessage());
   // public java.lang.String login(java.lang.String userName, java.lang.String passWord) throws RemoteException
   public String login(AuthenticationServiceLoginRequestElementType loginRequest)throws RemoteException
   {
      logMetacat.debug("MetacatAuthImpl.login - metacat login: " + loginRequest.getUserName() 
    		  + " : " + loginRequest.getPassWd());

      String sessionId = "an unknown error";

      try
      {
         
         MetacatClient m = (MetacatClient)MetacatFactory.createMetacatConnection(metacatUrl);
        
         String user = loginRequest.getUserName();
         String passwd = loginRequest.getPassWd();
         m.login(user, passwd);
         sessionId = m.getSessionId();
      } 
      catch(Exception e)
      {
         
         e.printStackTrace(System.err);
         throw new RemoteException(e.getMessage());
      }

     logMetacat.debug("MetacatAuthImpl.login - login sessionid: " + sessionId);

      return sessionId;
   }

   public String logout(java.lang.String sessionId) throws RemoteException
   {
      

      logMetacat.debug("MetacatAuthImpl.logout - metacat logout sessionId: " + sessionId);
      
      String retMsg = "logout succeeded.";
     
      try
      {
         MetacatClient m = (MetacatClient)MetacatFactory.createMetacatConnection(metacatUrl);
         m.setSessionId(sessionId);
         m.logout();
      }
       catch(Exception e)
      {
         throw new RemoteException(e.getMessage());
      }

      return retMsg;
   }
   
   // EcogridUtils.debugMessage("UploadMetacatMetadata() exception: " + e.getMessage());
   // throw new RemoteException(e.getMessage());
   // public java.lang.String login(java.lang.String userName, java.lang.String passWord) throws RemoteException
   public String validateSession(java.lang.String sessionId ) throws RemoteException
   {
      logMetacat.debug("MetacatAuthImpl.validateSession - validating metacat session: " + sessionId);
      String resultXML;

      try
      {
         
         MetacatClient m = (MetacatClient)MetacatFactory.createMetacatConnection(metacatUrl);
        
         resultXML =  m.validateSession(sessionId);
      } 
      catch(Exception e)
      {
         
         e.printStackTrace(System.err);
         throw new RemoteException(e.getMessage());
      }

     logMetacat.debug("MetacatAuthImpl.validateSession - result: " + resultXML);

      return resultXML;
   }
}
