/**
 *  '$RCSfile: EcogridJavaToMetacatJavaQueryTransformer.java,v $'
 *    Purpose: A Class that implements replication for metacat
 *  Copyright: 2000 Regents of the University of California and the
 *             National Center for Ecological Analysis and Synthesis
 *    Authors: Chad Berkley
 *    Release: @release@
 *
 *   '$Author: leinfelder $'
 *     '$Date: 2008-10-02 18:11:16 $'
 * '$Revision: 1.16 $'
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 */
package org.ecoinformatics.ecogrid.metacat.impl;

import edu.ucsb.nceas.metacat.properties.PropertyService;
import edu.ucsb.nceas.metacat.QueryGroup;
import edu.ucsb.nceas.metacat.QuerySpecification;
import edu.ucsb.nceas.metacat.QueryTerm;

import java.util.Hashtable;
import java.util.Vector;

import org.apache.axis.types.URI;
import org.apache.log4j.Logger;

import org.ecoinformatics.ecogrid.queryservice.query.ANDType;
import org.ecoinformatics.ecogrid.queryservice.query.ConditionType;
//import org.ecoinformatics.ecogrid.queryservice.query.LimitedXPathExpression;
import org.ecoinformatics.ecogrid.queryservice.query.OperatorType;
import org.ecoinformatics.ecogrid.queryservice.query.ORType;
import org.ecoinformatics.ecogrid.queryservice.query.QueryType;
import org.ecoinformatics.ecogrid.queryservice.query.QueryTypeNamespace;



public class EcogridJavaToMetacatJavaQueryTransformer
{
  public static final String INTERSECT = "INTERSECT";
  public static final String UNION     = "UNION";
  public static final String ALLPATH   = "/";
  private Hashtable operatorNameMatch = null;
  private static Logger logMetacat = Logger.getLogger(MetacatImpl.class);
  /**
   * Default constructor
   *
   */
  public EcogridJavaToMetacatJavaQueryTransformer()
  {
    setupOperatorMatchTable();
  }


  /**
   * Method to transfer a ecogrid query java object to metacat query java object
   */
   public QuerySpecification transform(QueryType ecogridQuery) throws Exception
   {
        logMetacat.warn("in the begin of transform");
        QuerySpecification metacatQuery = null;
        // make sure the parameter is not null
       if (ecogridQuery == null)
       {
          return metacatQuery;
       }
       //instantial metacat query specification
       metacatQuery =
               new QuerySpecification(PropertyService.getProperty("document.accNumSeparator"));
       logMetacat.warn("after instantial a metacat queryspecification");
       // set up query id
      String id = ecogridQuery.getQueryId();
      logMetacat.warn("query id: "+ id);
      metacatQuery.setIdentifier(id);
      // set up query title
      String [] titleList = ecogridQuery.getTitle();
      String title = titleList[0];
      logMetacat.warn("query title - " + title);
      metacatQuery.setQueryTitle(title);
      // set up return doc type
      Vector returnDocTypeList =
                namespaceToDocList(ecogridQuery.getNamespace());
      metacatQuery.setReturnDocList(returnDocTypeList);
      // set up return fields
      transferReturnField(ecogridQuery, metacatQuery);
      // tarnsfer AND, OR, Condition to QueryGroup.
      transferQueryGroup(ecogridQuery, metacatQuery);
      logMetacat.warn("The metacat query toString is: "+
                              metacatQuery.toString());
      logMetacat.warn("in the end of transform");
      return metacatQuery;
  }//transfer

  /* Method to transfer namespace to returnDocTypeList */
  private Vector namespaceToDocList(QueryTypeNamespace[] nameSpaceList)
  {
    logMetacat.warn("start of namespaceToDocList()");
    // vector contains string object
    Vector returnList = new Vector();
    // make sure parameter is not null
    if ( nameSpaceList == null || nameSpaceList.length == 0)
    {
      return returnList;
    }

   //got through the array
    for (int i=0; i<nameSpaceList.length;i++)
    {
       //get name space
       QueryTypeNamespace nameSpace = nameSpaceList[i];

      String docTypeStr = nameSpace.get_value();
      logMetacat.warn("the return doc list(namespace) is " + docTypeStr);
      returnList.add(docTypeStr);
    }
    logMetacat.warn("end of namespaceToDocList()");
    return returnList;
  }//namespaceToDocList

  /* Method to transfer returnField*/
  private void transferReturnField(QueryType ecogridQuery,
                                   QuerySpecification metacatQuery)
  {
     logMetacat.warn("start of transferReturnField");
     String [] returnFieldList =ecogridQuery.getReturnField();
     if (returnFieldList != null)
     {
       for ( int i=0; i< returnFieldList.length; i++)
       {
         String returnField = returnFieldList[i];
         logMetacat.warn("returnField is " + returnField);
         metacatQuery.handleReturnField(returnField);
       }//for
     }//if
     logMetacat.warn("end of transferReturnField");
  }//tansferReturnField

  /* Method to transfer AND, OR, Condition to query group*/
  private void transferQueryGroup(QueryType ecogridQuery,
                                  QuerySpecification metacatQuery)
                                  throws Exception
  {
    logMetacat.warn("start of transferQueryGroup()");
    QueryGroup query = null;
    //first level, ecogridQuery can only have one AND or one OR or one Condition
    if (ecogridQuery.getAND() != null)
    {
      logMetacat.warn("first level is AND");
      // And relation in first level
      query = new QueryGroup(INTERSECT);
      handleANDChildren(query, ecogridQuery.getAND());
    }
    else if (ecogridQuery.getOR() != null)
    {
      logMetacat.warn("first level is OR");
      // OR relation in first level
      query = new QueryGroup(UNION);
      handleORChildren(query, ecogridQuery.getOR());
    }
    else if (ecogridQuery.getCondition() != null)
    {
      logMetacat.warn("first level is Condition");
      // Condition in first level
      query = new QueryGroup(INTERSECT);
      handleConditionType(query, ecogridQuery.getCondition());
    }
    else
    {
      logMetacat.warn("Wrong format of query");
      throw new Exception("Wrong Ecogrid Query Format");
    }
    metacatQuery.setQueryGroup(query);
    logMetacat.warn("end of transferQueryGroup()");
  }//tansferQueryGroup

  /* Handle ANDType's children, querygroup is same level to andtype*/
  private void handleANDChildren(QueryGroup metacatParent, ANDType andParent)

  {
    logMetacat.warn("start of handleANDChildren()(parent is AND)");
    // make sure parameter is not null
    if (metacatParent == null || andParent == null)
    {
      logMetacat.warn("query group is null or andparent is null");
      return;
    }
    // if ANDType's children is array, the code need be modified.
    if (andParent.getAND() != null)
    {
      for ( int i = 0; i<andParent.getAND().length; i++)
      {
        logMetacat.warn("add AND childen to parent AND");
        handleANDType(metacatParent, andParent.getAND(i));
      }//for
    }//if
    if (andParent.getOR() != null)
    {
      for ( int i = 0; i<andParent.getOR().length; i++)
      {
         logMetacat.warn("add OR childen to parent AND");
         handleORType(metacatParent, andParent.getOR(i));
      }//for
    }//if
    if (andParent.getCondition() != null)
    {
      for ( int i= 0; i<andParent.getCondition().length; i++)
      {
        logMetacat.warn("add Condition childen to parent AND");
        handleConditionType(metacatParent, andParent.getCondition(i));
      }//for
    }//if
    logMetacat.warn("end of handleANDChildren()(parent is AND)");
  }//handlANDChildren

  /* Handle ORType's children */
  private void handleORChildren(QueryGroup metacatParent, ORType orParent)

  {
    logMetacat.warn("start of handleORChildren()(parent is OR)");
    // make sure parameter is not null
    if (metacatParent == null || orParent == null)
    {
      return;
    }

    // if ANDType's children is array, the code need be modified
    if (orParent.getAND() != null)
    {
      for ( int i = 0; i<orParent.getAND().length; i++)
      {
        logMetacat.warn("add AND childen to parent OR");
        handleANDType(metacatParent, orParent.getAND(i));
      }//for
    }//if
    if (orParent.getOR() != null)
    {
      for ( int i = 0; i<orParent.getOR().length; i++)
      {
        logMetacat.warn("add OR childen to parent OR");
        handleORType(metacatParent, orParent.getOR(i));
      }//for
    }//if
    if (orParent.getCondition() != null)
    {
      for ( int i= 0; i<orParent.getCondition().length; i++)
      {
        logMetacat.warn("add Condtion childen to parent OR");
        handleConditionType(metacatParent, orParent.getCondition(i));
      }
    }
    logMetacat.warn("end of handleORChildren()(parent is OR)");
  }

  /* Method to handle AND type, querygroup is higer level than andType*/
  private void handleANDType(QueryGroup parent, ANDType and)
  {
    logMetacat.warn("start handleANDType()");
    // make sure parameter is not null
    if (parent == null || and == null)
    {
      return;
    }
    QueryGroup kid = new QueryGroup(INTERSECT);
    parent.addChild(kid);
    //handle childen of kid
    handleANDChildren(kid, and);
    logMetacat.warn("end handleANDType()");
  }// handleANDType

  /* Method to handle OR type*/
  private void handleORType(QueryGroup parent, ORType or)
  {
    logMetacat.warn("start handleORType()");
    // make sure parameter is not null
    if (parent == null || or == null)
    {
      return;
    }
    QueryGroup kid = new QueryGroup(UNION);
    parent.addChild(kid);
    //handle childen of kid
    handleORChildren(kid, or);
    logMetacat.warn("end handleORType()");
  } //handleORType

  /* Method to handle Condition type */
  private void handleConditionType(QueryGroup parent, ConditionType condition)
  {
    logMetacat.warn("start of handleConditionType()");
    QueryTerm term = null;
    if (parent == null || condition == null)
    {
      return;
    }
    //get path
    //LimitedXPathExpression xpath = condition.getConcept();
    //String pathString = xpath.getValue();
    String pathString = condition.getConcept();
    logMetacat.warn("path express is " + pathString);
    if (pathString != null && pathString.equals(ALLPATH))
    {
        pathString = null;
        logMetacat.warn("ALLPATH string was replaced by null");
    }
    //get operator
    OperatorType operator = condition.getOperator();
    String operatorString = operator.getValue();
    String metacatOperator = lookupMetacatOperator(operatorString);
     //get value
    String       value    = condition.get_value();
    logMetacat.warn("value for path is " + value);
    term = new QueryTerm(false, metacatOperator, value, pathString);
    parent.addChild(term);
    logMetacat.warn("end of handleConditionType()");
  }//handleConditionType

  /* Method to find a metacat operator for in input string*/
  private String lookupMetacatOperator(String input)
  {
    logMetacat.warn("operator in ecogrid(input) is " + input);
    String operator = null;
    operator = (String) operatorNameMatch.get(input);
    logMetacat.warn("operator in metacat(output) is " + operator);
    return operator;
  }//lookupMetacatOperator

  /* Method to set up hashtable for search mode (operator)*/
  private void setupOperatorMatchTable()
  {
    operatorNameMatch = new Hashtable();
     //"LIKE";
     operatorNameMatch.put(OperatorType._value1, "contains");
     //"NOT LIKE";
    operatorNameMatch.put(OperatorType._value2, "not-contains");
     //"EQUALS";
    operatorNameMatch.put(OperatorType._value3, "equals");
     //"NOT EQUALS"
    operatorNameMatch.put(OperatorType._value4, "isnot-equal");
     // "LESS THAN";
    operatorNameMatch.put(OperatorType._value5, "less-than");
     //"LESS THAN OR EQUALS";
    operatorNameMatch.put(OperatorType._value6, "less-than-equals");
    // "GREATER THAN";
    operatorNameMatch.put(OperatorType._value7, "greater-than");
    //"GREATER THAN OR EQUALS";
    operatorNameMatch.put(OperatorType._value8, "greater-than-equals");

  }
}
