/**
 *    Purpose: A Class that implements put service for metacat data mgmt system.
 *  Copyright: 2004 Regents of the University of California and
 *             San Diego Supercomputer Center
 *    Authors: Bing Zhu 
 *             Sept 14, 2004
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 */
package org.ecoinformatics.ecogrid.metacat.put;

import java.io.ByteArrayInputStream;
import java.io.StringReader;
import java.rmi.RemoteException;

import org.apache.log4j.Logger;
import org.ecoinformatics.ecogrid.EcogridObjType;
import org.ecoinformatics.ecogrid.put.stub.PutServiceElementType;
import org.ecoinformatics.ecogrid.put.stub.PutServicePortType;
import org.ecoinformatics.ecogrid.put.stub.PutServiceResponseElementType;

import edu.ucsb.nceas.metacat.client.MetacatClient;
import edu.ucsb.nceas.metacat.client.MetacatFactory;
import edu.ucsb.nceas.metacat.properties.PropertyService;
import edu.ucsb.nceas.metacat.util.SystemUtil;





/**
 * The class implements Metacat put service
 */
//public class MetacatPutImpl extends GridServiceImpl implements EcoGridPutInterfaceLevelOnePortType
public class MetacatPutImpl implements PutServicePortType
{
    // Actual value is set by metacat configuration
   private static String uploadMetacatURL = "http://indus.nceas.ucsb.edu/knb-oracle/metacat";
   private static Logger logMetacat = Logger.getLogger(MetacatPutImpl.class);
   static
        {
           
           try
           {
               
               String tmp = SystemUtil.getServletURL();
               if (tmp != null && tmp.length() >0)
               {
                  uploadMetacatURL = tmp;
               }
           }
           catch (Exception e)
           {
               e.printStackTrace(System.err);
           }
        }
   public MetacatPutImpl()
   {
      
   }

   // read metacat config file which is $TOMCAT_HOME/webapps/ogsa/WEB-INF/etc/MetacatConfig.xml.
   // the file will look like:
   //<?xml version="1.0" encoding="ISO-8859-1"?>
   //<metacatConfig>
   //   <metacatURL>http://pine.nceas.ucsb.edu:8090/ogsa/metacat</metacatURL>
   //   <debugOn>yes</debugOn>
   //</metacatConfig>
   

   public PutServiceResponseElementType put(PutServiceElementType putElement) throws RemoteException
   {
	   PutServiceResponseElementType type = null;
      // read config info dynamically from ecogrid config file.
      //GetMetacatConfig();
       byte[] objData = putElement.getObjData();
       String objectId = putElement.getObjectId();
       String name = putElement.getObjectName();
       int objType = putElement.getObjType();
       String sessionId = putElement.getSessionId();
       logMetacat.info("server side metcat put is called." + " session Id is: " + sessionId);
      
      // always showing this message in catalina.out
      logMetacat.info("metacat URL for put(): " + uploadMetacatURL + "\n");
      // System.out.println("debug value: " + EcogridUtils.isDebugOn() + "\n");

      if(objType == EcogridObjType.DATA)
      {
          UploadMetacatData(objData, objectId, name, sessionId);

          logMetacat.info("Uploading data succeeded.");
      }
      else if(objType == EcogridObjType.METADATA)
      {
          UploadMetacatMetadata(objData, objectId, sessionId);

          logMetacat.info("Uploading metadata succeeded.");
      }
      else
      {
          logMetacat.warn("Metacat put(): Unknown Ecogrid data type. The data type is 'data' or 'metadata'.");
          throw new RemoteException("Unknown Ecogrid data type. The data type is 'data' or 'metadata'.");
      }
      return type;
   }

   private void UploadMetacatData(byte[] bytes, String docId, String name, String sessionId) throws RemoteException
   {
       logMetacat.info("UploadMetacatData()");

       int n;
       n = bytes.length;

       try
       {
          MetacatClient mc = (MetacatClient)MetacatFactory.createMetacatConnection(uploadMetacatURL);
          mc.setSessionId(sessionId);

          ByteArrayInputStream byteInStream = new ByteArrayInputStream(bytes,0,n);

          if (name == null || name.length() == 0) {
        	  name = "rawdata";
          }          
          
          String response = mc.upload(docId, name, byteInStream, n);
    
          if((response.indexOf("<success>") == -1) || (response.indexOf(docId) == -1))
          {
             logMetacat.warn("UploadMetacatData() exception: " + response);
             throw new RemoteException(response);
          }
       }
       catch (Exception e)
       {
           logMetacat.warn("UploadMetacatData() exception: " + e.getMessage());
           throw new RemoteException(e.getMessage());
       }
   }

   private void UploadMetacatMetadata(byte[] bytes, String docId, String sessionId) throws RemoteException
   {
       logMetacat.info("UploadMetacatMetadata()");

       try
       {
          MetacatClient mc = (MetacatClient)MetacatFactory.createMetacatConnection(uploadMetacatURL);
          mc.setSessionId(sessionId);

          String docString = new String(bytes);
          int rev = getRev(docId);
          String response = null;
          if (rev ==1)
          {
            response = mc.insert(docId, new StringReader(docString), null);
          }
          else if (rev >1)
          {
        	  try {
        		  response = mc.update(docId, new StringReader(docString), null);
        	  }
        	  catch (Exception e) {
        		  //try to insert it then
        		  response = mc.insert(docId, new StringReader(docString), null);
			}
          }
          else
          {
            throw new RemoteException("Specified docid is incorrect");  
          }
          

          if((response.indexOf("<success>")==-1)||(response.indexOf(docId)==-1))
          {
              logMetacat.warn("UploadMetacatMetadata() exception: " + response);
              throw new RemoteException(response);
          }
       }
       catch(Exception e)
       {
          logMetacat.warn("UploadMetacatMetadata() exception: " + e.getMessage());
          throw new RemoteException(e.getMessage());
       }
   }
   
   private int getRev (String accessionNumber) throws RemoteException
   {
       int revNumber = -1;
       String rev = null;
       if (accessionNumber == null) 
       { 
           throw new RemoteException("Specified docid couldn't be null"); 
       }
       String seperator = ".";
       int indexOfLastSeperator = accessionNumber.lastIndexOf(seperator);
       rev = accessionNumber.substring(indexOfLastSeperator + 1,
               accessionNumber.length());
       revNumber = Integer.parseInt(rev);
       logMetacat.info("after parsing accessionnumber, rev is "
               + revNumber);
       return revNumber;
   }
}
