/**
 *  '$RCSfile: EcogridResultsetParser.java,v $'
 *    Purpose: A Class that implements replication for metacat
 *  Copyright: 2000 Regents of the University of California and the
 *             National Center for Ecological Analysis and Synthesis
 *    Authors: Rod Spears
 *    Release: @release@
 *
 *   '$Author: ruland $'
 *     '$Date: 2005-12-15 21:18:45 $'
 * '$Revision: 1.7 $'
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 */
package org.ecoinformatics.ecogrid.queryservice.util;

import org.apache.axis.MessageContext;
import org.apache.axis.client.AxisClient;
import org.apache.axis.encoding.DeserializationContext;
import org.apache.axis.encoding.ser.BeanDeserializer;
import org.apache.axis.message.SOAPHandler;

import org.xml.sax.Attributes;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

import org.ecoinformatics.ecogrid.queryservice.resultset.ResultsetType;

/**
 * Converts a Resultset from XML to HTML
 * @author Rod Spears
 */

public class EcogridResultsetParser
{

    /**
     * Consumes the Ecogrid Resultset from a file and returns ResultsetType Object
     * @param aFileName XML File representing the resultset
     * @return ResultsetType
     */
    public static ResultsetType parseXMLFile(String aFileName) throws SAXException
    {
       InputSource is = new InputSource( aFileName );
       return parse( is );
    }

   public static ResultsetType parse( InputSource is ) throws SAXException
   {
      MessageContext mctx = new MessageContext( new AxisClient() );
      DeserializationContext dctx = new DeserializationContext( is, mctx, "resultset" );
      ResultsetBuilder builder = new ResultsetBuilder();
      dctx.replaceElementHandler( builder );
      dctx.parse();
      return builder.getResultsetType();
   }

   /**
    * For Testing
    */
   public static void main(String[] args) throws Exception
   {
      ResultsetType rs = parseXMLFile("/home/globus/workspace/kepler/rs.xml");
      String rsStr = EcogridResultsetTransformer.toXMLString(rs);
      System.out.println(rsStr);
   }
}

class ResultsetBuilder extends SOAPHandler
{
   
   private BeanDeserializer handler;
   
   public ResultsetBuilder() {}
   
   public SOAPHandler onStartChild( String namespace,
                                    String localName,
                                    String prefix,
                                    Attributes attributes,
                                    DeserializationContext ctx )
      throws SAXException
   {
      
      // Should test that namespace and localName are both correct.
      
      handler = (BeanDeserializer) ResultsetType.getDeserializer( "",
                                                                  ResultsetType.class,
                                                                  ResultsetType.getTypeDesc().getXmlType() );
      
      return handler;
   }
   
   public ResultsetType getResultsetType()
   {
      return (ResultsetType) handler.getValue();
   }
}

