/**
 * EcoRegCLient.java
 *
 */

package org.ecoinformatics.ecogrid.registry.impl;

import org.ecoinformatics.ecogrid.registry.RegEntry;

import org.ecoinformatics.ecogrid.registry.EcoRegInterfacePortType;
import org.ecoinformatics.ecogrid.registry.EcoRegInterfaceServiceLocator;
import java.net.URL;

public class EcoRegClient 
{
  public EcoRegClient()
  {
  }

  public static void main(String[] args)
  {
    try
    {
      // Get command-line arguments
      //String urlStr = "http://localhost:8080/ogsa/services/org/ecoinformatics/ecogrid/registry/EcoRegistryService";
      String urlStr = "http://localhost:8080/ogsa/services/@service.name@";
      System.out.println("Connecting to service["+urlStr+"]");

      URL GSH = new java.net.URL(urlStr);

      // Get a reference to the remote web service
      EcoRegInterfaceServiceLocator registryService = new EcoRegInterfaceServiceLocator();
      EcoRegInterfacePortType registry = registryService.getEcoRegInterfaceService(GSH);

      // Call remote method 'add'
      int status = registry.registerEntry("1", "2", "3");
      System.out.println("registerEntry Status: " + status);
      RegEntry[] list = registry.getList();
      if (list != null) {
        System.out.println("Registry List:");
        for (int i=0;i<list.length;i++) {
          System.out.println(i + " - " + list[i].getName());
        }
      } else {
        System.out.println("List was empty!");
      }
      status = registry.registerEntry("1XXX", "2", "3");
      System.out.println("registerEntry Status: " + status);
      
      status = registry.removeEntry("1XXX");
      System.out.println("removeEntry Status: " + status);

      // Print result
      //System.out.println("getList Status: " + status);
    } 
    catch(Exception e)
    {
      System.out.println("ERROR!");
      e.printStackTrace();
    }
  }
}

