/**
 *  '$RCSfile: EcogridJSPBeanFactory.java,v $'
 *  Copyright: 2004 Regents of the University of California and the
 *              National Center for Ecological Analysis and Synthesis
 *  Purpose: To test the MetaCatURL class by JUnit
 *    Authors: @Rod Spears@
 *    Release: @release@
 *
 *   '$Author: rspears $'
 *     '$Date: 2004-03-09 18:13:50 $'
 * '$Revision: 1.1 $'
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 */


package org.ecoinformatics.ecogrid.registry.impl;

import org.ecoinformatics.ecogrid.EcogridUtils;

/**
 * Ecogrid JSP Bean - Helper class to aid in reusability of functionality
 * needed for JSP pages. This encapsulates all the SOAP calls from JSP
 *
 * @author  Rod Spears
 */
public class EcogridJSPBeanFactory
{
  /**
   * Constructor
   */
  public EcogridJSPBeanFactory()
  {
    EcogridUtils.setDebug(true);
    EcogridUtils.debugMessage("Created EcogridJSPBeanFactory.");
  }

  public EcogridJSPBeanIFace createEcogridJSPBean(String aType)
  {
    System.out.println("**** createEcogridJSPBean ["+aType+"]");
    EcogridUtils.debugMessage("**** createEcogridJSPBean ["+aType+"]");

    if (aType.equals("GLOBUS")) {
      return new EcogridJSPGlobusBean();
    }
    return null;
  }

}
