/**
 *    '$RCSfile: DocTypesPanel.java,v $'
 *
 *     '$Author: rspears $'
 *       '$Date: 2004-10-26 15:14:04 $'
 *   '$Revision: 1.1 $'
 *
 *  For Details: http://kepler.ecoinformatics.org
 *
 * Copyright (c) 2003 The Regents of the University of California.
 * All rights reserved.
 *
 * Permission is hereby granted, without written agreement and without
 * license or royalty fees, to use, copy, modify, and distribute this
 * software and its documentation for any purpose, provided that the
 * above copyright notice and the following two paragraphs appear in
 * all copies of this software.
 *
 * IN NO EVENT SHALL THE UNIVERSITY OF CALIFORNIA BE LIABLE TO ANY PARTY
 * FOR DIRECT, INDIRECT, SPECIAL, INCIDENTAL, OR CONSEQUENTIAL DAMAGES
 * ARISING OUT OF THE USE OF THIS SOFTWARE AND ITS DOCUMENTATION, EVEN
 * IF THE UNIVERSITY OF CALIFORNIA HAS BEEN ADVISED OF THE POSSIBILITY
 * OF SUCH DAMAGE.
 *
 * THE UNIVERSITY OF CALIFORNIA SPECIFICALLY DISCLAIMS ANY WARRANTIES,
 * INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES OF
 * MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE. THE SOFTWARE
 * PROVIDED HEREUNDER IS ON AN "AS IS" BASIS, AND THE UNIVERSITY
 * OF CALIFORNIA HAS NO OBLIGATION TO PROVIDE MAINTENANCE, SUPPORT,
 * UPDATES, ENHANCEMENTS, OR MODIFICATIONS.
 */

package org.ecoinformatics.ecogrid.registry.ui;

import java.awt.BorderLayout;
import java.awt.GridBagLayout;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.util.Enumeration;

import javax.swing.AbstractAction;
import javax.swing.DefaultListModel;
import javax.swing.JButton;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;

import org.ecoinformatics.ecogrid.registry.stub.EcogridRegEntryType_documentType;

/**
 * @author Rod Spears
 *
 * An editor panel for adding DocType elements to a registry entry
 */
public class DocTypesPanel extends JPanel implements ListSelectionListener
{
    private JList            mList           = null;
    private JTextField       mNameSpaceTF    = new JTextField();
    private JTextField       mLabelTF        = new JTextField();
    private JButton          mAddBtn         = new JButton("Add");
    private JButton          mDelBtn         = new JButton("Delete");
    private JButton          mUpdateBtn      = new JButton("Update");
    private boolean          mChanged        = false;
    private DefaultListModel mListModel      = new DefaultListModel();

    
    /**
     * Default Constructor
     *
     */
    public DocTypesPanel()
    {
        setLayout(new BorderLayout());
        
        mList = new JList(mListModel);
        mList.getSelectionModel().addListSelectionListener(this);
        
        JScrollPane scroller = new JScrollPane(mList);
        add(scroller, BorderLayout.CENTER);
        
        JPanel controlPanel = new JPanel(new BorderLayout());
        JPanel tfPanel = new JPanel(new GridBagLayout());
        RegBaseDlg.addField(tfPanel, "Label", 0, mLabelTF);
        RegBaseDlg.addField(tfPanel, "Namespace", 1, mNameSpaceTF);
        controlPanel.add(tfPanel, BorderLayout.CENTER);
        
        JPanel rowPanel = new JPanel(new GridLayout(1,3));
        rowPanel.add(mAddBtn);
        rowPanel.add(mUpdateBtn);
        rowPanel.add(mDelBtn);
        
        controlPanel.add(rowPanel, BorderLayout.SOUTH);
        
        add(controlPanel, BorderLayout.SOUTH);
        
        // initialize UI
        mDelBtn.setEnabled(false);
        mUpdateBtn.setEnabled(false);

        // Add Actions to UI
        mAddBtn.addActionListener(new AbstractAction() {
            public void actionPerformed(ActionEvent e) {
                if (mNameSpaceTF.getText().length() > 0 &&
                        mLabelTF.getText().length() > 0)
                {
                    mChanged = true;
                    DocItem item = new DocItem();
                    item.mDocType = new EcogridRegEntryType_documentType();
                    item.mDocType.setLabel(mLabelTF.getText());
                    item.mDocType.setNamespace(mNameSpaceTF.getText());
                    mListModel.addElement(item);
                    mList.clearSelection();
                    mNameSpaceTF.setText("");
                    mLabelTF.setText("");
                }
        }});  
        
        mDelBtn.addActionListener(new AbstractAction() {
            public void actionPerformed(ActionEvent e) {
                if (mList.getSelectedIndex() != -1)
                {
                    mChanged = true;
                    DocItem item = (DocItem)mListModel.getElementAt(mList.getSelectedIndex());
                    item.mDocType = null;
                    mListModel.removeElementAt(mList.getSelectedIndex());
                    mList.clearSelection();
                    mNameSpaceTF.setText("");
                }
        }});  
        
        mUpdateBtn.addActionListener(new AbstractAction() {
            public void actionPerformed(ActionEvent e) {
                int inx = mList.getSelectedIndex();
                if (inx != -1)
                {
                    if (mNameSpaceTF.getText().length() > 0 &&
                        mLabelTF.getText().length() > 0)
                    {
                        mChanged = true;
                        DocItem item = (DocItem)mListModel.getElementAt(inx);
                        item.mDocType.setLabel(mLabelTF.getText());
                        item.mDocType.setNamespace(mNameSpaceTF.getText());
                        mList.clearSelection();
                        mNameSpaceTF.setText("");
                        mLabelTF.setText("");
                    }
                }
        }});        
   }
    
    /**
     * Sets a list of providers
     * @param aDocTypes
     */
    public void setDocTypes(EcogridRegEntryType_documentType[] aDocTypes)
    {
        mListModel.clear();
        if (aDocTypes != null)
        {
            for (int i=0;i<aDocTypes.length;i++)
            {
                DocItem docItem = new DocItem();
                docItem.mDocType = aDocTypes[i];
                mListModel.addElement(docItem);
            }
        }
    }
   
    /**
     * 
     * @return an array of providers
     */
    public EcogridRegEntryType_documentType[] getDocTypes()
    {
        EcogridRegEntryType_documentType[] docTypes = null;
        if (mListModel.size() > 0)
        {
            docTypes = new EcogridRegEntryType_documentType[mListModel.size()];
            int i = 0;
            for (Enumeration e=mListModel.elements();e.hasMoreElements();)
            {
                DocItem docItem = (DocItem)e.nextElement();
                docTypes[i++] = docItem.mDocType;
            }
        }
        return docTypes;
    }
    
    /**
     * 
     * @return whether the model (providers list) has changed
     */
    public boolean isChanged()
    {
        return mChanged;
    }
    
    //--------------------------------------------
    //-------- ListSelectionListener -------------
    //--------------------------------------------

    /**
     * Upates the "inspector" ui when an item in the list is clicked on
     */
    public void valueChanged(ListSelectionEvent e)
    {
      if (e == null || !e.getValueIsAdjusting())
      {
        int selectedInx = mList.getSelectedIndex();
        if (selectedInx != -1)
        {
            boolean enable = selectedInx != -1;
            mDelBtn.setEnabled(enable);
            mUpdateBtn.setEnabled(enable);
            DocItem item = (DocItem)mListModel.getElementAt(mList.getSelectedIndex());
            mNameSpaceTF.setText(item.mDocType.getNamespace());
            mLabelTF.setText(item.mDocType.getLabel());
        }
      }
    }
    
    // Helper class for overriding toString90
    class DocItem
    {
        public EcogridRegEntryType_documentType mDocType;
        
        public String toString()
        {
            return mDocType.getNamespace();
        }
        
    }
}
