package org.ecoinformatics.ecogrid.srb.impl;

import java.util.Vector;

import org.ecoinformatics.ecogrid.queryservice.stub.QueryServicePortType;
import org.ecoinformatics.ecogrid.queryservice.resultset.ResultsetType;
import org.ecoinformatics.ecogrid.queryservice.query.QueryType;

import java.rmi.RemoteException;
import edu.sdsc.grid.io.srb.*;
import edu.sdsc.grid.io.*;

import java.net.URI;
import java.net.URISyntaxException;


/**
 * The class implements ecogrid query to srb query
 */
public class SRBProxyImpl implements QueryServicePortType
{
   // public MetacatImpl()
   public SRBProxyImpl()
   {
   }

   public ResultsetType query(QueryType query) throws RemoteException
   {
       SrbEcogridQuery srbQuery=null;
       ResultsetType ResultSet = null;
       SeekXMLQueryDocSRBParser queryParser = new SeekXMLQueryDocSRBParser();
       
       try
       {
          srbQuery = queryParser.ParseQueryType(query);
       }
       catch(Exception e)
       {
          throw new RemoteException(e.getMessage());
       }

       // submit our parsed query. The return result is the size of first page.
       int qr_cnt = srbQuery.SubmitQuery();
       if(qr_cnt < 0)
       {
          String ErrMsg;
          ErrMsg = "Failed to submit a query to SRB. Error code: " + qr_cnt;
          srbQuery = null;
          throw new RemoteException(ErrMsg);
       }

       int i;
       String TmpStr;

       Vector SrbObjIdVector = new Vector();

       qr_cnt = srbQuery.GetCurrentSrhResultLength();
       while(qr_cnt > 0)
       {
          for(i=0;i<qr_cnt;i++)
          {
             // XXX TmpStr = srbQuery.CurrentSrhResultAt(i);

             // XXX SrbObjIdVector.add(TmpStr);
          }

          qr_cnt = srbQuery.GetMoreSrhResult();
       }

       if(SrbObjIdVector.size() == 0)
       {
          srbQuery = null;
          return null;
       }

       int Cnt = SrbObjIdVector.size();
       String[] SrbObjIdArray = new String[Cnt];

       for(i=0;i<Cnt;i++)
         SrbObjIdArray[i] = (String)SrbObjIdVector.elementAt(i);

       SRB2ResultsetType Srb2Resultset = new SRB2ResultsetType();
       
       /* XXX 
       try 
       {
          ResultSet = Srb2Resultset.transform(SrbObjIdArray);
       }
       catch(Exception e)
       {
          srbQuery = null;
          throw new RemoteException(e.getMessage());
       }
       */
       
       srbQuery = null;

       return ResultSet;
   }

 
  /**
   * Performs a get
   * @param identifier identifies the object to be "gotten"
   * @return returns bytes of identifier
   * @exception RemoteException
   */
  public byte[] get(String identifier) throws RemoteException
  {
    if (identifier == null)
    {
      throw new RemoteException("Please sepcify the identifier");
    }
     
    // open SRB file and return the whole string.
    // currently we only allow limited number of bytes to be transferred <= 20K
    int nBytesRead;

    nBytesRead = 1;
       
    SRBFile srbFile;
    GeneralFileSystem fileSystem = null;
    SRBRandomAccessFile srbRandomAccessFile;
    URI uri;

    byte[] retBytes;
    byte[] tmpBytes;

    int i,t,curidx;

    byte[] bytesRead = new byte[20000];

    retBytes = null;
    try
    {
          uri = new URI(identifier);
          srbFile = (SRBFile)FileFactory.newFile(uri);
          fileSystem = srbFile.getFileSystem();
          srbRandomAccessFile = new SRBRandomAccessFile(srbFile,"r" );
 
          nBytesRead = srbRandomAccessFile.read(bytesRead);

          while(nBytesRead > 0)
          {
             if(retBytes != null)
             {
                t= retBytes.length;
                tmpBytes = new byte[t];
                for(i=0;i<t;i++)
                  tmpBytes[i] = retBytes[i];

                retBytes = null;
                retBytes = new byte[t+nBytesRead];
                for(i=0;i<t;i++)
                  retBytes[i] = tmpBytes[i];

                tmpBytes = null;
                curidx = t;
             }
             else
             {
                retBytes = new byte[nBytesRead];
                curidx = 0;
             }

             for(i=0;i<nBytesRead;i++)
               retBytes[i+curidx] = bytesRead[i];

             nBytesRead = srbRandomAccessFile.read(bytesRead);
          }

          // close connection
          srbRandomAccessFile = null;
          fileSystem = null;
          srbFile = null;
          uri = null;
    }
    catch(SRBException e )
    {
          throw new RemoteException("open SRB file failed.");
    }
    catch(URISyntaxException e)
    {
          throw new RemoteException("URI exception. it might be caused by an invalid URI.");
    }
    catch(java.io.IOException e)
    {
          throw new RemoteException("openning SRB file: Java IO exception.");
    }
    //catch(java.rmi.RemoteException e)
    //{
    //   throw new RemoteException(" Java remote exception.");
    //}

    return retBytes;

  } //get

}
