package org.ecoinformatics.ecogrid.srb.impl;

import java.util.Vector;

import org.ecoinformatics.ecogrid.EcoGridErrorCode;
import org.ecoinformatics.ecogrid.EcogridUtils;

import edu.sdsc.grid.io.srb.*;
import edu.sdsc.grid.io.*;

import java.net.URI;


public class SrbEcogridQuery
{
   String srbHost, srbPort, srbUserName, srbPasswd, srbMdasDomainHome;
   String mdasCollectionHome, mdasCollectionName;

   // mdasCollectionHome --> always the home collection
   // mdasCollectionName --> cwd, serves as a starting collection for search

  // currently we have only one method.
  final static int AND_ONLY_METADATA_CONDITION = 1;

  // define the system metadata table in SRB
  String SrbSysMetadataTable[] = {
    "File name",
    "File size",
    "Creation date",
    "Modification date",
    "Owner name",
    "Collection name",
    "Replication number",
    "File type",
    "Data classification name",
    "Data classification type",
    "Access constraint",
    "Comments",
    "Comments date",
    "Deleted flag",
    "Owner domain",
    "Owner email address"
    };


  int QueryMethod;
  String QueryId;
  String QueryTitle;

  // The SRB URI include the starting collection for search.
  // Here is an example.
  //   srb://testuser.sdsc:testuser_passwd@srb.sdsc.edu:6617/home/testuser.sdsc
  String SrbURI = "";

  String SrbNameSpace;
  // This is set when Namespace is set by extracting collection info from Namespace.

  // the following specifies the field for return result.
  String[] ReturnFieldNamesWithoutUserDefined =
  {
     SRBMetaDataSet.DIRECTORY_NAME,
     SRBMetaDataSet.FILE_NAME,
     SRBMetaDataSet.FILE_REPLICATION_ENUM,
     SRBMetaDataSet.MODIFICATION_DATE,
     SRBMetaDataSet.SIZE,
     SRBMetaDataSet.OWNER,
     SRBMetaDataSet.CREATION_DATE
  };
  String[] ReturnFieldNamesWithUserDefined =
  {
     SRBMetaDataSet.DIRECTORY_NAME,
     SRBMetaDataSet.FILE_NAME,
     SRBMetaDataSet.FILE_REPLICATION_ENUM,
     SRBMetaDataSet.MODIFICATION_DATE,
     SRBMetaDataSet.SIZE,
     SRBMetaDataSet.OWNER,
     SRBMetaDataSet.CREATION_DATE,
     SRBMetaDataSet.DEFINABLE_METADATA_FOR_FILES
  };

  // store search result.
  MetaDataRecordList[] SrhReturnRecords = null;

  // for system metadata condition query
  Vector SysMetaConditionVector = null;

  // user-defined string type metadata are saved in following three vectors.
  Vector StrUserMetadataAtt = null;
  Vector StrUserMetadataAttVal = null;
  Vector StrUserMetadataOperator = null;

  // user-defined integer type metadata are saved in three vectors
  Vector IntUserMetadataAtt = null;
  Vector IntUserMetadataAttVal = null;
  Vector IntUserMetadataOperator = null;

  // constructor
  public SrbEcogridQuery(int queryMethod)
  {
     QueryMethod = queryMethod;

     QueryId = null;
     QueryTitle = null;
     SrbNameSpace = null;

     SrbURI = null;

     SysMetaConditionVector = new Vector();

     StrUserMetadataAtt = new Vector();
     StrUserMetadataAttVal = new Vector();
     StrUserMetadataOperator = new Vector();

     IntUserMetadataAtt = new Vector();
     IntUserMetadataAttVal = new Vector();
     IntUserMetadataOperator = new Vector();

     // set default values for SEEK project. should be fetched from config file.
     srbHost = "srb.sdsc.edu";
     srbPort = "7614";
     srbUserName = "testuser";
     srbPasswd = "TESTUSER";
     mdasCollectionHome = "/home/testuser.sdsc";
     srbMdasDomainHome = "sdsc";

     mdasCollectionName = "";
  }

  protected void finalize( )
  {
  }

  public void SetQueryId(String id)
  {
     QueryId = id;
  }
  public String GetQueryId()
  {
     return QueryId;
  }
  public void SetQueryTitle(String title)
  {
     QueryTitle = title;
  }
  public String GetQueryTitle()
  {
     return QueryTitle;
  }

  public void SetNamespace(String nameSpace)
  {
     SrbNameSpace = nameSpace;
  }

  private int SetSrbURI(String operator, String srbURI)
  {
     EcogridUtils.debugMessage("SetSrbURI(), operator=" + operator + ", srbURI=" + srbURI);
     SrbURI = srbURI;

     boolean set_mdasCollectionName = false;

     SRBuri objSrbURI = null;
     try
     {
         objSrbURI = new SRBuri(srbURI);
     }
     catch(Exception e)
     {
         return EcoGridErrorCode.SRB_INVALID_URI;
     }

     if(objSrbURI.getSrbHost() != null)
       srbHost = objSrbURI.getSrbHost();
     if(objSrbURI.getSrbPort() > 0)
       srbPort = Integer.toString(objSrbURI.getSrbPort());
     if(objSrbURI.getSrbUserName() != null)
       srbUserName = objSrbURI.getSrbUserName();
     if(objSrbURI.getSrbPassword() != null)
       srbPasswd = objSrbURI.getSrbPassword();
     if(objSrbURI.getSrbParentCollection() != null)
     {
        mdasCollectionHome = objSrbURI.getSrbParentCollection();
        set_mdasCollectionName = true;
     }
     if(objSrbURI.getSrbMdasDomainHome() != null)
       srbMdasDomainHome = objSrbURI.getSrbMdasDomainHome();
     // In this search case, the actual parent collection is the mdasCollectionHome + "/" + tmpSrbFilename;
     if(objSrbURI.getSrbFilename() != null)
       mdasCollectionHome = mdasCollectionHome + "/" + objSrbURI.getSrbFilename();

     if(set_mdasCollectionName == true)
     {
        if((mdasCollectionName==null)||(mdasCollectionName.length() <= 0))
          mdasCollectionName = mdasCollectionHome;
     }

     return 0;
  }

  public void PrintUserInfo()
  {
     EcogridUtils.debugMessage("srbHost=" + srbHost);
     EcogridUtils.debugMessage("srbPort=" + srbPort);
     EcogridUtils.debugMessage("srbUserName=" + srbUserName);
     EcogridUtils.debugMessage("srbPasswd=" + srbPasswd);
     EcogridUtils.debugMessage("mdasCollectionHome=" + mdasCollectionHome);
     EcogridUtils.debugMessage("srbMdasDomainHome=" + srbMdasDomainHome);
     EcogridUtils.debugMessage("mdasCollectionName=" + mdasCollectionName);
  }

  public String GetNamespace()
  {
     return SrbNameSpace;
  }

  public String GetSrbURI()
  {
     return SrbURI;
  }

  int OperatorConversion(String operator)
  {
     if(operator.equalsIgnoreCase("LIKE"))
     {
        return MetaDataCondition.LIKE;
     }
     else if(operator.equalsIgnoreCase("NOT LIKE"))
     {
        return MetaDataCondition.NOT_LIKE;
     }
     else if(operator.equalsIgnoreCase("EQUALS"))
     {
        return MetaDataCondition.EQUAL;
     }
     else if(operator.equalsIgnoreCase("NOT EQUALS"))
     {
        return MetaDataCondition.NOT_EQUAL;
     }
     else if(operator.equalsIgnoreCase("LESS THAN"))
     {
        return MetaDataCondition.LESS_THAN;
     }
     else if(operator.equalsIgnoreCase("LESS THAN OR EQUALS"))
     {
        return MetaDataCondition.LESS_OR_EQUAL;
     }
     else if(operator.equalsIgnoreCase("GREATER THAN"))
     {
        return MetaDataCondition.GREATER_THAN;
     }
     else if(operator.equalsIgnoreCase("GREATER THAN OR EQUALS"))
     {
        return MetaDataCondition.GREATER_OR_EQUAL;
     }

     return EcoGridErrorCode.INVALID_CONDITION_OP;  // meaning the operator is not supported.
  }

  boolean IsSystemMetadata(String dataField)
  {

     for(int i=0; i<SrbSysMetadataTable.length;i++)
     {
        if(dataField.equalsIgnoreCase(SrbSysMetadataTable[i]))
          return true;
     }

     return false;
  }

  public void CheckTopLevelSearchCollection()
  {
     if((mdasCollectionName==null)||(mdasCollectionName.length() <= 0))
       mdasCollectionName = "/home%";
  }

  boolean IsTopLevelCollectionField(String datafield)
  {
     if(datafield.compareToIgnoreCase("srbCollectionName") == 0)
       return true;

     if(datafield.compareToIgnoreCase("mdasCollectionName") == 0)
       return true;

     return false;
  }

  // check traditional SRB env variables except 'mdasCollectionName' which is taken care of by above code.
  private boolean IsTraditinalEnvironmentVariable(String datafield, String dataVal)
  {
     if(datafield.compareToIgnoreCase("srbHost") == 0)
     {
        srbHost = dataVal;
        return true;
     }
     else if(datafield.compareToIgnoreCase("srbPort") == 0)
     {
        srbPort = dataVal;
        return true;
     }
     else if(datafield.compareToIgnoreCase("srbUsr") == 0)
     {
        srbUserName = dataVal;
        return true;
     }
     else if(datafield.compareToIgnoreCase("srbAuth") == 0)
     {
        srbPasswd = dataVal;
        return true;
     }
     else if(datafield.compareToIgnoreCase("mdasDomainName") == 0)
     {
        srbMdasDomainHome = dataVal;
        return true;
     }
     else if(datafield.compareToIgnoreCase("mdasDomainHome") == 0)
     {
        srbMdasDomainHome = dataVal;
        return true;
     }
     else if(datafield.compareToIgnoreCase("mdasCollectionHome") == 0)
     {
        mdasCollectionHome = dataVal;
        return true;
     }

     return false;
  }

  public int AddCondition(String dataField, String operator, String attValue)
  {
     int opcode = OperatorConversion(operator);
     MetaDataCondition NewCondition;

     if(dataField.compareToIgnoreCase("srbURI") == 0)
     {
        return SetSrbURI(operator,attValue);
     }

     if(IsTopLevelCollectionField(dataField))    // mdasCollectionName
     {
        mdasCollectionName = attValue;

        // if the recursive or non-recursive search
        if(operator.compareToIgnoreCase("LIKE") == 0)
        {
           int t = attValue.length();

           if(mdasCollectionName.charAt(t-1) != '%')
             mdasCollectionName = mdasCollectionName + "%";
        }
        else if(operator.compareToIgnoreCase("EQUALS") != 0)  // the operator must be either 'LIKE' or 'EQUALS'.
        {
           return EcoGridErrorCode.INVALID_CONDITION_OP;
        }

        return 0;
     }

     // support other traditional SRB env variables
     if(IsTraditinalEnvironmentVariable(dataField,attValue))
       return 0;

     if(IsSystemMetadata(dataField) == true)
     {
        EcogridUtils.debugMessage("SrbEcogridQuery(): dataField=" + dataField + "opcode=" + opcode + "attValue=" + attValue);
        NewCondition = MetaDataSet.newCondition(dataField,opcode,attValue);
        EcogridUtils.debugMessage("SrbEcogridQuery(): after MetaDataSet.newCondition()");
        SysMetaConditionVector.add(NewCondition);
     }
     else
     {
        StrUserMetadataAtt.add(dataField);
        StrUserMetadataAttVal.add(attValue);

        Integer NewInteger = new Integer(opcode);
        StrUserMetadataOperator.add(NewInteger);
     }

     return 0;
  }

  public int AddCondition(String dataField, String operator,int attValue)
  {
     int opcode = OperatorConversion(operator);

     if(IsSystemMetadata(dataField) == true)
     {
        MetaDataCondition NewCondition = MetaDataSet.newCondition(dataField,opcode,attValue);
        SysMetaConditionVector.add(NewCondition);
     }

     return 0;
  }

  int MetadataExecuteConditionQuery()
  {
     // establish SRB connnection and submit the query
     ///// need to check the return result.

     if(SrhReturnRecords != null)
       SrhReturnRecords = null;

     int Cnt;
     int i;
     int ConditionCnt;

     //BBB need to add for Int type user-defined metdata search
     // Cnt = SysMetaConditionVector.size() + StrUserMetadataAtt.size() + IntUserMetadataAtt.size();

     // 1 is for user-defined metada which only needs one condition combined with a table.
     if(StrUserMetadataAtt.size() > 0)
       Cnt = SysMetaConditionVector.size() + 1;
     else
       Cnt = SysMetaConditionVector.size();

     if(Cnt == 0)
       return 0;

     Cnt++;

     MetaDataCondition[] MyConditions;
     MyConditions = new MetaDataCondition[Cnt];

     // get the default values for user info. Here we allow anonymous search by using testuser account.
     if(srbHost.length()==0)
       srbHost = "srb.sdsc.edu";
     if(srbPort.length()==0)
       srbPort = "7614";

     if((srbUserName.length()==0)&&(srbPasswd.length()==0))
     {
        srbUserName = "testuser";
        srbPasswd = "TESTUSER";
        srbMdasDomainHome = "sdsc";
        mdasCollectionHome = "/home/testuser.sdsc";
     }

     ConditionCnt = 0;

     int t;
     int k = mdasCollectionName.length();
     if(mdasCollectionName.charAt(k-1)  == '%')
       t = MetaDataCondition.LIKE;
     else
       t = MetaDataCondition.EQUAL;
     MyConditions[ConditionCnt++] = MetaDataSet.newCondition( SRBMetaDataSet.DIRECTORY_NAME,
                                       t,mdasCollectionName);

     for(i=0;i<SysMetaConditionVector.size();i++)
       MyConditions[ConditionCnt++] = (MetaDataCondition)SysMetaConditionVector.elementAt(i);

     MetaDataSelect[] SelectedFields = null;

     // build the condition for user-defined metada
     int StrUMCnt = StrUserMetadataAtt.size();
     if(StrUMCnt > 0)
     {
        String[][] UdMdObjects = new String[StrUMCnt][2];

        int[] UdMdOperators = new int[StrUMCnt];

        for(i=0;i<StrUMCnt;i++)
        {
          UdMdObjects[i][0] = (String)StrUserMetadataAtt.elementAt(i);
          UdMdObjects[i][1] = (String)StrUserMetadataAttVal.elementAt(i);
          Integer NewInteger = (Integer)StrUserMetadataOperator.elementAt(i);
          UdMdOperators[i] = NewInteger.intValue();
        }

        MetaDataTable UdMdTable = new MetaDataTable(UdMdOperators,UdMdObjects);

        MetaDataCondition UdMdCondition = MetaDataSet.newCondition(SRBMetaDataSet.DEFINABLE_METADATA_FOR_FILES,UdMdTable);
        MyConditions[ConditionCnt++] = UdMdCondition;

        SelectedFields = MetaDataSet.newSelection(ReturnFieldNamesWithUserDefined);
     }
     else
     {
        SelectedFields = MetaDataSet.newSelection(ReturnFieldNamesWithoutUserDefined);
     }

     SRBAccount srbAccount = null;
     SRBFileSystem srbFileSystem = null;

     // establish SRB connection.
     try
     {
        srbAccount = new SRBAccount(srbHost, Integer.parseInt(srbPort), srbUserName, srbPasswd,
                              mdasCollectionHome, srbMdasDomainHome, "unix-sdsc");

        srbFileSystem = new SRBFileSystem( srbAccount );
     }
     catch(Exception e)
     {
        return EcoGridErrorCode.SRB_CANNOT_SET_CONNECTION;
     }

     try
     {
        // in submitting query to SRB, we set the page size to 400.
        SrhReturnRecords = srbFileSystem.query( MyConditions, SelectedFields, 400 );
     }
     catch ( Throwable e )
     {
        return EcoGridErrorCode.SRB_SUBMIT_QUERY_FAILED;
     }

     srbFileSystem = null;
     srbAccount = null;

     if(SrhReturnRecords == null)    // nothing has been found for the match condition.
       return 0;

     return SrhReturnRecords.length;
  }

  public int GetCurrentSrhResultLength()
  {
     if(SrhReturnRecords == null)
       return 0;

     return SrhReturnRecords.length;
  }

  public MetaDataRecordList CurrentSrhResultAt(int i)
  {
/*
     int j;
     String FldStr;
     String CollName,DatasetName,ReplNum;
     String SrbObjId;

     CollName = "";
     DatasetName = "";
     ReplNum = "";
     for(j=0;j<SrhReturnRecords[i].getRecordCount();j++)
     {
        FldStr = SrhReturnRecords[i].getFieldName(j);

        if(FldStr.equalsIgnoreCase(SRBMetaDataSet.DIRECTORY_NAME))
          CollName = SrhReturnRecords[i].getStringValue(j);
        else if(FldStr.equalsIgnoreCase(SRBMetaDataSet.FILE_NAME))
          DatasetName = SrhReturnRecords[i].getStringValue(j);
        else if(FldStr.equalsIgnoreCase(SRBMetaDataSet.FILE_REPLICATION_ENUM))
          ReplNum = SrhReturnRecords[i].getStringValue(j);
     }

     SrbObjId = CollName + "/" + DatasetName + "::" + ReplNum;

     return SrbObjId;
*/
     return SrhReturnRecords[i];
  }

  public int GetMoreSrhResult()
  {
     int t;

     if(SrhReturnRecords == null)
       return 0;

     if(SrhReturnRecords[0].isQueryComplete())
     {
        t = 0;
     }
     else
     {
        try
        {
           SrhReturnRecords = SrhReturnRecords[0].getMoreResults();
           t = SrhReturnRecords.length;
        }
        catch ( Throwable e )
        {
           return EcoGridErrorCode.GET_MORE_RESULTS_FAILED;
        }
     }

     return t;
  }

  public void PrepareNewQuery()
  {
     SysMetaConditionVector.removeAllElements();

     StrUserMetadataAtt.removeAllElements();
     StrUserMetadataAttVal.removeAllElements();
     StrUserMetadataOperator.removeAllElements();

     IntUserMetadataAtt.removeAllElements();
     IntUserMetadataAttVal.removeAllElements();
     IntUserMetadataOperator.removeAllElements();
  }

  public int SubmitQuery()
  {
     if(QueryMethod == AND_ONLY_METADATA_CONDITION)
       return MetadataExecuteConditionQuery();

     return 0;
  }
}
