/**
 *  '$RCSfile: AuthenticatedQueryServiceClientTest.java,v $'
 *  Copyright: 2004 Regents of the University of California and the
 *              National Center for Ecological Analysis and Synthesis
 *
 *   '$Author: leinfelder $'
 *     '$Date: 2008-10-31 18:33:23 $'
 * '$Revision: 1.5 $'
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 */

package org.ecoinformatics.ecogrid.client;

import java.io.File;
import java.io.FileReader;
import java.util.Calendar;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.SimpleTimeZone;
import java.util.TimeZone;

import junit.framework.Test;
import junit.framework.TestCase;
import junit.framework.TestSuite;

import org.ecoinformatics.ecogrid.EcogridObjType;
import org.ecoinformatics.ecogrid.authenticatedqueryservice.AuthenticatedQueryServiceClient;
import org.ecoinformatics.ecogrid.queryservice.resultset.ResultsetType;
import org.ecoinformatics.ecogrid.queryservice.util.EcogridResultsetTransformer;

/**
 * A JUnit test for testing the AuthenticatedQueryServiceClient
 */
public class AuthenticatedQueryServiceClientTest extends TestCase {
	private String username = "uid=test,o=NCEAS,dc=ecoinformatics,dc=org";
	private String password = "test";
	private String authenURL = "http://dev.nceas.ucsb.edu/knb/services/AuthenticationService";// "@baseURL@/@authen.service.name@";
	private String queryURL = "http://dev.nceas.ucsb.edu/knb/services/AuthenticatedQueryService";// "@baseURL@/@service.name@";
	private String putURL = "http://dev.nceas.ucsb.edu/knb/services/PutService";
	private String sessionId = null;
	private String queryFileName = "tests/testfiles/query-test-2.1.0.xml";
	private String prefix        = "test";
	private String metadataFileName = "tests/testfiles/eml-non-public-readable-sample-2.1.0.xml";
	private String metadataDocId = null;
	private static final String TITLE = "Cedar Creek LTER";

	/**
	 * Constructor to build the test
	 * 
	 * @param name
	 *            the name of the test method
	 */
	public AuthenticatedQueryServiceClientTest(String name) {
		super(name);
	}

	/**
	 * Establish a testing framework by initializing appropriate objects
	 */
	public void setUp() {
//		insert a public readable eml
		loginSuccess();
		try {
			// create a client object
			PutServiceClient client = new PutServiceClient(putURL);
			metadataDocId = generateDocid() + ".1";
			int objType = EcogridObjType.METADATA;
			System.err.println("doicd is " + metadataDocId);
			System.err.println("session id is " + sessionId);
			client.put(metadataFileName, metadataDocId, objType, sessionId);
			System.err.println("successfully insert metadata " + metadataDocId);
			System.err.println("successfully read the same metadata "
					+ metadataDocId);
			assertTrue(1 == 1);
		} catch (Exception e) {
			fail("put and get excepiton:\n" + e.getMessage());
		}
		logout();

	}

	/**
	 * Release any objects after tests are complete
	 */
	public void tearDown() {
	}

	/**
	 * Create a suite of tests to be run together
	 */
	public static Test suite() {
		TestSuite suite = new TestSuite();
		suite.addTest(new AuthenticatedQueryServiceClientTest("initialize"));
		suite.addTest(new AuthenticatedQueryServiceClientTest("query"));
		return suite;
	}

	/**
	 * Run an initial test that always passes to check that the test harness is
	 * working.
	 */
	public void initialize() {
		assertTrue(1 == 1);
	}

	/**
	 * Method to test login success method
	 */
	public void loginSuccess() {
		try {
			// create a client object
			AuthenticationServiceClient client = new AuthenticationServiceClient(
					authenURL);
			sessionId = client.login_action(username, password);
			assertFalse(sessionId.equals("an unknown error"));
		} catch (Exception e) {
			e.printStackTrace();
			fail("Authentication exception:\n" + e.getMessage());
		}
	}// login

	/**
	 * Method to test logout method
	 */
	public void logout() {
		try {
			// create a client object
			AuthenticationServiceClient client = 
				new AuthenticationServiceClient(authenURL);
			client.logout_action(sessionId);
			assertTrue(1 == 1);
		} catch (Exception e) {
			e.printStackTrace();
			fail("Authentication exception:\n" + e.getMessage());
		}

	}

	public void query() {
		try {
			//login
			loginSuccess();
			// create a client object
			System.err.println("authenticated query url is " + queryURL);
			System.err.println("sessionId is " + sessionId);
			AuthenticatedQueryServiceClient client = 
				new AuthenticatedQueryServiceClient(queryURL);
			// call query service
			// read query xml file
			File queryXMLFile = new File(queryFileName);
			FileReader xmlReader = new FileReader(queryXMLFile);
			
			//sleep for a while to let the index be recreated?
			Thread.sleep(3000);
			
			ResultsetType result = 
				client.query(
						AuthenticatedQueryServiceClient.reader2QueryType(xmlReader), 
						sessionId);
			// print out the result set
			String resultXML = EcogridResultsetTransformer.toXMLString(result);
			System.err.println("" + resultXML);
			//assertTrue(1 == 1);
			assertTrue("Don't contain the title of doc, which we just inserted ", resultXML.indexOf(TITLE)!= -1);
			assertTrue("Don't contains the docid, which we just inserted", resultXML.indexOf(metadataDocId)!= -1);
		} catch (Exception e) {
			e.printStackTrace();
			fail("Failed to query:\n" + e.getMessage());
		}

	}
    
	/**
	 * Create a hopefully unique docid for testing insert and update. Does not
	 * include the 'revision' part of the id.
	 * 
	 * @return a String docid based on the current date and time
	 */
	private String generateDocid() {
		StringBuffer docid = new StringBuffer(prefix);
		docid.append(".");

		// Create a calendar to get the date formatted properly
		String[] ids = TimeZone.getAvailableIDs(-8 * 60 * 60 * 1000);
		SimpleTimeZone pdt = new SimpleTimeZone(-8 * 60 * 60 * 1000, ids[0]);
		pdt
				.setStartRule(Calendar.APRIL, 1, Calendar.SUNDAY,
						2 * 60 * 60 * 1000);
		pdt.setEndRule(Calendar.OCTOBER, -1, Calendar.SUNDAY,
				2 * 60 * 60 * 1000);
		Calendar calendar = new GregorianCalendar(pdt);
		Date trialTime = new Date();
		calendar.setTime(trialTime);
		docid.append(calendar.get(Calendar.YEAR));
		docid.append(calendar.get(Calendar.DAY_OF_YEAR));
		docid.append(calendar.get(Calendar.HOUR_OF_DAY));
		docid.append(calendar.get(Calendar.MINUTE));
		docid.append(calendar.get(Calendar.SECOND));

		return docid.toString();
	}
}
