/**
 *  '$RCSfile: QueryServiceGetToStreamClientTest.java,v $'
 *  Copyright: 2004 Regents of the University of California and the
 *              National Center for Ecological Analysis and Synthesis
 *
 *   '$Author: leinfelder $'
 *     '$Date: 2008-10-31 18:33:23 $'
 * '$Revision: 1.4 $'
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 */

package org.ecoinformatics.ecogrid.client;

import java.io.ByteArrayOutputStream;
import java.io.FileInputStream;
import java.net.URL;
import java.util.Calendar;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.SimpleTimeZone;
import java.util.TimeZone;

import junit.framework.Test;
import junit.framework.TestCase;
import junit.framework.TestSuite;

import org.ecoinformatics.ecogrid.EcogridObjType;
import org.ecoinformatics.ecogrid.queryservice.QueryServiceGetToStreamClient;

/**
 * A JUnit test for testing the service client
 */
public class QueryServiceGetToStreamClientTest extends TestCase {
	private String username = "uid=test,o=NCEAS,dc=ecoinformatics,dc=org";
	private String password = "test";
	private String prefix = "test";
	private String authenURL = "http://dev.nceas.ucsb.edu/knb/services/AuthenticationService";
	private String putURL = "http://dev.nceas.ucsb.edu/knb/services/PutService";
	private String queryURL = "http://dev.nceas.ucsb.edu/knb/services/QueryService";
	private String sessionId = null;
	private String metadataFileName = "tests/testfiles/eml-sample-2.1.0.xml";//eml-non-public-readable-sample.xml
	private String privateMetadataFileName = "tests/testfiles/eml-non-public-readable-sample-2.1.0.xml";
	private String dataFileName = "tests/testfiles/dataset.txt";
	private String publicMetadataDocId = "";
	private String privateMetadataDocId = "";
	private String dataDocId = "";
	private static final String TITLE = "Cedar Creek LTER";

	/**
	 * Constructor to build the test
	 * 
	 * @param name
	 *            the name of the test method
	 */
	public QueryServiceGetToStreamClientTest(String name) {
		super(name);
	}

	/**
	 * Establish a testing framework by initializing appropriate objects
	 */
	public void setUp() {
	}

	/**
	 * Release any objects after tests are complete
	 */
	public void tearDown() {
	}

	/**
	 * Create a suite of tests to be run together
	 */
	public static Test suite() {
		TestSuite suite = new TestSuite();
		suite.addTest(new QueryServiceGetToStreamClientTest("initialize"));

		suite.addTest(new QueryServiceGetToStreamClientTest("getPublicMetadata"));
		suite.addTest(new QueryServiceGetToStreamClientTest("getPrivateMetadata"));
		suite.addTest(new QueryServiceGetToStreamClientTest("getData"));

		return suite;
	}

	/**
	 * Run an initial test that always passes to check that the test harness is
	 * working.
	 */
	public void initialize() {
		assertTrue(1 == 1);
	}

	/**
	 * Method to test login success method
	 */
	public void loginSuccess() {
		try {
			// create a client object
			AuthenticationServiceClient client = new AuthenticationServiceClient(
					authenURL);
			sessionId = client.login_action(username, password);
			assertFalse(sessionId.equals("an unknown error"));
		} catch (Exception e) {
			fail("Authentication exception:\n" + e.getMessage());
		}
	}// login

	/**
	 * Method to test logout method
	 */
	public void logout() {
		try {
			// create a client object
			AuthenticationServiceClient client = new AuthenticationServiceClient(
					authenURL);
			client.logout_action(sessionId);
			assertTrue(1 == 1);
		} catch (Exception e) {
			fail("Authentication exception:\n" + e.getMessage());
		}

	}

	public void getPublicMetadata() {
		loginSuccess();
		try {
			loginSuccess();
			
			System.out.println("setting up test with document");
			// create a client object
			PutServiceClient client = new PutServiceClient(putURL);
			
			//put the public doc
			publicMetadataDocId = generateDocid() + ".1";
			int objType = EcogridObjType.METADATA;
			System.err.println("doicd is " + publicMetadataDocId);
			System.err.println("session id is " + sessionId);
			client.put(metadataFileName, publicMetadataDocId, objType, sessionId);
			System.err.println("successfully insert public metadata " + publicMetadataDocId);
			
			logout();
			
			//try to read it
			byte[] bytes = readMetadata(publicMetadataDocId);
			System.err.println("successfully read the same metadata "
					+ publicMetadataDocId);
			String metadata = new String(bytes);
			System.err.println("successfully read the same metadata "
					+ metadata);
			assertTrue("the read document doesn't have correct title", metadata.indexOf(TITLE) != -1);
			//assertTrue(bytes.length > 0);
		} catch (Exception e) {
			e.printStackTrace();
			fail("get public excepiton:\n" + e.getMessage());
		}
	}
	
	public void getPrivateMetadata() {
		try {
			
			loginSuccess();
			
			System.out.println("setting up test with document");
			// create a client object
			PutServiceClient client = new PutServiceClient(putURL);
			
			//private doc
			privateMetadataDocId = generateDocid() + ".1";
			int objType = EcogridObjType.METADATA;
			System.err.println("doicd is " + privateMetadataDocId);
			System.err.println("session id is " + sessionId);
			client.put(privateMetadataFileName, privateMetadataDocId, objType, sessionId);
			System.err.println("successfully insert private metadata " + privateMetadataDocId);
			
			logout();
			
			byte[] bytes = readMetadata(privateMetadataDocId);
			
			System.err.println(
					"read the private metadata " + privateMetadataDocId);
			assertNull(bytes);
			
		} catch (Exception e) {
			fail("get excepiton:\n" + e.getMessage());
		}
	}
	
	public void getData() {
		try {
			
			loginSuccess();
			
			System.out.println("setting up test with document");
			// create a client object
			PutServiceClient client = new PutServiceClient(putURL);
			
			dataDocId = generateDocid() + ".1";
			int objType = EcogridObjType.DATA;
			System.err.println("doicd is " + dataDocId);
			System.err.println("session id is " + sessionId);
			client.put(dataFileName, dataDocId, objType, sessionId);
			System.err.println("successfully insert data " + dataDocId);
	
			logout();
			
			byte[] bytes = readMetadata(dataDocId);
			System.err.println("read the data " + dataDocId);
			
			assertNull(bytes);
			
		} catch (Exception e) {
			fail("get data excepiton:\n" + e.getMessage());
		}
	}

	private byte[] readMetadata(String id) {

		try {
			// create a client object
			URL GSH = new URL(queryURL);
			QueryServiceGetToStreamClient client = 
				new QueryServiceGetToStreamClient(GSH);
			ByteArrayOutputStream bytes = new ByteArrayOutputStream();
			client.get(id, bytes);
			// view it if we want
			//client.get(id, System.out);
			
			return bytes.toByteArray();

		} catch (Exception e) {
			e.printStackTrace();
			//fail("Failed to get doc:\n" + e.getMessage());
		}
		return null;

	}

	/**
	 * Create a hopefully unique docid for testing insert and update. Does not
	 * include the 'revision' part of the id.
	 * 
	 * @return a String docid based on the current date and time
	 */
	private String generateDocid() {
		StringBuffer docid = new StringBuffer(prefix);
		docid.append(".");

		// Create a calendar to get the date formatted properly
		String[] ids = TimeZone.getAvailableIDs(-8 * 60 * 60 * 1000);
		SimpleTimeZone pdt = new SimpleTimeZone(-8 * 60 * 60 * 1000, ids[0]);
		pdt
				.setStartRule(Calendar.APRIL, 1, Calendar.SUNDAY,
						2 * 60 * 60 * 1000);
		pdt.setEndRule(Calendar.OCTOBER, -1, Calendar.SUNDAY,
				2 * 60 * 60 * 1000);
		Calendar calendar = new GregorianCalendar(pdt);
		Date trialTime = new Date();
		calendar.setTime(trialTime);
		docid.append(calendar.get(Calendar.YEAR));
		docid.append(calendar.get(Calendar.DAY_OF_YEAR));
		docid.append(calendar.get(Calendar.HOUR_OF_DAY));
		docid.append(calendar.get(Calendar.MINUTE));
		docid.append(calendar.get(Calendar.SECOND));

		return docid.toString();
	}

	

}
