/**
 *  '$RCSfile: EcoGridFTPTransferTest.java,v $'
 *  Copyright: 2003 Regents of the University of California and the
 *              National Center for Ecological Analysis and Synthesis
 *  Purpose: To test the MetaCatURL class by JUnit
 *
 *   '$Author: rspears $'
 *     '$Date: 2004-02-04 15:28:44 $'
 * '$Revision: 1.1 $'
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 */

package org.ecoinformatics.ecogrid.ecogridtest;

import org.apache.axis.types.URI;

import org.ecoinformatics.ecogrid.EcoGridFTPTransfer;

import org.globus.gsi.GlobusCredential;
import org.globus.gsi.gssapi.GlobusGSSCredentialImpl;
import org.globus.gsi.jaas.JaasGssUtil;
import org.globus.ogsa.impl.ogsi.GridServiceImpl;
import org.globus.ogsa.impl.security.SecurityManager;
import org.gridforum.jgss.ExtendedGSSManager;

import org.ietf.jgss.GSSCredential;

import junit.framework.Test;
import junit.framework.TestCase;
import junit.framework.TestResult;
import junit.framework.TestSuite;

/**
 * A JUnit test for testing Step class processing
 */
public class EcoGridFTPTransferTest extends TestCase
{
    private static String SOURCEURIINSERVERTOCLIENT = 
                              "gsiftp://pine.nceas.ucsb.edu:5678/tmp/source";
    private static String DESTURIINSERVERTOCLIENT = 
                              "file:///tmp/servertoclient";
    private static String SOURCEURIINCLIENTTOSERVER = "file:///tmp/source";
    private static String DESTURIINCLIENTTOSERVER = 
                         "gsiftp://pine.nceas.ucsb.edu:5678/tmp/clienttoserver";
    private static String SOURCEURIINTHIRDPARTY = 
                              "gsiftp://pine.nceas.ucsb.edu:5678/tmp/source";
    private static String DESTURIINTHIRDPARTY = 
                             "gsiftp://pine.nceas.ucsb.edu:5678/tmp/thirdparty";
                              
    /**
     * Constructor to build the test
     *
     * @param name the name of the test method
     */
    public EcoGridFTPTransferTest(String name)
    {
        super(name);
    }

    /**
     * Establish a testing framework by initializing appropriate objects
     */
    public void setUp()
    {
        
    }
  
    /**
     * Release any objects after tests are complete
     */
    public void tearDown()
    {
    }
  
    /**
     * Create a suite of tests to be run together
     */
    public static Test suite()
    {
        TestSuite suite = new TestSuite();
        suite.addTest(new EcoGridFTPTransferTest("initialize"));
        suite.addTest(new EcoGridFTPTransferTest("serverToClient"));
        suite.addTest(new EcoGridFTPTransferTest("clientToServer"));
        suite.addTest(new EcoGridFTPTransferTest("thirdParty"));
        return suite;
    }
  
    /**
     * Run an initial test that always passes to check that the test
     * harness is working.
     */
    public void initialize()
    {
        assertTrue(1 == 1);
    }
   
   /**
    * Run an test for server to client
    */
   public void serverToClient() throws Exception
   {
     try
     {
       // create the source and dest URI
       URI sourceURI = new URI(SOURCEURIINSERVERTOCLIENT);
       URI destURI   = new URI(DESTURIINSERVERTOCLIENT);
       // create the credential
       GSSCredential cred = createCredential();
       EcoGridFTPTransfer server = 
                               new EcoGridFTPTransfer(sourceURI, destURI, cred);
       int flag = server.transfer();
       assertTrue(flag == 1);
     }
     catch (Exception e)
     {
       System.out.println("The exception in serverToClient is " + 
                          e.getMessage());
       throw e;
     }
   }
   
   /**
    * Run an test for client to server
    */
   public void clientToServer() throws Exception
   {
     try
     {
       // create the source and dest URI
       URI sourceURI = new URI(SOURCEURIINCLIENTTOSERVER);
       URI destURI   = new URI(DESTURIINCLIENTTOSERVER);
       // create the credential
       GSSCredential cred = createCredential();
       EcoGridFTPTransfer server = 
                               new EcoGridFTPTransfer(sourceURI, destURI, cred);
       int flag = server.transfer();
       assertTrue(flag == 1);
     }
     catch (Exception e)
     {
       System.out.println("The exception in serverToClient is " + 
                          e.getMessage());
       throw e;
     }
   }
   
   /**
    * Run an test for thirdParty
    */
   public void thirdParty() throws Exception
   {
     try
     {
       // create the source and dest URI
       URI sourceURI = new URI(SOURCEURIINTHIRDPARTY);
       URI destURI   = new URI(DESTURIINTHIRDPARTY);
       // create the credential
       GSSCredential cred = createCredential();
       EcoGridFTPTransfer server = 
                               new EcoGridFTPTransfer(sourceURI, destURI, cred);
       int flag = server.transfer();
       assertTrue(flag == 1);
     }
     catch (Exception e)
     {
       System.out.println("The exception in serverToClient is " + 
                          e.getMessage());
       throw e;
     }
   }
  
  
  
  
  /*
   * Method to get default credential
   */
  private GSSCredential createCredential() throws Exception
  {
    GSSCredential cred = null;
    try
    {
      System.out.println("before create manager");
      ExtendedGSSManager manager = 
                      (ExtendedGSSManager)ExtendedGSSManager.getInstance();
      System.out.println("after create manager");
      System.out.println("before create cred");
      cred = manager.createCredential(GSSCredential.INITIATE_AND_ACCEPT);
      System.out.println("after create cred");
    }
    catch (Exception e)
    {
      System.out.println("exceptin e" + e.getMessage());
      throw e;
    }
    return cred;
  }
  
  
}
