/* TreeToString actor gets the whole description of a tree and 
   transforms it into a string.

 Copyright (c) 1998-2003 The Regents of the University of California.
 All rights reserved.
 Permission is hereby granted, without written agreement and without
 license or royalty fees, to use, copy, modify, and distribute this
 software and its documentation for any purpose, provided that the above
 copyright notice and the following two paragraphs appear in all copies
 of this software.

 IN NO EVENT SHALL THE UNIVERSITY OF CALIFORNIA BE LIABLE TO ANY PARTY
 FOR DIRECT, INDIRECT, SPECIAL, INCIDENTAL, OR CONSEQUENTIAL DAMAGES
 ARISING OUT OF THE USE OF THIS SOFTWARE AND ITS DOCUMENTATION, EVEN IF
 THE UNIVERSITY OF CALIFORNIA HAS BEEN ADVISED OF THE POSSIBILITY OF
 SUCH DAMAGE.

 THE UNIVERSITY OF CALIFORNIA SPECIFICALLY DISCLAIMS ANY WARRANTIES,
 INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES OF
 MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE. THE SOFTWARE
 PROVIDED HEREUNDER IS ON AN "AS IS" BASIS, AND THE UNIVERSITY OF
 CALIFORNIA HAS NO OBLIGATION TO PROVIDE MAINTENANCE, SUPPORT, UPDATES,
 ENHANCEMENTS, OR MODIFICATIONS.

                                        PT_COPYRIGHT_VERSION_2
                                        COPYRIGHTENDKEY
*/

package org.cipres.kepler;

import ptolemy.actor.TypedAtomicActor;
import ptolemy.kernel.CompositeEntity;
import ptolemy.kernel.util.*;
import ptolemy.actor.IOPort;
import ptolemy.actor.TypedIOPort;
import ptolemy.data.Token;
import ptolemy.data.ObjectToken;
import ptolemy.data.StringToken;
import ptolemy.data.type.BaseType;
import ptolemy.data.type.Type;
import ptolemy.data.expr.Parameter;

import org.cipres.CipresIDL.Tree;
import org.cipres.datatypes.TreeWrapper;


//////////////////////////////////////////////////////////////////////////
//// TreeToString
/**
 * This is the implementation of the TreeToString actor using Kepler.
 * This actor gets the whole description of a tree (including tree name, 
 tree score, leaf set, and Newick) and transforms it into a string.
 * 
 * @author Zhijie Guan  
 * guan@sdsc.edu
*/

public class TreeToString extends TypedAtomicActor {

	/** Construct TreeToString source with the given container and name.
     *  @param name The name of this actor.
     *  @exception IllegalActionException If the entity cannot be contained
     *   by the proposed container.
     *  @exception NameDuplicationException If the container already has an
     *   actor with this name.
     */
	
    public TreeToString(CompositeEntity container, String name)
            throws NameDuplicationException, IllegalActionException  {
        super(container, name);
        
		inputTree = new TypedIOPort(this, "Tree", true, false);
		inputTree.setTypeEquals(BaseType.GENERAL);
		
        outputString = new TypedIOPort(this, "String", false, true);
        // Set the type constraint.
        outputString.setTypeEquals(BaseType.GENERAL);

        _attachText("_iconDescription", "<svg>\n" +
                "<rect x=\"0\" y=\"0\" "
                + "width=\"60\" height=\"20\" "
                + "style=\"fill:white\"/>\n" +
                "</svg>\n");
		
    }

    ///////////////////////////////////////////////////////////////////
    ////                     ports and parameters                  ////

	public TypedIOPort inputTree = null;
    public TypedIOPort outputString = null;
	
	///////////////////////////////////////////////////////////////////
	////                    functional variables                   ////

	
    ///////////////////////////////////////////////////////////////////
    ////                         public methods                    ////

    /** Send the whole description of a tree to the output port as a string.
     *  @exception IllegalActionException If it is thrown by the
     *   send() method sending out the token.
     */
    public void fire() throws IllegalActionException {
        super.fire();
		
		if (inputTree.hasToken(0)) {
			outputString.send(0, new StringToken( TreeWrapper.asString((Tree)((ObjectToken)inputTree.get(0)).getValue()) ) );
		}
		
    }
}

