package org.ecoinformatics.seek.datasource.eml.eml2;

import java.sql.SQLException;
import java.util.Collection;
import java.util.Collections;
import java.util.Vector;

import org.kepler.objectmanager.data.db.DSTableFieldIFace;

import ptolemy.actor.TypedIOPort;
import ptolemy.data.ArrayToken;
import ptolemy.data.RecordToken;
import ptolemy.data.Token;
import ptolemy.data.type.ArrayType;
import ptolemy.data.type.RecordType;
import ptolemy.kernel.util.IllegalActionException;

class Eml200DataOutputFormatColumnRecord extends Eml200DataOutputFormatColumnVector {

	private RecordToken _recordToken          = null;
	
	private static final String RECORDPORTNAME         = "Record";
	private RecordType recordType;
	
	private boolean isFired = false;
	
	private static Collection portList;
	static {
		portList = new Vector(1);
		portList.add( RECORDPORTNAME );
		portList = Collections.unmodifiableCollection( portList );
	}
	
	Eml200DataOutputFormatColumnRecord( Eml200DataSource t ) {
		super(t);
	}

	/*
	 * Initialize as column based record for fire. 
	 */
	void initialize() throws IllegalActionException
	{
		//get cloumnDataArray 
		super.initialize();
		isFired = false;
		//generate record
		int size = that.getColumnLabels().length;
		int dataSize = _columnVectorArray.length;
		if (size != dataSize)
		{
			throw new IllegalActionException("The data cloumn didn't match head column");
		}
		Token[] data = new ArrayToken[size];
		Vector attributes = that.getColumns();
		for (int i=0; i<size; i++)
		{
			Vector columnData = _columnVectorArray[i];
			DSTableFieldIFace colDef = (DSTableFieldIFace)attributes.elementAt(i);
			Vector missingValue = colDef.getMissingValueCode();
			Token[] columnTokens = 
				Eml200DataSource.transformStringVectorToTokenArray(columnData, that.getColumnTypes()[i], missingValue);
			//transform columnTokens to ArrayToken
			ArrayToken arrayToken = new ArrayToken(columnTokens);
			data[i] = arrayToken;            
		}
		_recordToken = new RecordToken(that.getColumnLabels(), data);
	}
	
	/*
	 * This method will configure the actor output as a column based record.
	 * It will has one output port and name will be "Record".
	 */
	void reconfigurePorts() throws IllegalActionException
	{
		// the record is an ArrayToken, we should transfer from base type to
		// array type
		if (that.getColumnTypes() == null)
		{
			Eml200DataSource.log.debug("The columns info is null and coudldn't conigure ports as column record");
			return;
		}
		int size = that.getColumnTypes().length;
		ArrayType[] arrayTypeList = new ArrayType[size];
		for (int i = 0; i < size; i++)
		{
			arrayTypeList[i] = new ArrayType(that.getColumnTypes()[i]);
		}
		RecordType recordType = new RecordType(that.getColumnLabels(), arrayTypeList);
		
		that.removeOtherOutputPorts( portList );
		that.initializePort( RECORDPORTNAME, recordType );
	}
	
	/*
	 * This method will fire as column based record. Column based record
	 * is already prepared in initialize
	 */
	void fire() throws IllegalActionException
	{
		TypedIOPort pp = (TypedIOPort)that.getPort(RECORDPORTNAME);
		pp.send(0, _recordToken);
		isFired = true;
	}
	
	/**
	 * If is already fired, return false
	 */
	public boolean prefire() throws IllegalActionException {
		
			if (isFired) {
				return false;
			}
			else {
				return true;
			}
		
	}

}
