/**
 *    '$RCSfile: DisplayCurrentServicesListAction.java,v $'
 *
 *     '$Author: ruland $'
 *       '$Date: 2006/01/30 15:04:14 $'
 *   '$Revision: 1.9 $'
 *
 *  For Details: http://kepler.ecoinformatics.org
 *
 * Copyright (c) 2004 The Regents of the University of California.
 * All rights reserved.
 *
 * Permission is hereby granted, without written agreement and without
 * license or royalty fees, to use, copy, modify, and distribute this
 * software and its documentation for any purpose, provided that the
 * above copyright notice and the following two paragraphs appear in
 * all copies of this software.
 *
 * IN NO EVENT SHALL THE UNIVERSITY OF CALIFORNIA BE LIABLE TO ANY PARTY
 * FOR DIRECT, INDIRECT, SPECIAL, INCIDENTAL, OR CONSEQUENTIAL DAMAGES
 * ARISING OUT OF THE USE OF THIS SOFTWARE AND ITS DOCUMENTATION, EVEN
 * IF THE UNIVERSITY OF CALIFORNIA HAS BEEN ADVISED OF THE POSSIBILITY
 * OF SUCH DAMAGE.
 *
 * THE UNIVERSITY OF CALIFORNIA SPECIFICALLY DISCLAIMS ANY WARRANTIES,
 * INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES OF
 * MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE. THE SOFTWARE
 * PROVIDED HEREUNDER IS ON AN "AS IS" BASIS, AND THE UNIVERSITY
 * OF CALIFORNIA HAS NO OBLIGATION TO PROVIDE MAINTENANCE, SUPPORT,
 * UPDATES, ENHANCEMENTS, OR MODIFICATIONS.
 */

package org.ecoinformatics.seek.ecogrid.quicksearch;

import java.awt.Container;
import java.awt.Dimension;
import java.awt.Point;
import java.awt.event.ActionEvent;

import javax.swing.AbstractAction;

import org.ecoinformatics.seek.ecogrid.EcoGridQueryServicesController;
import org.ecoinformatics.seek.ecogrid.EcoGridServicesController;
import org.ecoinformatics.seek.ecogrid.ServicesDisplayFrame;
import org.ecoinformatics.seek.ecogrid.ServicesDisplayPanel;
import org.ecoinformatics.seek.ecogrid.ServicesListModificationFrame;

/**
 * This class will load current services list from configure file into a frame
 * to display them.
 * @author Jing Tao
 */

class DisplayCurrentServicesListAction extends AbstractAction 
{
  private EcoGridServicesController serviceController = null;
  private ServicesListModificationFrame frame         = null;
  private DatasetPanel datasetPane                    = null;
  
  /**
   * Constructor
   * @param serviceController EcoGridServicesController
   */
  public DisplayCurrentServicesListAction(String name, 
         EcoGridServicesController serviceController, DatasetPanel datasetPane) 
  {
    super(name);
    this.serviceController = serviceController;
    this.datasetPane       = datasetPane;
  }//DisplayCurrentServicesListAction
  
  
  /**
   * This method will initilize a display frame
   * @param e ActionEvent
   */
  public void actionPerformed(ActionEvent e) 
  {
   if (serviceController != null)
   {
     // from paretn frame(ptolemy frame) to calculate the kid frame position
     Container parent = datasetPane.getParentFrame();
     Point location   = calculateLocation(parent);
     //transfer to selectedSerive list(object is SelectedEcoGridService now)
     /*Vector selectedServicesLists =
         SelectableEcoGridService.
         transferServiceVectToDefaultSelectedServiceVect(unSelectedserviceList);*/
     frame = new ServicesListModificationFrame("Services List", serviceController, location);
     frame.setDisplayText("Current Data Source(s):");
     //frame.setEcoGridServicesController(serviceController);
   }//if

  }//actionPerformed
  
  /*
   * This method will calculate kids frame location
   * kidX = parentX + parentWidth/2 - kidWidth/2
   * kidY = parentY + parentHeight/2 - kidHeight/2
   */
  private Point calculateLocation(Container parent)
  {
    Point location = null;
    if (parent != null)
    {
      Dimension dimension = parent.getPreferredSize();
      int width  = (int)dimension.getWidth();
      int height = (int)dimension.getHeight();
      int parentX = parent.getX();
      int parentY = parent.getY();
      int kidWidth = 2* ServicesDisplayFrame.MARGINGSIZE + 
           ServicesDisplayPanel.HEADNAME.length *ServicesDisplayPanel.CELLPREFERREDWIDTH;
      int kidHeight = ServicesDisplayFrame.HEIGHT;
      int kidX = parentX + width/2 - kidWidth/2;
      int kidY = parentY + height/2 - kidHeight/2;
      location = new Point(kidX, kidY);
    }
    return location;
  }
  
  public static void main(String[]args)
  {
    EcoGridQueryServicesController controller = 
                                   EcoGridQueryServicesController.getInstance();
    DisplayCurrentServicesListAction action = 
                              new DisplayCurrentServicesListAction("Data Sources ...",controller, null);
    action.actionPerformed(null);
    controller.print();
  }//main

}//DisplayCurrentServicesListAction