/**
 *    '$RCSfile$'
 *
 *     '$Author$'
 *       '$Date$'
 *   '$Revision$'
 *
 *  For Details: http://kepler.ecoinformatics.org
 *
 * Copyright (c) 2003 The Regents of the University of California.
 * All rights reserved.
 *
 * Permission is hereby granted, without written agreement and without
 * license or royalty fees, to use, copy, modify, and distribute this
 * software and its documentation for any purpose, provided that the
 * above copyright notice and the following two paragraphs appear in
 * all copies of this software.
 *
 * IN NO EVENT SHALL THE UNIVERSITY OF CALIFORNIA BE LIABLE TO ANY PARTY
 * FOR DIRECT, INDIRECT, SPECIAL, INCIDENTAL, OR CONSEQUENTIAL DAMAGES
 * ARISING OUT OF THE USE OF THIS SOFTWARE AND ITS DOCUMENTATION, EVEN
 * IF THE UNIVERSITY OF CALIFORNIA HAS BEEN ADVISED OF THE POSSIBILITY
 * OF SUCH DAMAGE.
 *
 * THE UNIVERSITY OF CALIFORNIA SPECIFICALLY DISCLAIMS ANY WARRANTIES,
 * INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES OF
 * MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE. THE SOFTWARE
 * PROVIDED HEREUNDER IS ON AN "AS IS" BASIS, AND THE UNIVERSITY
 * OF CALIFORNIA HAS NO OBLIGATION TO PROVIDE MAINTENANCE, SUPPORT,
 * UPDATES, ENHANCEMENTS, OR MODIFICATIONS.
 */

package org.ecoinformatics.util;

import java.io.File;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.SQLException;

/**
 * DBConnectionFactory creates connections to the internal hsql database.
 * It provides very little value other than caching the username,
 * password, and jdbc connection string.  In particular it does not provide
 * any type of database connection pooling.
 * 
 * @author Kevin Ruland
 *
 */
public class DBConnectionFactory {

	  private static final String USERNAMEPATH      = "//sqlEngine[sqlEngineName=\"hsql\"]/userName";
	  private static final String PASSWORDPATH      = "//sqlEngine[sqlEngineName=\"hsql\"]/password";

	  private static String username;
	  private static String password;
	  private static String dbNamePath;
	  
	  static {
		     username = Config.getValue(USERNAMEPATH);
		     password = Config.getValue(PASSWORDPATH);
		     dbNamePath = Config.getCacheDirPath() + "cachedata" + File.separator + "hsqldb";
	  }
	  
	  /**
	   * Method to get a connection to the internal DB.
	   *
	   * @throws SQLException
	   * @throws ClassNotFoundException
	   * @return Connection
	   */
	  public static DBConnection getDBConnection() throws SQLException, ClassNotFoundException
	  {
	     Connection conn = getDBConnection(username, password);
	     return new DBConnection(conn);

	  }

	  private static Connection getDBConnection(String userName, String password)
	                                   throws SQLException, ClassNotFoundException
	  {
	    // Load the HSQL Database Engine JDBC driver
	    // hsqldb.jar should be in the class path or made part of the current jar
	    Class.forName("org.hsqldb.jdbcDriver");

	    // connect to the database.   This will load the db files and start the
	    // database if it is not alread running.
	    // db_file_name_prefix is used to open or create files that hold the state
	    // of the db.
	    // It can contain directory names relative to the
	    // current working directory
	    return DriverManager.getConnection("jdbc:hsqldb:" + dbNamePath,
	                                         userName, password);

	  }


}
