/* A constant source.

Copyright (c) 1998-2003 The Regents of the University of California.
All rights reserved.
Permission is hereby granted, without written agreement and without
license or royalty fees, to use, copy, modify, and distribute this
software and its documentation for any purpose, provided that the above
copyright notice and the following two paragraphs appear in all copies
of this software.

IN NO EVENT SHALL THE UNIVERSITY OF CALIFORNIA BE LIABLE TO ANY PARTY
FOR DIRECT, INDIRECT, SPECIAL, INCIDENTAL, OR CONSEQUENTIAL DAMAGES
ARISING OUT OF THE USE OF THIS SOFTWARE AND ITS DOCUMENTATION, EVEN IF
THE UNIVERSITY OF CALIFORNIA HAS BEEN ADVISED OF THE POSSIBILITY OF
SUCH DAMAGE.

THE UNIVERSITY OF CALIFORNIA SPECIFICALLY DISCLAIMS ANY WARRANTIES,
INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES OF
MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE. THE SOFTWARE
PROVIDED HEREUNDER IS ON AN "AS IS" BASIS, AND THE UNIVERSITY OF
CALIFORNIA HAS NO OBLIGATION TO PROVIDE MAINTENANCE, SUPPORT, UPDATES,
ENHANCEMENTS, OR MODIFICATIONS.

                                       PT_COPYRIGHT_VERSION_2
                                       COPYRIGHTENDKEY
*/

package org.geon;

import java.net.URL;
import java.util.Iterator;
import java.util.List;

import ptolemy.actor.CompositeActor;
import ptolemy.actor.IOPort;
import ptolemy.actor.TypedAtomicActor;
import ptolemy.actor.TypedCompositeActor;
import ptolemy.actor.TypedIOPort;
import ptolemy.actor.lib.Const;
import ptolemy.data.ArrayToken;
import ptolemy.data.BooleanMatrixToken;
import ptolemy.data.DoubleMatrixToken;
import ptolemy.data.DoubleToken;
import ptolemy.data.IntMatrixToken;
import ptolemy.data.IntToken;
import ptolemy.data.LongMatrixToken;
import ptolemy.data.LongToken;
import ptolemy.data.RecordToken;
import ptolemy.data.StringToken;
import ptolemy.data.Token;
import ptolemy.data.UnsignedByteToken;
import ptolemy.data.expr.Parameter;
import ptolemy.data.expr.Variable;
import ptolemy.data.type.BaseType;
import ptolemy.kernel.ComponentEntity;
import ptolemy.kernel.CompositeEntity;
import ptolemy.kernel.util.Attribute;
import ptolemy.kernel.util.IllegalActionException;
import ptolemy.kernel.util.NameDuplicationException;
import ptolemy.kernel.util.NamedObj;
import ptolemy.moml.MoMLParser;

//////////////////////////////////////////////////////////////////////////
////ConstOnce
/**
Produce a constant output once. The value of the
output is that of the token contained by the <i>value</i> parameter,
which by default is an IntToken with value 1. The type of the output
is that of <i>value</i> parameter.

@author Efrat Jaeger
@version $Id: InputsToXML.java,v 1.6 2005/11/01 20:39:08 ruland Exp $
@since Ptolemy II 3.0.2
*/

public class InputsToXML extends TypedAtomicActor {

 	/** Construct an actor with the given container and name.
	  *  @param container The container.
	  *  @param name The name of this actor.
	  *  @exception IllegalActionException If the actor cannot be contained
	  *   by the proposed container.
	  *  @exception NameDuplicationException If the container already has an
	  *   actor with this name.
	  */
   	public InputsToXML(CompositeEntity container, String name)
           throws NameDuplicationException, IllegalActionException  {
       	super(container, name);

		output = new TypedIOPort(this, "output", false, true);
       	output.setTypeEquals(BaseType.STRING);
       	modelURL = new Parameter(this, "modelURL");
   	}

	TypedIOPort output;
   	Parameter modelURL;

   	///////////////////////////////////////////////////////////////////
   	////                         public methods                    ////


    public void attributeChanged(Attribute at) throws IllegalActionException {
    	if (at == modelURL) {
    		try {
    			String modelStr = "";
    			StringToken urlToken = null;
				try {
					urlToken = ((StringToken)(modelURL.getToken()));
					modelStr = urlToken.stringValue();
					System.out.println(modelStr);
				} catch (Exception ex) {}
    			if (modelStr == "") {
    				_prevURL = modelStr;
    			}
    	        if (modelStr != ""
    	                  && !modelStr.equals(_prevURL)) {
    	              _prevURL = modelStr;
    	            deleteInputPorts();
    				URL url = new URL(modelStr);
	                MoMLParser parser = new MoMLParser();
	                NamedObj model;
	                try {
	                    model = parser.parse(null, url);
	                } catch (Exception ex) {
	                    throw new IllegalActionException(
	                        ex +
	                        "Failed to pass the model URL." +
	                        url.toString());
	                }
	                _workspace = model.getFullName();
	        		_workspaceLen = _workspace.length()+1;

	                CompositeActor CA = (CompositeActor) model;
	                _setInputs(CA);

	            }
    		} catch (Exception ex) {
    			ex.printStackTrace();
    		}
      	} else {
        	super.attributeChanged(at);
      	}
    }



   	public void fire() throws IllegalActionException {

   		xml = "<variables>\n";
   		List inputs = this.inputPortList();
   		Iterator ports = inputs.iterator();
   		while (ports.hasNext()) {
   			xml += "<input>\n";
   			IOPort in = (IOPort) ports.next();
			String name = in.getName();
			xml += "<name>" + name + "</name>\n";
			// get inputs from all channels.
			for (int i=0; i<in.getWidth(); i++) {
				xml += "<channel num=\"" +  i + "\">\n";
				Token t = in.get(i);
				_process(t);
				xml += "</channel>\n";
			}
			xml += "</input>\n";
        }

        xml += "</variables>";
		output.broadcast(new StringToken(xml));

   	}

   	private void _setInputs(CompositeActor CA) {
   		Iterator ents = CA.entityList().iterator();
    	while (ents.hasNext()) {
    		Object obj = ents.next();
    		ComponentEntity CE = (ComponentEntity) obj;
    		//System.out.println(obj.getClass().getName());
    		if (CE instanceof TypedCompositeActor) {
    			CompositeActor inner = (CompositeActor) CE;
    			_setInputs(inner);
    			//TODO: add composite entity name??
    		}
			// get the name and fullName of the input actor to later instantiate the value.
			if (CE instanceof Const) {
				if (CE.getName().trim().toLowerCase().startsWith("in")) {

					String fullName = CE.getFullName();
					fullName = fullName.substring(_workspaceLen);
					fullName = fullName.replace('.','_'); //TODO: might change..
					Attribute at = CE.getAttribute("value");
					Variable val = (Variable) at;
					try {  //TODO: perhaps this should be the const output type which should be set previously
						TypedIOPort p = new TypedIOPort(this, fullName, true, false);
						if (val.getType().equals(BaseType.UNKNOWN)) {
	        				p.setTypeEquals(BaseType.GENERAL);
	        			} else p.setTypeEquals(val.getType());
					} catch (Exception ex) {
	                    System.out.println(ex + "Failed to create input port " +
	                        fullName + " of type " + val.getType());
	                }
				}
			}
    	}
   	}

   	private void _process (Token token) {

   		if (token instanceof UnsignedByteToken) {
   			xml += "<unsignedbyte>";
   			String val = ((UnsignedByteToken) token).unitsString();
   			xml += val + "</unsignedbyte>\n";

   		} else if (token instanceof IntToken) {
   			xml += "<int>";
   			String val = ((IntToken) token).toString();
   			xml += val + "</int>\n";

   		} else if (token instanceof DoubleToken) {
   			xml += "<double>";
   			String val = ((DoubleToken) token).toString();
   			xml += val + "</double>\n";

   		} else if (token instanceof LongToken) {
   			xml += "<long>";
   			String val = ((LongToken) token).toString();
   			xml += val + "</long>\n";

   		} else if (token instanceof IntMatrixToken) {
   			xml += "<intmatrix>\n";
   			int[][] Mat = ((IntMatrixToken)token).intMatrix();
   			for (int i=0; i<Mat.length; i++) {
   				xml += "<row>\n";
   				for (int j=0; j<Mat[0].length; j++) {
   					xml += "<value>" + Mat[i][j] + "</value>\n";
   				}
   				xml += "</row>\n";
   			}
   			xml += "</intmatrix>\n";

   		} else if (token instanceof DoubleMatrixToken) {
   			xml += "<doublematrix>\n";
   			double[][] Mat = ((DoubleMatrixToken)token).doubleMatrix();
   			for (int i=0; i<Mat.length; i++) {
    			xml += "<row>\n";
   				for (int j=0; j<Mat[0].length; j++) {
   					xml += "<value>" + Mat[i][j] + "</value>\n";
   				}
   				xml += "</row>\n";
   			}
   			xml += "</doublematrix>\n";

   		} else if (token instanceof LongMatrixToken) {
   			xml += "<longmatrix>\n";
   			long[][] Mat = ((LongMatrixToken)token).longMatrix();
   			for (int i=0; i<Mat.length; i++) {
   				xml += "<row>\n";
   				for (int j=0; j<Mat[0].length; j++) {
   					xml += "<value>" + Mat[i][j] + "</value>\n";
   				}
   				xml += "</row>\n";
   			}
   			xml += "</longmatrix>\n";

   		} else if (token instanceof BooleanMatrixToken) {
   			xml += "<booleanmatrix>\n";
   			boolean Mat[][] = ((BooleanMatrixToken)token).booleanMatrix();
   			for (int i=0; i<Mat.length; i++) {
   				xml += "<row>\n";
   				for (int j=0; j<Mat[0].length; j++) {
   					xml += "<value>" + Mat[i][j] + "</value>\n";
   				}
   				xml += "</row>\n";
   			}
   			xml += "</booleanmatrix>\n";

   		} else if (token instanceof StringToken) {
   			xml += "<string>";
   			String val = ((StringToken) token).stringValue();
   			xml += val + "</string>\n";

   		} else if (token instanceof ArrayToken) {
   			xml += "<array>\n";
   			ArrayToken at = (ArrayToken) token;
   			Token[] tArr = at.arrayValue();
   			for (int i=0; i<tArr.length; i++) {
   				_process(tArr[i]);
   			}
   			xml += "</array>\n";

   		} else if (token instanceof RecordToken) {
   			xml += "<record>\n";
   			RecordToken rt = (RecordToken) token;
   			Object[] labelObjects = rt.labelSet().toArray();
			for (int i = 0; i < labelObjects.length; i++) {
				String label = (String)labelObjects[i];
				xml += "<label>" + label + "</label>\n";
				Token value = rt.get(label);
				xml += "<value>\n";
				_process(value);
				xml += "</value>\n";
   			}
   			xml += "</record>\n";
   		}

   	}

   /** Set postfire to false.
    *  @exception IllegalActionException If thrown by the super class.
    */
   public boolean postfire() throws IllegalActionException {
   	xml = "";
     return false;
   }


   private void deleteInputPorts() {
    List inPortList = this.inputPortList();
    Iterator ports = inPortList.iterator();
    while (ports.hasNext()) {
      IOPort p = (IOPort) ports.next();
      if (p.isInput()) {
        try {
            p.setContainer(null);
        }
        catch (Exception e) {}
      }
    }
   }
   private String _workspace;
   private int _workspaceLen;
   private String xml = "";
   private String _prevURL;
}
