/*
 * Copyright (c) 2004 The Regents of the University of California.
 * All rights reserved.
 *
 * Permission is hereby granted, without written agreement and without
 * license or royalty fees, to use, copy, modify, and distribute this
 * software and its documentation for any purpose, provided that the
 * above copyright notice and the following two paragraphs appear in
 * all copies of this software.
 *
 * IN NO EVENT SHALL THE UNIVERSITY OF CALIFORNIA BE LIABLE TO ANY PARTY
 * FOR DIRECT, INDIRECT, SPECIAL, INCIDENTAL, OR CONSEQUENTIAL DAMAGES
 * ARISING OUT OF THE USE OF THIS SOFTWARE AND ITS DOCUMENTATION, EVEN
 * IF THE UNIVERSITY OF CALIFORNIA HAS BEEN ADVISED OF THE POSSIBILITY
 * OF SUCH DAMAGE.
 *
 * THE UNIVERSITY OF CALIFORNIA SPECIFICALLY DISCLAIMS ANY WARRANTIES,
 * INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES OF
 * MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE. THE SOFTWARE
 * PROVIDED HEREUNDER IS ON AN "AS IS" BASIS, AND THE UNIVERSITY
 * OF CALIFORNIA HAS NO OBLIGATION TO PROVIDE MAINTENANCE, SUPPORT,
 * UPDATES, ENHANCEMENTS, OR MODIFICATIONS.
 *
 *                                       PT_COPYRIGHT_VERSION_2
 *                                       COPYRIGHTENDKEY
 */


package org.geon;

import org.w3c.dom.Element;
import org.w3c.dom.Node;

import ptolemy.actor.lib.Transformer;
import ptolemy.actor.parameters.PortParameter;
import ptolemy.data.StringToken;
import ptolemy.data.XMLToken;
import ptolemy.data.type.BaseType;
import ptolemy.kernel.CompositeEntity;
import ptolemy.kernel.util.IllegalActionException;
import ptolemy.kernel.util.NameDuplicationException;


//////////////////////////////////////////////////////////////////////////
//// XMLGetAttributeValue	
/**
    Retruns an attribute value for a given XML element. 
    
    This actor takes in an attribute name and an XML string, and returns the
    value of the attribute if it exists on the top level of the element.

    @author jaeger
    @version $Id: XMLGetAttributeValue.java,v 1.2 2005/11/01 20:39:08 ruland Exp $
 */


public class XMLGetAttributeValue extends Transformer {

    /** Construct an XPath actor with the given container and name.
     *  @param container The container.
     *  @param name The name of this actor.
     *  @exception IllegalActionException If the actor cannot be contained
     *   by the proposed container.
     *  @exception NameDuplicationException If the container already has an
     *   actor with this name.
     */
    public XMLGetAttributeValue(CompositeEntity container, String name)
        throws NameDuplicationException, IllegalActionException {

        super(container, name);

        attribute = new PortParameter(this, "attribute");
        attribute.setStringMode(true);

        input.setTypeEquals(BaseType.XMLTOKEN);
        output.setTypeEquals(BaseType.STRING);
        attribute.setTypeEquals(BaseType.STRING);

        _attachText(
            "_iconDescription",
            "<svg>\n"
                + "<rect x=\"0\" y=\"0\" "
                + "width=\"60\" height=\"20\" "
                + "style=\"fill:white\"/>\n"
                + "</svg>\n");

    }


    ///////////////////////////////////////////////////////////////////
    ////                     ports and parameters                  ////

    public PortParameter attribute;


    ///////////////////////////////////////////////////////////////////
    ////                         public methods                    ////

    /** Take in an XML element string and an attribute name, and returns 
     *  the value of the attribute. If the outmost tag doesn't contain the 
     *  attribute, returns an empty string.
     * 
     *  @exception IllegalActionException If the xml element is not well defined.
     */
    public void fire() throws IllegalActionException {
        super.fire();

        // get inputs
        XMLToken tokenXml = (XMLToken) input.get(0);
        attribute.update();
        String searchAtt = ((StringToken) attribute.getToken()).stringValue();
        _debug("The attribute name is: " + searchAtt);

        // output value
        String value = "";
        
        // get dom	
        try {
            Node node = tokenXml.getDomTree().getDocumentElement();
		    
		    // search for attribute
		    try {
		    	value = ((Element)node).getAttribute(searchAtt);
		    } catch (Exception ex) {}


        } catch (Exception ex) {
        	throw new IllegalActionException(this, "unable to create dom object for the xml content." +
        			ex.getMessage());
			
        }
        output.send(0, new StringToken(value));
    }

}
