/*
 *  The node controller for actor instances.
 *  Copyright (c) 2003-2004 The Regents of the University of California.
 *  All rights reserved.
 *  Permission is hereby granted, without written agreement and without
 *  license or royalty fees, to use, copy, modify, and distribute this
 *  software and its documentation for any purpose, provided that the above
 *  copyright notice and the following two paragraphs appear in all copies
 *  of this software.
 *  IN NO EVENT SHALL THE UNIVERSITY OF CALIFORNIA BE LIABLE TO ANY PARTY
 *  FOR DIRECT, INDIRECT, SPECIAL, INCIDENTAL, OR CONSEQUENTIAL DAMAGES
 *  ARISING OUT OF THE USE OF THIS SOFTWARE AND ITS DOCUMENTATION, EVEN IF
 *  THE UNIVERSITY OF CALIFORNIA HAS BEEN ADVISED OF THE POSSIBILITY OF
 *  SUCH DAMAGE.
 *  THE UNIVERSITY OF CALIFORNIA SPECIFICALLY DISCLAIMS ANY WARRANTIES,
 *  INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES OF
 *  MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE. THE SOFTWARE
 *  PROVIDED HEREUNDER IS ON AN "AS IS" BASIS, AND THE UNIVERSITY OF
 *  CALIFORNIA HAS NO OBLIGATION TO PROVIDE MAINTENANCE, SUPPORT, UPDATES,
 *  ENHANCEMENTS, OR MODIFICATIONS.
 *  PT_COPYRIGHT_VERSION_2
 *  COPYRIGHTENDKEY
 */
package org.kepler.gui;

import java.awt.Component;
import java.awt.event.ActionEvent;
import java.io.File;
import java.io.FileOutputStream;
import java.io.ObjectOutputStream;
import java.util.jar.JarOutputStream;

import javax.swing.tree.TreePath;
import javax.swing.JOptionPane;

import org.kepler.ksw.KSWEntry;
import org.kepler.ksw.KSWManifest;
import org.kepler.moml.NamedObjId;

import ptolemy.actor.TypedAtomicActor;
import ptolemy.vergil.basic.BasicGraphFrame;

/**
 * This action adds actors to a ksw file
 * This action is activated when you rt. click on an actor in the actor library
 *
 *@author     Chad Berkley
 *@created    February 17, 2005
 */
public class CreateKSWFromActorAction extends TreeAction
{
  private final static String LABEL = "Create archive from actor...";

  /**
   * Constructor
   *
   *@param  path    the TreePath where the actor is being added.
   *@param  parent  Description of the Parameter
   */
  public CreateKSWFromActorAction(TreePath path, Component parent)
  {
    super(path, parent, LABEL);
  }

  /**
   * Invoked when an action occurs.
   *
   *@param  e  ActionEvent
   */
  public void actionPerformed(ActionEvent e)
  {
    super.actionPerformed(e);
    Component current = parent;
    while (parent != null && !(parent instanceof BasicGraphFrame))
    {
      parent = current.getParent();
      current = parent;
    }

    try
    {
      //TODO: This all needs to be redone...
      JOptionPane.showMessageDialog(null,
               "This doesn't currently work...", "alert", 
               JOptionPane.ERROR_MESSAGE);
      //get the actor
      /*TypedAtomicActor actor = (TypedAtomicActor)path.getLastPathComponent();
      System.out.println("creating KAR from actor " + actor);
      //get a non-instance Class object for the actor
      Class actorClass = Class.forName(actor.getClass().getName());
      //serialize the class to a temp file
      String entryName = actorClass.getName().replaceAll("\\.", "/") + ".class";
      File f = new File("C:/test.kar");
      f.createNewFile();
      FileOutputStream fos = new FileOutputStream(f);
      KSWManifest manifest = new KSWManifest();

      NamedObjId noid = (NamedObjId)actor.getAttribute("entityId");
      //LSID lsid = new LSID(noid.getExpression());

      //do some stuff to the manifest
      manifest.addEntryAttribute(entryName, "lsid", noid.getExpression());

      JarOutputStream jos = new JarOutputStream(fos, manifest);

      //get some id here and use it for the name
      KSWEntry classEntry =
        new KSWEntry(entryName);

      jos.putNextEntry(classEntry);

      //write the class to the jar stream
      ObjectOutputStream oos = new ObjectOutputStream(jos);
      oos.writeObject(actorClass);
      oos.close();*/
    }
    catch(Exception ex)
    {
      System.out.println("Error writing KAR file: " + ex.getMessage());
      ex.printStackTrace();
    }
  }
}

