/**
 *    '$RCSfile: Repository.java,v $'
 *
 *     '$Author: berkley $'
 *       '$Date: 2006/03/07 22:07:38 $'
 *   '$Revision: 1.3 $'
 *
 *  For Details: http://kepler.ecoinformatics.org
 *
 * Copyright (c) 2003 The Regents of the University of California.
 * All rights reserved.
 *
 * Permission is hereby granted, without written agreement and without
 * license or royalty fees, to use, copy, modify, and distribute this
 * software and its documentation for any purpose, provided that the
 * above copyright notice and the following two paragraphs appear in
 * all copies of this software.
 *
 * IN NO EVENT SHALL THE UNIVERSITY OF CALIFORNIA BE LIABLE TO ANY PARTY
 * FOR DIRECT, INDIRECT, SPECIAL, INCIDENTAL, OR CONSEQUENTIAL DAMAGES
 * ARISING OUT OF THE USE OF THIS SOFTWARE AND ITS DOCUMENTATION, EVEN
 * IF THE UNIVERSITY OF CALIFORNIA HAS BEEN ADVISED OF THE POSSIBILITY
 * OF SUCH DAMAGE.
 *
 * THE UNIVERSITY OF CALIFORNIA SPECIFICALLY DISCLAIMS ANY WARRANTIES,
 * INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES OF
 * MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE. THE SOFTWARE
 * PROVIDED HEREUNDER IS ON AN "AS IS" BASIS, AND THE UNIVERSITY
 * OF CALIFORNIA HAS NO OBLIGATION TO PROVIDE MAINTENANCE, SUPPORT,
 * UPDATES, ENHANCEMENTS, OR MODIFICATIONS.
 */
package org.kepler.objectmanager.repository;

import java.io.*;
import java.util.*;

import org.kepler.objectmanager.lsid.KeplerLSID;

/**
 * This interface represents a repository on the ecogrid
 *
 * @author Chad Berkley
 */
public abstract class Repository
{
  protected String repository;
  protected String username;
  protected String password;
  
  /**
   * constructor
   * @param repository the address of the repository
   * @param username the username of the repository
   * @param password the password for the repository
   */
  public Repository(String repository, String username, String password)
  {
    this.repository = repository;
    this.username = username;
    this.password = password;
  }
  
  /**
   * Search the repository and return an iterator of results (the Iterator
   * contains KeplerLSIDs of matched items).
   */
  public abstract Iterator search(String queryString) throws RepositoryException;
  
  /**
   * return the object from the repository that has the given lsid
   */
  public abstract Object get(KeplerLSID lsid) throws RepositoryException;
  
  /**
   * put an object into the repository with the given lsid
   */
  public abstract void put(Object o, KeplerLSID lsid) throws RepositoryException;
  
  /**
   * get the repository url
   */
  public String getRepository()
  {
    return repository;
  }
}
