/**
 *    '$RCSfile: RepositoryManager.java,v $'
 *
 *     '$Author: berkley $'
 *       '$Date: 2006/03/07 22:07:38 $'
 *   '$Revision: 1.5 $'
 *
 *  For Details: http://kepler.ecoinformatics.org
 *
 * Copyright (c) 2003 The Regents of the University of California.
 * All rights reserved.
 *
 * Permission is hereby granted, without written agreement and without
 * license or royalty fees, to use, copy, modify, and distribute this
 * software and its documentation for any purpose, provided that the
 * above copyright notice and the following two paragraphs appear in
 * all copies of this software.
 *
 * IN NO EVENT SHALL THE UNIVERSITY OF CALIFORNIA BE LIABLE TO ANY PARTY
 * FOR DIRECT, INDIRECT, SPECIAL, INCIDENTAL, OR CONSEQUENTIAL DAMAGES
 * ARISING OUT OF THE USE OF THIS SOFTWARE AND ITS DOCUMENTATION, EVEN
 * IF THE UNIVERSITY OF CALIFORNIA HAS BEEN ADVISED OF THE POSSIBILITY
 * OF SUCH DAMAGE.
 *
 * THE UNIVERSITY OF CALIFORNIA SPECIFICALLY DISCLAIMS ANY WARRANTIES,
 * INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES OF
 * MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE. THE SOFTWARE
 * PROVIDED HEREUNDER IS ON AN "AS IS" BASIS, AND THE UNIVERSITY
 * OF CALIFORNIA HAS NO OBLIGATION TO PROVIDE MAINTENANCE, SUPPORT,
 * UPDATES, ENHANCEMENTS, OR MODIFICATIONS.
 */
package org.kepler.objectmanager.repository;

import java.io.*;
import java.util.*;

import java.lang.reflect.Constructor;

import org.kepler.objectmanager.lsid.KeplerLSID;

import ptolemy.kernel.util.StaticResources;
import ptolemy.util.OrderedResourceBundle;

/**
 * This class provides functionality to upload and retrieve objects from the 
 * Ecogrid repository for Kepler actor/kar objects.
 *
 * @author Chad Berkley
 */
public class RepositoryManager
{
  public static final String RESOURCEBUNDLE_DIR = "ptolemy/configs/kepler";
  public static final String REPOSITORY_BUNDLE = 
    RESOURCEBUNDLE_DIR + "/repositoryBundle";
  private static RepositoryManager manager;
  private Vector repositoryVector = new Vector();
  
  /**
   * default constructor
   */
  public RepositoryManager()
    throws IOException, Exception
  {
    //get a list of repositories from the repository bundle
    OrderedResourceBundle repositoryBundle = 
      OrderedResourceBundle.getBundle(REPOSITORY_BUNDLE);
    Iterator keys = repositoryBundle.getKeys();
    while(keys.hasNext())
    { //the keys should come in groups of 4 in the follwing order:
      //repository, username, password, class
      String key = (String)keys.next();
      String repository = repositoryBundle.getString(key);
      key = (String)keys.next();
      String username = repositoryBundle.getString(key);
      key = (String)keys.next();
      String password = repositoryBundle.getString(key);
      key = (String)keys.next();
      String repClass = repositoryBundle.getString(key);
      
      //create the repository with the given class using reflections
      String[] s = new String[3];
      s[0] = repository;
      s[1] = username;
      s[2] = password;
      Repository r = createInstance(Class.forName(repClass), s);
      repositoryVector.addElement(r);
    }
  }
  
  /**
   * Returns a singleton instance of this class
   */
  public static RepositoryManager getInstance()
    throws IOException, Exception
  {
    if(manager == null)
    {
      manager = new RepositoryManager();
    }
    return manager;
  }
  
  /**
   * return a list of repositories
   */
  public Iterator repositoryList()
  {
    return repositoryVector.iterator();
  }
  
  /**
   * creates and instance of a repository
   * 
   *@param  newClass
   *@param  arguments
   *@return Repository
   */
  private Repository createInstance(Class newClass, Object[] arguments)
    throws Exception
  {
    Constructor[] constructors = newClass.getConstructors();
    for(int i = 0; i < constructors.length; i++)
    {
      Constructor constructor = constructors[i];
      Class[] parameterTypes = constructor.getParameterTypes();

      for(int j=0; j<parameterTypes.length; j++)
      {
        Class c = parameterTypes[j];
      }

      if(parameterTypes.length != arguments.length)
      {
        continue;
      }

      boolean match = true;

      for(int j = 0; j < parameterTypes.length; j++)
      {
        if(!(parameterTypes[j].isInstance(arguments[j])))
        {
          match = false;
          break;
        }
      }

      if(match)
      {
        Repository newRepository = (Repository)constructor.newInstance(arguments);
        return newRepository;
      }
    }

    // If we get here, then there is no matching constructor.
    // Generate a StringBuffer containing what we were looking for.
    StringBuffer argumentBuffer = new StringBuffer();

    for(int i = 0; i < arguments.length; i++)
    {
      argumentBuffer.append(arguments[i].getClass() + " = \""
           + arguments[i].toString() + "\"");

      if(i < (arguments.length - 1))
      {
        argumentBuffer.append(", ");
      }
    }

    throw new Exception("Cannot find a suitable constructor ("
         + arguments.length + " args) (" + argumentBuffer + ") for '"
         + newClass.getName() + "'");
  }
}