/**
 * Copyright (c) 2005 The Regents of the University of California.
 * All rights reserved.
 *
 * Permission is hereby granted, without written agreement and without
 * license or royalty fees, to use, copy, modify, and distribute this
 * software and its documentation for any purpose, provided that the
 * above copyright notice and the following two paragraphs appear in
 * all copies of this software.
 *
 * IN NO EVENT SHALL THE UNIVERSITY OF CALIFORNIA BE LIABLE TO ANY PARTY
 * FOR DIRECT, INDIRECT, SPECIAL, INCIDENTAL, OR CONSEQUENTIAL DAMAGES
 * ARISING OUT OF THE USE OF THIS SOFTWARE AND ITS DOCUMENTATION, EVEN
 * IF THE UNIVERSITY OF CALIFORNIA HAS BEEN ADVISED OF THE POSSIBILITY
 * OF SUCH DAMAGE.
 *
 * THE UNIVERSITY OF CALIFORNIA SPECIFICALLY DISCLAIMS ANY WARRANTIES,
 * INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES OF
 * MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE. THE SOFTWARE
 * PROVIDED HEREUNDER IS ON AN "AS IS" BASIS, AND THE UNIVERSITY
 * OF CALIFORNIA HAS NO OBLIGATION TO PROVIDE MAINTENANCE, SUPPORT,
 * UPDATES, ENHANCEMENTS, OR MODIFICATIONS.
 */
package org.kepler.scia;


/**
 * The class displays the arrow on the top of the
 * main GUI which shows which tree is the source and
 * which one is the target, and also shows which side
 * tree node is currently worked on.
 *
 *@author Vitaliy Zavesov
 */
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Polygon;
import java.awt.Toolkit;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.io.PrintWriter;
import java.util.Vector;

import javax.swing.JPanel;


public class Arrow extends JPanel {
    SchemaTree leftTree = null;
    SchemaTree rightTree = null;

    // return values
    public String operations = null;
    Color defCol = new Color(150, 150, 255);
    Color selCol = new Color(255, 150, 150);
    ArrowCanvas can = new ArrowCanvas();
    MouseAdapter ma = new MouseAdapter() {
            public void mouseClicked(MouseEvent e) {
                PrintWriter cout = new PrintWriter(System.err, true);

                if (SCIA.debug_on) {
                    cout.println("Mouse clicked");
                }

                int X = e.getX();
                int Y = e.getY();

                if (SCIA.debug_on) {
                    cout.println("X = " + X + "Y = " + Y);
                }

                int width = getWidth();

                if (X < (width / 3)) {
                    if (can.leftColor == selCol) {
                        can.setColors(defCol, defCol, defCol);
                        leftTree.mainUI.altPressed = false;

                        int selectionRow = leftTree.getMinSelectionRow();

                        if (selectionRow != 0) {
                            leftTree.removeSelectionRow(selectionRow);
                        }
                    } else {
                        can.setColors(selCol, defCol, defCol);

                        try {
                            SwingWorker worker = new SwingWorker() {
                                    public Object construct() {
                                        try {
                                            whichMatch();
                                        } catch (Exception ex) {
                                            if (SCIA.debug_on) {
                                                System.err.println(
                                                    " error ::: " + ex);
                                            }
                                        }

                                        return null;
                                    }
                                };

                            worker.start();
                        } catch (Exception ex) {
                            if (SCIA.debug_on) {
                                cout.println(" error ::: " + ex);
                            }
                        }
                    }
                } else if (X < ((width * 2) / 3)) {
                    can.setColors(defCol, selCol, defCol);

                    leftTree.mainUI.createMappingItem.doClick();
                } else {
                    if (can.rightColor == selCol) {
                        can.setColors(defCol, defCol, defCol);

                        int selectionRow = rightTree.getMinSelectionRow();

                        if (selectionRow != 0) {
                            rightTree.removeSelectionRow(selectionRow);
                        }
                    } else {
                        can.setColors(defCol, defCol, selCol);
                        leftTree.mainUI.altPressed = false;
                    }
                }

                can.repaint();
            }
        };

    public Arrow(final SchemaTree lt, final SchemaTree rt) {
        setLayout(new BorderLayout());

        leftTree = lt;
        rightTree = rt;

        Toolkit tk = Toolkit.getDefaultToolkit();
        Dimension d = tk.getScreenSize();
        setSize(600, 100);

        //setPreferredSize(new Dimension(600,100));
        can.addMouseListener(ma);
        can.repaint();
        can.setSize(600, 100);

        setLayout(new BorderLayout());
        add(can, BorderLayout.CENTER);
    }

    public void whichMatch() {
        try {
            //user interaction
            String message = "Which match are you entering?";

            Vector choices = new Vector();
            choices.add("Single Match");
            choices.add("Local Multiple Match");

            final String msg = message;
            final Vector c = choices;

            String dataEntered = null;

            final Interactive2 inter = new Interactive2(msg, c);

            inter.show();

            // wait for the option to close
            while (inter.isVisible()) {
                Thread.sleep(100);
            }

            ;
            dataEntered = inter.data;

            if ((dataEntered != null) && dataEntered.equals("2")) {
                leftTree.mainUI.altPressed = true;
            }
        } catch (java.lang.Exception e) {
            System.err.println("From Arrow: " + e);
        }
    }

    public void manualSelect(final String side) {
        if (side.equals("left")) {
            can.setColors(selCol, defCol, defCol);
        } else if (side.equals("middle")) {
            can.setColors(defCol, selCol, defCol);
        } else if (side.equals("right")) {
            can.setColors(defCol, defCol, selCol);
            leftTree.mainUI.altPressed = false;
        } else {
            can.setColors(defCol, defCol, defCol);
        }

        can.repaint();
    }

    class ArrowCanvas extends JPanel {
        public Color leftColor = new Color(150, 150, 255);
        public Color middleColor = new Color(150, 150, 255);
        public Color rightColor = new Color(150, 150, 255);

        public void setColors(Color lc, Color mc, Color rc) {
            leftColor = lc;
            middleColor = mc;
            rightColor = rc;
        }

        public void paintComponent(Graphics g) {
            PrintWriter cout = new PrintWriter(System.err, true);

            if (SCIA.debug_on) {
                cout.println("Paint is called");
            }

            int X = getWidth();
            int Y = getHeight();
            int whiteSpace = 20; //10

            // set background color to white
            g.setColor(Color.white);
            g.fillRect(0, 0, X - 1, Y - 1);

            // initialize the left polygon
            Polygon leftPoly = new Polygon();
            leftPoly.addPoint(whiteSpace * 2, Y / 2);
            leftPoly.addPoint((X / 3) - 50, whiteSpace);
            leftPoly.addPoint((X / 3) - 50, (Y / 4) + (whiteSpace / 2));
            leftPoly.addPoint(X / 3, (Y / 4) + (whiteSpace / 2));
            leftPoly.addPoint(X / 3, Y - (Y / 4) - (whiteSpace / 2));
            leftPoly.addPoint((X / 3) - 50, Y - (Y / 4) - (whiteSpace / 2));
            leftPoly.addPoint((X / 3) - 50, Y - whiteSpace);
            leftPoly.addPoint(whiteSpace * 2, Y / 2);

            // initialzie the middle polygon
            Polygon middlePoly = new Polygon();
            middlePoly.addPoint(X / 3, (Y / 4) + (whiteSpace / 2));
            middlePoly.addPoint(X - (X / 3), (Y / 4) + (whiteSpace / 2));
            middlePoly.addPoint(X - (X / 3), Y - (Y / 4) - (whiteSpace / 2));
            middlePoly.addPoint(X / 3, Y - (Y / 4) - (whiteSpace / 2));

            // initialize the right polygon
            Polygon rightPoly = new Polygon();
            rightPoly.addPoint(X - (X / 3), (Y / 4) + (whiteSpace / 2));
            rightPoly.addPoint(X - (X / 3) + 50, (Y / 4) + (whiteSpace / 2));
            rightPoly.addPoint(X - (X / 3) + 50, whiteSpace);
            rightPoly.addPoint(X - (whiteSpace * 2), Y / 2);
            rightPoly.addPoint(X - (X / 3) + 50, Y - whiteSpace);
            rightPoly.addPoint(X - (X / 3) + 50, Y - (Y / 4) -
                (whiteSpace / 2));
            rightPoly.addPoint(X - (X / 3), Y - (Y / 4) - (whiteSpace / 2));
            rightPoly.addPoint(X - (X / 3), (Y / 4) + (whiteSpace / 2));

            // draw the body
            g.setColor(leftColor);
            g.fillPolygon(leftPoly);
            g.setColor(middleColor);
            g.fillPolygon(middlePoly);
            g.setColor(rightColor);
            g.fillPolygon(rightPoly);

            // draw outline
            g.setColor(Color.black);
            g.drawPolygon(leftPoly);
            g.drawPolygon(middlePoly);
            g.drawPolygon(rightPoly);

            int screenRes = Toolkit.getDefaultToolkit().getScreenResolution() / 72;
            int fontSize = screenRes * 18;

            // draw text
            Font f = new Font("SansSerif", Font.BOLD + Font.ITALIC, fontSize);
            g.setFont(f);

            //Font f = g.getFont();
            FontMetrics fm = getFontMetrics(f);

            g.drawString("Source", X / 6, (Y / 2) + (fm.getHeight() / 2));
            g.drawString("Match", (X / 2) - (fm.stringWidth("Match") / 2),
                (Y / 2) + (fm.getHeight() / 2));
            g.drawString("Target", ((X * 5) / 6) - fm.stringWidth("Target"),
                (Y / 2) + (fm.getHeight() / 2));
        }
    }
}
