/**
 * Copyright (c) 2005 The Regents of the University of California.
 * All rights reserved.
 *
 * Permission is hereby granted, without written agreement and without
 * license or royalty fees, to use, copy, modify, and distribute this
 * software and its documentation for any purpose, provided that the
 * above copyright notice and the following two paragraphs appear in
 * all copies of this software.
 *
 * IN NO EVENT SHALL THE UNIVERSITY OF CALIFORNIA BE LIABLE TO ANY PARTY
 * FOR DIRECT, INDIRECT, SPECIAL, INCIDENTAL, OR CONSEQUENTIAL DAMAGES
 * ARISING OUT OF THE USE OF THIS SOFTWARE AND ITS DOCUMENTATION, EVEN
 * IF THE UNIVERSITY OF CALIFORNIA HAS BEEN ADVISED OF THE POSSIBILITY
 * OF SUCH DAMAGE.
 *
 * THE UNIVERSITY OF CALIFORNIA SPECIFICALLY DISCLAIMS ANY WARRANTIES,
 * INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES OF
 * MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE. THE SOFTWARE
 * PROVIDED HEREUNDER IS ON AN "AS IS" BASIS, AND THE UNIVERSITY
 * OF CALIFORNIA HAS NO OBLIGATION TO PROVIDE MAINTENANCE, SUPPORT,
 * UPDATES, ENHANCEMENTS, OR MODIFICATIONS.
 */
package org.kepler.scia;


/**
 * A condition contains a schema tree node, a comparator symbol and another
 * schema tree node or a constant.
 *
 * @author Guilian Wang
 */
class Condition {
    public String compareSymbol;
    public String constant;

    //E.g., /Bsml/Definitions/Genomes/Genome@id
    public TNode matchNeighborNode;

    // E.g., /Bsml/Definitions/Sequences/Sequence/genomeref    
    public TNode workingNeighborNode;

    public Condition() {
    }

    public Condition(TNode node1, String symb, TNode node2) {
        matchNeighborNode = node1;
        compareSymbol = symb;
        workingNeighborNode = node2;
    }

    public Condition(TNode node1, String symb, String value) {
        matchNeighborNode = node1;
        compareSymbol = symb;
        constant = value;
    }

    public String toString() {
        String result = new String();

        if (matchNeighborNode != null) {
            result = matchNeighborNode.getPath();
        }

        if (compareSymbol != null) {
            result = result + " " + compareSymbol + " ";
        }

        if (workingNeighborNode != null) {
            result = result + workingNeighborNode.getPath();
        } else if (constant != null) {
            result = result + constant;
        }

        return result;
    }
}
