/**
 * Copyright (c) 2005 The Regents of the University of California.
 * All rights reserved.
 *
 * Permission is hereby granted, without written agreement and without
 * license or royalty fees, to use, copy, modify, and distribute this
 * software and its documentation for any purpose, provided that the
 * above copyright notice and the following two paragraphs appear in
 * all copies of this software.
 *
 * IN NO EVENT SHALL THE UNIVERSITY OF CALIFORNIA BE LIABLE TO ANY PARTY
 * FOR DIRECT, INDIRECT, SPECIAL, INCIDENTAL, OR CONSEQUENTIAL DAMAGES
 * ARISING OUT OF THE USE OF THIS SOFTWARE AND ITS DOCUMENTATION, EVEN
 * IF THE UNIVERSITY OF CALIFORNIA HAS BEEN ADVISED OF THE POSSIBILITY
 * OF SUCH DAMAGE.
 *
 * THE UNIVERSITY OF CALIFORNIA SPECIFICALLY DISCLAIMS ANY WARRANTIES,
 * INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES OF
 * MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE. THE SOFTWARE
 * PROVIDED HEREUNDER IS ON AN "AS IS" BASIS, AND THE UNIVERSITY
 * OF CALIFORNIA HAS NO OBLIGATION TO PROVIDE MAINTENANCE, SUPPORT,
 * UPDATES, ENHANCEMENTS, OR MODIFICATIONS.
 */
package org.kepler.scia;


/**
 * A MatchingUnit is a basic unit in a local 1:k match. A MatchingUnit has a
 * source node, operations on this source node, and an operation for combining
 * this source node and the next source node in the local 1:k match expression.
 * E.g., for density = count/(area/10000), there are 2 matching units,
 * 1) (count, null, div) and 2) (area, div (10000), null) in the matchingUnits
 * field of the final
 * @see Matching
 * called fromComb for the node density.
 *
 * @author Guilian Wang
 */
class MatchingUnit {
    public TNode sourceNode; // the relevant source node
    public String operations; // the list of operations on the source node itself

    // the operation between this matching unit and the next matching unit in the 
    // local 1:k matching expression
    public String opConnectingNextUnit;

    public MatchingUnit(TNode n, String ops, String op) {
        sourceNode = n;

        if (ops != null) {
            operations = ops;
        }

        if (op != null) {
            opConnectingNextUnit = op;
        }
    }
}
