/**
 * Copyright (c) 2005 The Regents of the University of California.
 * All rights reserved.
 *
 * Permission is hereby granted, without written agreement and without
 * license or royalty fees, to use, copy, modify, and distribute this
 * software and its documentation for any purpose, provided that the
 * above copyright notice and the following two paragraphs appear in
 * all copies of this software.
 *
 * IN NO EVENT SHALL THE UNIVERSITY OF CALIFORNIA BE LIABLE TO ANY PARTY
 * FOR DIRECT, INDIRECT, SPECIAL, INCIDENTAL, OR CONSEQUENTIAL DAMAGES
 * ARISING OUT OF THE USE OF THIS SOFTWARE AND ITS DOCUMENTATION, EVEN
 * IF THE UNIVERSITY OF CALIFORNIA HAS BEEN ADVISED OF THE POSSIBILITY
 * OF SUCH DAMAGE.
 *
 * THE UNIVERSITY OF CALIFORNIA SPECIFICALLY DISCLAIMS ANY WARRANTIES,
 * INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES OF
 * MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE. THE SOFTWARE
 * PROVIDED HEREUNDER IS ON AN "AS IS" BASIS, AND THE UNIVERSITY
 * OF CALIFORNIA HAS NO OBLIGATION TO PROVIDE MAINTENANCE, SUPPORT,
 * UPDATES, ENHANCEMENTS, OR MODIFICATIONS.
 */
package org.kepler.scia;


/************************************************
Prompt.java

This class is a simple popup engine, that will
prompt the user with the "prompt" variable and
will return whatever the user enters
************************************************/
import java.awt.Dimension;
import java.awt.Panel;
import java.awt.TextField;
import java.awt.Toolkit;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;

import javax.swing.JFrame;


public class Prompt extends JFrame {
    // global variables so that they could be set
    private String function;

    // global variables so that they could be set
    private String prompt;

    // constructor
    public Prompt(final String p, final boolean skipText, final MainUI t,
                  final String nodePath, final boolean itself, final boolean condition) {
        setTitle(" ");

        // setting the global variable
        prompt = p;

        // position our popup window in the center of the screen
        Toolkit tk = Toolkit.getDefaultToolkit();
        Dimension d = tk.getScreenSize();

        setLocation((d.width / 2) - 250, (d.height / 2) - 50);
        setSize(500, 100);

        final TextField textField = new TextField(40);

        KeyAdapter kl = new KeyAdapter() {
                public void keyPressed(KeyEvent ke) {
                    if (ke.getKeyCode() == KeyEvent.VK_ENTER) {
                        hide();

                        if (!skipText) {
                            function = textField.getText();

                            if(condition) {
                                t.conditionCallback(textField.getText(), 
                                                    t.conditionNode, null);
                                t.firstCondition = false;
                                t.secondCondition = false;
                                t.sameNodeCondition = false;
                                t.conditionNode = null;
                            }
                            else {
                                t.promptCallback(function, itself, nodePath);
                            }

                            if (SCIA.debug_on) {
                                System.err.println(
                                    "The user entered the function:");
                            }

                            if (SCIA.debug_on) {
                                System.err.println(function);
                            }
                        }
                    }
                }
            };

        // setting up the panel with the text area
        Panel pan = new Panel();
        pan.add(textField);

        TextCanvas can = new TextCanvas(prompt);
        getContentPane().add(can, "Center");
        can.repaint();

        // if we don't need the text area, don't
        // add the panel to the frame
        if (skipText == false) {
            setSize(500, 150);
            textField.addKeyListener(kl);
            getContentPane().add(pan, "South");
        } else {
            setSize(500, 75);
            can.addKeyListener(kl);
        }
    }
}

