/**
 * Copyright (c) 2005 The Regents of the University of California.
 * All rights reserved.
 *
 * Permission is hereby granted, without written agreement and without
 * license or royalty fees, to use, copy, modify, and distribute this
 * software and its documentation for any purpose, provided that the
 * above copyright notice and the following two paragraphs appear in
 * all copies of this software.
 *
 * IN NO EVENT SHALL THE UNIVERSITY OF CALIFORNIA BE LIABLE TO ANY PARTY
 * FOR DIRECT, INDIRECT, SPECIAL, INCIDENTAL, OR CONSEQUENTIAL DAMAGES
 * ARISING OUT OF THE USE OF THIS SOFTWARE AND ITS DOCUMENTATION, EVEN
 * IF THE UNIVERSITY OF CALIFORNIA HAS BEEN ADVISED OF THE POSSIBILITY
 * OF SUCH DAMAGE.
 *
 * THE UNIVERSITY OF CALIFORNIA SPECIFICALLY DISCLAIMS ANY WARRANTIES,
 * INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES OF
 * MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE. THE SOFTWARE
 * PROVIDED HEREUNDER IS ON AN "AS IS" BASIS, AND THE UNIVERSITY
 * OF CALIFORNIA HAS NO OBLIGATION TO PROVIDE MAINTENANCE, SUPPORT,
 * UPDATES, ENHANCEMENTS, OR MODIFICATIONS.
 */
package org.kepler.scia;


/*------------------------------------------------------------------------------
  Guilian Wang
  June 9, 2003

  File Name:      SchemaNode.java
  Description:    Define dtd node for automatic matching
  -----------------------------------------------------------------------------*/
import java.io.*;
import java.io.PrintWriter;


//import gnu.getopt.*;
class SchemaNode {
    /**********************************************************************
    % Class Name :   SchemaNode
    % File :         SchemaNode.java
    %
    % Description :  Each SchemaNode contains the tag of the element node or
    %                attribute, node type
    %                     (parentElem, leafElem, attribute), data type, minOccurs,
    %                maxOccurs, index number.
    %
    **********************************************************************/
    private String tag; // tag of the element node or attribute
    private String normalizedTag; // tag changed by normalizing process 

    // rootElem, parentElem, leafElem, attribute
    public String nodeType;

    // CDATA, PCDATA, ID, STRING, INT, DATE, NUMBER, FLOAT
    public String dataType;
    public String description;

    // cardinality, number of possible occurence
    public String minOccurs; // an integer
    public String maxOccurs; // an integer or "unbounded"

    public SchemaNode(String t, String nt, String dt, String minOc, String maxOc) {
        tag = t;
        normalizedTag = t;
        nodeType = nt;
        dataType = dt;
        minOccurs = minOc;
        maxOccurs = maxOc;
    }

    public SchemaNode(String t, String nt, String dt, String minOc,
        String maxOc, String desc) {
        tag = t;
        normalizedTag = t;
        nodeType = nt;
        dataType = dt;
        description = desc;
        minOccurs = minOc;
        maxOccurs = maxOc;
    }

    public SchemaNode(String t, String nt, String dt) {
        tag = t;
        normalizedTag = t;
        nodeType = nt;
        dataType = dt;
    }

    public SchemaNode(String t, String nt, String dt, String desc) {
        tag = t;
        normalizedTag = t;
        nodeType = nt;
        dataType = dt;
        description = desc;
    }

    public String getTag() {
        return tag;
    }

    public String getDescription() {
        return description;
    }

    public String getNormalizedTag() {
        return normalizedTag;
    }

    public boolean isEquals(SchemaNode bbb) {
        return tag.equals(bbb.getTag());
    }

    public void setNormalizedTag(String normTag) {
        normalizedTag = normTag;
    }

    // add TagMatch()
    public PrintWriter write(PrintWriter stream, String headSpace) {
        //stream.println ("In SchemaNode element Write()");
        stream.print(headSpace);

        String str = tag + "  (nt: " + nodeType + "  dt:" + dataType +
            "  minOc:" + minOccurs + "  maxOc:" + maxOccurs;

        if ((description != null) && !description.equals("")) {
            str = str + "  desc:" + description;
        }

        if (!normalizedTag.equalsIgnoreCase(tag) && !normalizedTag.equals("")) {
            str = str + " n_tag: " + normalizedTag + ")";
        }

        stream.print(str);

        return stream;
    }

    public SchemaNode getCopy() {
        SchemaNode copy = new SchemaNode(tag, nodeType, dataType, minOccurs,
                maxOccurs);

        return copy;
    }
}
