/* JCOGGridFtp actor subclased from stanard Exec from PtolemyII concepts.
 Copyright (c) 2005 The Regents of the University of California.
 All rights reserved.

  Permission is hereby granted, without written agreement and without
 license or royalty fees, to use, copy, modify, and distribute this
 software and its documentation for any purpose, provided that the above
 copyright notice and the following two paragraphs appear in all copies
 of this software.

 IN NO EVENT SHALL THE UNIVERSITY OF CALIFORNIA BE LIABLE TO ANY PARTY
 FOR DIRECT, INDIRECT, SPECIAL, INCIDENTAL, OR CONSEQUENTIAL DAMAGES
 ARISING OUT OF THE USE OF THIS SOFTWARE AND ITS DOCUMENTATION, EVEN IF
 THE UNIVERSITY OF CALIFORNIA HAS BEEN ADVISED OF THE POSSIBILITY OF
 SUCH DAMAGE.

 THE UNIVERSITY OF CALIFORNIA SPECIFICALLY DISCLAIMS ANY WARRANTIES,
 INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES OF
 MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE. THE SOFTWARE
 PROVIDED HEREUNDER IS ON AN "AS IS" BASIS, AND THE UNIVERSITY OF
 CALIFORNIA HAS NO OBLIGATION TO PROVIDE MAINTENANCE, SUPPORT, UPDATES,
 ENHANCEMENTS, OR MODIFICATIONS.
                                        PT_COPYRIGHT_VERSION_2
                                        COPYRIGHTENDKEY
*/

package org.monash.griddles;

import ptolemy.actor.TypedAtomicActor;
import ptolemy.kernel.CompositeEntity;
import ptolemy.kernel.util.NameDuplicationException;
import ptolemy.kernel.util.IllegalActionException;
import java.io.InputStream;
import java.io.BufferedInputStream;
import java.io.IOException;
import java.io.File;


/**
  *   JCOGGridFtp is a subclass of the Exec actor in 
  *   which it takes xml configuration file as input and performs 
  *   the experiment as a independent process ......
  * 
  * This actor makes complex applications to run distributed systems .....   
  * @author Jagan Kommineni, Monash University July 2005
  * @version $Id: JCOGGridFTP.java,v 1.2 2006/02/13 07:01:46 kommineni Exp $
  **/

public class JCOGGridFTP extends TypedAtomicActor {
  public JCOGGridFTP(CompositeEntity container, String name)
    throws NameDuplicationException, IllegalActionException  {
    super(container, name);

    }
    
  public static String classPath;

  public void process(File file)
    {
    if(file.isFile())
      {
      String name = file.getAbsolutePath();
      if(name.endsWith(".jar"))
        {
        classPath = classPath+file.pathSeparator+name;      
        //System.out.println(name);
        }
      }
    }   
  public void visitAllDirsAndFiles(File dir) 
    {
    process(dir);
    
    if (dir.isDirectory()) 
      {
      String[] children = dir.list();
      for (int i=0; i<children.length; i++) 
        {
        visitAllDirsAndFiles(new File(dir, children[i]));
        }
      }
    } 
  public synchronized void fire() throws IllegalActionException 
    {
    try
      {
      String kepler = System.getProperty("KEPLER");
      File kfile = new File(kepler+"/cog");       
      visitAllDirsAndFiles(kfile);     
      classPath += kfile.pathSeparator;
      classPath += System.getProperty("java.class.path",".");       
      String wfCommnad =  "java -classpath "+classPath+" org.globus.cog.gridface.impl.gftpanel.GridFTPPanelImpl ";
      //System.out.println(wfCommnad);
      executeCommand(wfCommnad);
        
      }
    catch(Exception ex) 
      { 
      System.out.println("The exception raised the message "+ex.getMessage());        
      ex.printStackTrace();      
      }
    }
       
  public static boolean executeCommand(String command) {
    Process process = null;
    try {
      //System.out.println("Executing external command " + command);
      process = Runtime.getRuntime().exec(command);
      }
    catch (IOException e) {
      System.out.println(e.toString());
      return false;
      }
    InputStream inputStream = process.getInputStream();
    BufferedInputStream bufferedInputStream = new BufferedInputStream(inputStream);
    InputStream errorStream = process.getErrorStream();
    BufferedInputStream bufferedErrorStream = new BufferedInputStream(errorStream);
    boolean ok = false;
    int exitValue = -999;
    while (!ok) {
      try {
        while (bufferedInputStream.available() > 0 || bufferedErrorStream.available() > 0) {
          while (bufferedInputStream.available() > 0) {
             System.out.print((char)bufferedInputStream.read());
             }
           while (bufferedErrorStream.available() > 0) {
             System.out.print((char)bufferedErrorStream.read());
             }
           }
         }
       catch (IOException e) {
         System.out.println("Couldn't read response");
         }
       try {
         exitValue = process.exitValue();
         System.out.println("Process exit value= " + exitValue); 
         ok = true;
       }
     catch (IllegalThreadStateException e) {
       }
     }
   if(ok){
     // finished running
     if(exitValue == 0) {
       System.out.println("Terminated without any errors");
       }
     else {
       System.out.println("Exit code " + exitValue + " while performing command " + command);
       }
     }
   else {
     process.destroy();
     }
   try {
     while (bufferedInputStream.available() > 0) {
       System.out.print((char)bufferedInputStream.read());
       }
     while (bufferedErrorStream.available() > 0) {
       System.out.print((char)bufferedErrorStream.read());
       }
     }
   catch (IOException e) {
     System.out.println("Couldn't read response");
     }
   return exitValue == 0;
   }    
  public boolean postfire() {
    return false;
    }
  }