/* JTypedCompositeActor 

 Copyright (c) 2005 The Regents of the University of California.
 All rights reserved.

  Permission is hereby granted, without written agreement and without
 license or royalty fees, to use, copy, modify, and distribute this
 software and its documentation for any purpose, provided that the above
 copyright notice and the following two paragraphs appear in all copies
 of this software.

 IN NO EVENT SHALL THE UNIVERSITY OF CALIFORNIA BE LIABLE TO ANY PARTY
 FOR DIRECT, INDIRECT, SPECIAL, INCIDENTAL, OR CONSEQUENTIAL DAMAGES
 ARISING OUT OF THE USE OF THIS SOFTWARE AND ITS DOCUMENTATION, EVEN IF
 THE UNIVERSITY OF CALIFORNIA HAS BEEN ADVISED OF THE POSSIBILITY OF
 SUCH DAMAGE.

 THE UNIVERSITY OF CALIFORNIA SPECIFICALLY DISCLAIMS ANY WARRANTIES,
 INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES OF
 MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE. THE SOFTWARE
 PROVIDED HEREUNDER IS ON AN "AS IS" BASIS, AND THE UNIVERSITY OF
 CALIFORNIA HAS NO OBLIGATION TO PROVIDE MAINTENANCE, SUPPORT, UPDATES,
 ENHANCEMENTS, OR MODIFICATIONS.

                                        PT_COPYRIGHT_VERSION_2
                                        COPYRIGHTENDKEY


*/


package org.monash.griddles;

import ptolemy.actor.TypedCompositeActor;
import ptolemy.actor.TypedIORelation;
import ptolemy.data.expr.StringParameter;
import ptolemy.kernel.ComponentRelation;
import ptolemy.kernel.CompositeEntity;
import ptolemy.kernel.util.IllegalActionException;
import ptolemy.kernel.util.InternalErrorException;
import ptolemy.kernel.util.NameDuplicationException;
import ptolemy.kernel.util.Workspace;

/**************

 * This JTypedCompositeActor actor is the subclass of ptolemy TypedCompositeActor for 
   adding new attribute to the relation at the time of its creation. 

   This attrubite gives an indication to the GriddLeS runtime about the mode of
   data transfer from one location to another.
   
   
 * @author Jagan Kommineni, Monash University July 2005
 * @version $Id: JTypedCompositeActor.java,v 1.2 2005/11/01 20:39:13 ruland Exp $

 ***************/

public class JTypedCompositeActor extends TypedCompositeActor{
  /** Construct a TypedCompositeActor in the default workspace with no
    *  container and an empty string as its name. Add the actor to the
    *  workspace directory.  You should set the local director or
    *  executive director before attempting to send data to the actor or
    *  to execute it. Increment the version number of the workspace.
    */
  public JTypedCompositeActor() {
    super();
    // By default, when exporting MoML, the class name is whatever
    // the Java class is, which in this case is TypedCompositeActor.
    // In derived classes, however, we usually do not want to identify
    // the class name as that of the derived class, but rather want
    // to identify it as TypedCompositeActor.  This way, the MoML
    // that is exported does not depend on the presence of the
    // derived class Java definition. Thus, we force the class name
    // here to be TypedCompositeActor.
    //setClassName("ptolemy.actor.TypedCompositeActor");
    }

    /** Construct a TypedCompositeActor in the specified workspace with
     *  no container and an empty string as a name. You can then change
     *  the name with setName(). If the workspace argument is null, then
     *  use the default workspace.  You should set the local director or
     *  executive director before attempting to send data to the actor
     *  or to execute it. Add the actor to the workspace directory.
     *  Increment the version number of the workspace.
     *  @param workspace The workspace that will list the actor.
     */
  public JTypedCompositeActor(Workspace workspace) {
    super(workspace);
    // By default, when exporting MoML, the class name is whatever
    // the Java class is, which in this case is TypedCompositeActor.
    // In derived classes, however, we usually do not want to identify
    // the class name as that of the derived class, but rather want
    // to identify it as TypedCompositeActor.  This way, the MoML
    // that is exported does not depend on the presence of the
    // derived class Java definition. Thus, we force the class name
    // here to be TypedCompositeActor.
    //      setClassName("ptolemy.actor.TypedCompositeActor");
    }

    /** Construct a TypedCompositeActor with a name and a container.
     *  The container argument must not be null, or a
     *  NullPointerException will be thrown.  This actor will use the
     *  workspace of the container for synchronization and version counts.
     *  If the name argument is null, then the name is set to the empty string.
     *  Increment the version of the workspace.  This actor will have no
     *  local director initially, and its executive director will be simply
     *  the director of the container.
     *
     *  @param container The container.
     *  @param name The name of this actor.
     *  @exception IllegalActionException If the container is incompatible
     *   with this actor.
     *  @exception NameDuplicationException If the name coincides with
     *   an actor already in the container.
     */
  public JTypedCompositeActor(CompositeEntity container, String name)
        throws IllegalActionException, NameDuplicationException {
    super(container, name);
    // By default, when exporting MoML, the class name is whatever
    // the Java class is, which in this case is TypedCompositeActor.
    // In derived classes, however, we usually do not want to identify
    // the class name as that of the derived class, but rather want
    // to identify it as TypedCompositeActor.  This way, the MoML
    // that is exported does not depend on the presence of the
    // derived class Java definition. Thus, we force the class name
    // here to be TypedCompositeActor.
    //setClassName("ptolemy.actor.TypedCompositeActor");
    }

    ///////////////////////////////////////////////////////////////////
    ////                         public methods                    ////


    /** Create a new TypedIORelation with the specified name, add it
     *  to the relation list, and return it. Derived classes can override
     *  this to create domain-specific subclasses of TypedIORelation.
     *  This method is write-synchronized on the workspace.
     *
     *  @param name The name for the new TypedIORelation.
     *  @return A new TypedIORelation.
     *  @exception NameDuplicationException If name collides with a name
     *   already on the container's contents list.
     *
     *  Different option in this list box refers to the various modes of data 
        transfer from one location to another, if specified this option overrides the 
        defaults model specification. Griddles uses this information at runtime.
        
        GriddLeS actually supports four different IO modes between components, as follows:
        1. Local_Read_and_Write_with_File_Copy: Output data is written to a local file which is 
             copied from the source machine to the destination machine. The downstream computation 
             reads the input data from a file. The experiment is controlled by the SDF director 
             which means that a destination computation is only started when the source completes;
        2. Remote_Write_Local_Read: Output data is written to a remote file on the destination machine. The downstream 
             computation then reads the input data from that file, and the experiment is controlled 
             by the SDF director as in (1);
        3. Local_Write_Remote_Read: Output data is written to a local file on the source machine. The computation on 
             the destination machine reads the data remotely and the experiment is controlled by 
             the SDF director as in (1);
        4. Buffered: Output data is written to a buffer, and is read by the downstream computation from 
             the same buffer. The experiment is controlled by the PN director which means that all 
             computations run concurrently.        
     */

    public ComponentRelation newRelation(String name) throws NameDuplicationException {
    try {
      workspace().getWriteAccess();
      TypedIORelation relation = new TypedIORelation(this, name);      
      StringParameter param = new StringParameter(relation, name);
      param.addChoice("Default"); 
      param.addChoice("Buffered"); 
      param.addChoice("Remote_Write_Local_Read");
      param.addChoice("Local_Write_Remote_Read");
      param.addChoice("Local_Read_and_Write_with_File_Copy");
             
     return relation;
      } 
    catch (IllegalActionException ex) {
      // This exception should not occur, so we throw a runtime
      // exception.
      throw new InternalErrorException(this, ex, null);
      } 
    finally {
      workspace().doneWriting();
      }
    }
  }