/* Removes from data stream collections not matching metadata-based criteria.
 *
 * Copyright (c) 2005 Natural Diversity Discovery Project.
 * All rights reserved.
 * 
 * Permission is hereby granted, without written agreement and without
 * license or royalty fees, to use, copy, modify, and distribute this
 * software and its documentation for any purpose, provided that the
 * above copyright notice and the following two paragraphs appear in
 * all copies of this software.
 * 
 * IN NO EVENT SHALL THE NATURAL DIVERSITY DISCOVERY PROJECT BE LIABLE 
 * TO ANY PARTY FOR DIRECT, INDIRECT, SPECIAL, INCIDENTAL, OR 
 * CONSEQUENTIAL DAMAGES ARISING OUT OF THE USE OF THIS SOFTWARE AND 
 * ITS DOCUMENTATION, EVEN IF THE NATURAL DIVERSITY DISCOVERY PROJECT
 * HAS BEEN ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 * 
 * THE NATURAL DIVERSITY DISCOVERY PROJECT SPECIFICALLY DISCLAIMS ANY 
 * WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES OF
 * MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE. THE SOFTWARE
 * PROVIDED HEREUNDER IS ON AN "AS IS" BASIS, AND THE NATURAL 
 * DIVERSITY DISCOVERY PROJECT HAS NO OBLIGATION TO PROVIDE MAINTENANCE, 
 * SUPPORT, UPDATES, ENHANCEMENTS, OR MODIFICATIONS.

   @ProposedRating Red (tmcphillips@naturaldiversity.org)
   @AcceptedRating Red (tmcphillips@naturaldiversity.org) 
 */

package org.nddp.coactors;

import org.nddp.CollectionManager;
import org.nddp.util.Parameters;
import ptolemy.data.BooleanToken;
import ptolemy.data.Token;
import ptolemy.data.expr.Parameter;
import ptolemy.data.expr.Variable;
import ptolemy.kernel.CompositeEntity;
import ptolemy.kernel.util.IllegalActionException;
import ptolemy.kernel.util.NameDuplicationException;

/**
 * @nddp.coactor type="general"
 */
public class CollectionFilter extends CollectionBuffer {

    public CollectionFilter(CompositeEntity container, String name)
        throws NameDuplicationException, IllegalActionException  {

    	    // call the superclass constructor
        	super(container, name);

		forwardingCondition = Parameters.stringParameter(
		        this, "Forward collection if", "true");
		
		_conditionExpression = new Variable(this, "_filterExpression");
    }

	///////////////////////////////////////////////////////////////////
	////                         public variables                  ////
  	
  	public Parameter forwardingCondition;

	///////////////////////////////////////////////////////////////////
	////                         protected methods                 ////

   	protected BufferDisposition _handleBufferingEnd(CollectionManager 
        collectionManager) throws IllegalActionException {
   	    
   	    	String expandedExpressionString = 
   	    	    collectionManager.expandMetadataSymbols(
   	    	    	_conditionExpressionString);
   	    	
		_conditionExpression.setExpression(expandedExpressionString);
        	boolean filterExpressionValue = 
        	    ((BooleanToken)_conditionExpression.getToken()).booleanValue();

        	if (filterExpressionValue) {
		    return FORWARD_BUFFER;
		} else {
		    return DISCARD_BUFFER;
		}
	}

    public void _handleParameterChange(Parameter parameter, Token value) 
  		throws IllegalActionException {
  	    
		if (parameter == forwardingCondition) {
		    _conditionExpressionString = Parameters.stringValue(value);
		} else {
			super._handleParameterChange(parameter, value);
        	}
    }
  
  	///////////////////////////////////////////////////////////////////
	////                         private variables                 ////
	
  	private Variable _conditionExpression;
  	private String _conditionExpressionString;
}