/* Actor that replaces records in data stream with values of a record element.
 *
 * Copyright (c) 2005 Natural Diversity Discovery Project.
 * All rights reserved.
 * 
 * Permission is hereby granted, without written agreement and without
 * license or royalty fees, to use, copy, modify, and distribute this
 * software and its documentation for any purpose, provided that the
 * above copyright notice and the following two paragraphs appear in
 * all copies of this software.
 * 
 * IN NO EVENT SHALL THE NATURAL DIVERSITY DISCOVERY PROJECT BE LIABLE 
 * TO ANY PARTY FOR DIRECT, INDIRECT, SPECIAL, INCIDENTAL, OR 
 * CONSEQUENTIAL DAMAGES ARISING OUT OF THE USE OF THIS SOFTWARE AND 
 * ITS DOCUMENTATION, EVEN IF THE NATURAL DIVERSITY DISCOVERY PROJECT
 * HAS BEEN ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 * 
 * THE NATURAL DIVERSITY DISCOVERY PROJECT SPECIFICALLY DISCLAIMS ANY 
 * WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES OF
 * MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE. THE SOFTWARE
 * PROVIDED HEREUNDER IS ON AN "AS IS" BASIS, AND THE NATURAL 
 * DIVERSITY DISCOVERY PROJECT HAS NO OBLIGATION TO PROVIDE MAINTENANCE, 
 * SUPPORT, UPDATES, ENHANCEMENTS, OR MODIFICATIONS.

   @ProposedRating Red (tmcphillips@naturaldiversity.org)
   @AcceptedRating Red (tmcphillips@naturaldiversity.org) 
 */

package org.nddp.coactors;

import org.nddp.AtomicCoactor;
import org.nddp.CollectionHandler;
import org.nddp.CollectionManager;
import org.nddp.exceptions.CollectionException;
import org.nddp.util.Parameters;

import ptolemy.data.expr.Parameter;
import ptolemy.data.Token;
import ptolemy.data.RecordToken;
import ptolemy.kernel.CompositeEntity;
import ptolemy.kernel.util.*;

/**
 * @nddp.coactor type="general"
 */
public class RecordTokenExtractor extends CollectionTransformer {

    public RecordTokenExtractor(CompositeEntity container, String name)
        throws NameDuplicationException, IllegalActionException  {

        super(container, name);
        
        label = Parameters.stringParameter(this, "label", "");
    }

	///////////////////////////////////////////////////////////////////
	////                         public variables                  ////

    public Parameter label;

	///////////////////////////////////////////////////////////////////
	////                      protected methods                    //// 

    public CollectionHandler.TokenDisposition _handleData(CollectionManager
    	        collectionManager, Token token) throws CollectionException {

    	    if (token instanceof RecordToken) {

		    Token elementToken = ((RecordToken)token).get(_label);
		
		    // TODO replace record token with new data token
		    if (elementToken != null) {
		        collectionManager.addDataToken(elementToken);
		    }
    	    }
    	    
	 	return  CollectionHandler.DISCARD_TOKEN;
  	}
	
    public void _handleParameterChange(Parameter parameter, Token value) 
		throws IllegalActionException {
            
        if (parameter == label ) {
        
            _label = Parameters.stringValue(value);
                      
        } else {
        
            super._handleParameterChange(parameter, value);
        }
    }

	///////////////////////////////////////////////////////////////////
	////                         private variables                 ////

    private String _label;
}
