/* Static classes and methods for generating xml from DomainObjects.
 *
 * Copyright (c) 2005 Natural Diversity Discovery Project.
 * All rights reserved.
 * 
 * Permission is hereby granted, without written agreement and without
 * license or royalty fees, to use, copy, modify, and distribute this
 * software and its documentation for any purpose, provided that the
 * above copyright notice and the following two paragraphs appear in
 * all copies of this software.
 * 
 * IN NO EVENT SHALL THE NATURAL DIVERSITY DISCOVERY PROJECT BE LIABLE 
 * TO ANY PARTY FOR DIRECT, INDIRECT, SPECIAL, INCIDENTAL, OR 
 * CONSEQUENTIAL DAMAGES ARISING OUT OF THE USE OF THIS SOFTWARE AND 
 * ITS DOCUMENTATION, EVEN IF THE NATURAL DIVERSITY DISCOVERY PROJECT
 * HAS BEEN ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 * 
 * THE NATURAL DIVERSITY DISCOVERY PROJECT SPECIFICALLY DISCLAIMS ANY 
 * WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES OF
 * MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE. THE SOFTWARE
 * PROVIDED HEREUNDER IS ON AN "AS IS" BASIS, AND THE NATURAL 
 * DIVERSITY DISCOVERY PROJECT HAS NO OBLIGATION TO PROVIDE MAINTENANCE, 
 * SUPPORT, UPDATES, ENHANCEMENTS, OR MODIFICATIONS.

   @ProposedRating Red (tmcphillips@naturaldiversity.org)
   @AcceptedRating Red (tmcphillips@naturaldiversity.org) 
 */
 
package org.nddp.util;

import java.text.NumberFormat;

public class Xml {

    private Xml() {}

	///////////////////////////////////////////////////////////////////
	////                         public methods                    //// 

    public static String attribute(String name, char value) {
        return attribute(name, Character.toString(value), true);
    }

    public static String attribute(String name, double value) {
        return attribute(name, Double.toString(value), true);
    }

    public static String attribute(String name, double value, 
        NumberFormat doubleFormat) {

        return attribute(name, doubleFormat.format(value), true);
    }
    
    public static String attribute(String name, int value) {
        return attribute(name, Integer.toString(value), true);
    }


    public static String attribute(String name, String value) {
        return attribute(name, value, true);
    }
    
    public static String attribute(String name, String value, 
        boolean quoteValue) {
        
        if (quoteValue) {
	        return " " + name + "=\"" + value + "\"";
        } else {
	        return " " + name + "=" + value;
        }
    }

	///////////////////////////////////////////////////////////////////
	////                       public inner classes                ////

    public static class Indentation {
        
        public Indentation(Indentation indentation) {
            
            _indentationBuffer = new StringBuffer(indentation._indentation);
            _indentation = indentation._indentation;
            _indentStep = indentation._indentStep;
            _indentSize = indentation._indentSize;
        }

        public Indentation(String initialIndentation, String indentStep) {
            
            _indentationBuffer = new StringBuffer(initialIndentation);
            _indentation = _indentationBuffer.toString();
            _indentStep = indentStep;
            _indentSize = indentStep.length();
        }
        
		///////////////////////////////////////////////////////////////////
		////         public methods for Xml.Indentation               //// 

        public void decrease() {
		    
		    int length = _indentationBuffer.length();
		    
		    if (length >= _indentSize) {
		   	    _indentationBuffer.setLength(length - _indentSize);
		    }
		    
		    _indentation = _indentationBuffer.toString();
		}
	   	
		public void increase() {
		    
	   	    _indentationBuffer.append(_indentStep);
	   	    _indentation = _indentationBuffer.toString();
		}
		
		public void reset() {
		    _indentationBuffer.setLength(0);
		    _indentation = "";
		}
		
		public String toString() {
		    return _indentation;
		}
	
		///////////////////////////////////////////////////////////////////
		////         private variables for Xml.Indentation             //// 

		private String _indentation;
	    	private StringBuffer _indentationBuffer;
	    	private int _indentSize;
	    	private String _indentStep;
    }
}
