package org.nmiworkflow;

import org.globus.gram.GramJob;
import org.globus.gram.GramJobListener;
import org.globus.io.gass.server.GassServer;
import org.globus.io.gass.server.JobOutputListener;
import org.globus.io.gass.server.JobOutputStream;
import org.globus.util.deactivator.Deactivator;
import org.gridforum.jgss.ExtendedGSSCredential;
import org.gridforum.jgss.ExtendedGSSManager;
import org.ietf.jgss.GSSCredential;


/**
 * Java CoG Job submission class
 */
public class GridJob implements GramJobListener, JobOutputListener
{
private GassServer m_gassServer; // GASS Server: required to get job output
private String m_gassURL = null;   // URL of the GASS server
private GramJob m_job = null;        // GRAM JOB to be executed
private String m_jobOutput = "";     // job output as string
private String output = "";
private boolean m_batch = false;     // Submission modes:
             		         	//batch=do not wait for output
                                      //      non-batch=wait for output.
private String m_remoteHost = null;  // host where job will run
private GSSCredential m_proxy = null; 
 // Globus proxy used for authentication against gatekeeper

// Job output variables:
// Used for non-batch mode jobs to receive output from 
// gatekeeper through the GASS server
     
private JobOutputStream m_stdoutStream = null;
private JobOutputStream m_stderrStream = null;
private String m_jobid = null;  // Globus job id of the form: https://server.com:39374/15621/1021382777/

public GridJob(String Contact, boolean batch) {
m_remoteHost = Contact;  // remote host
m_batch = batch;         // submission mode
 }

 public String getOut() {
   return this.output;
 }
  
    /**
 * Start the Globus GASS Server. Used to get the output from the server
 * back to the client.
 */
  private boolean startGassServer() {
  if (m_gassServer != null) return true;
  try {
      m_gassServer = new GassServer(m_proxy, 2119);
      m_gassURL = m_gassServer.getURL();
  } catch(Exception e) {
      System.err.println("gass server failed to start!");
      e.printStackTrace();
      return false;
  }
  m_gassServer.registerDefaultDeactivator();
  return true;
 }
  /**
 * Init job out listeners for non-batch mode jobs.
 */
 private void initJobOutListeners() throws Exception {
  if ( m_stdoutStream != null ) return;
  // job output vars
  m_stdoutStream = new JobOutputStream(this);
  m_stderrStream = new JobOutputStream(this);
  m_jobid = String.valueOf(System.currentTimeMillis());

  // register output listeners
  m_gassServer.registerJobOutputStream("err-" + m_jobid, m_stderrStream);
  m_gassServer.registerJobOutputStream("out-" + m_jobid, m_stdoutStream);
  return;
  }

    
       /**
 * This method is used to notify the implementer when the status of a
 * GramJob has changed.
 *
 * @param job The GramJob whose status has changed.
 */
 public void statusChanged(GramJob job) {
     try {
       if ( job.getStatus() == GramJob.STATUS_DONE ) {
    // notify waiting thread when job ready
            //  m_jobOutput = "Job sent, got notification status changed. url=" + job.getIDAsString();  
              // if notify enabled return URL as output
                        synchronized(this) {
                            notify();
   }
             }
       }
   catch (Exception ex) {
       }
  }

/**
 * It is called whenever the job's output
 * has been updated.
 *
 * @param output new output
 */
 public void outputChanged(String output) {
        this.output = output;
 }

 /**
 * It is called whenever job finished
 * and no more output will be generated.
 */
 public void outputClosed() {
 }

     
public synchronized String GlobusRun(String RSL, String proxyString) {
   try {
//System.out.println("entered GlobusRun");
//System.out.println("got proxy string:\n" + proxyString);
   ExtendedGSSManager manager = (ExtendedGSSManager)ExtendedGSSManager.getInstance();
   //m_proxy = manager.createCredential(GSSCredential.INITIATE_AND_ACCEPT);
   m_proxy = manager.createCredential(proxyString.getBytes(),
				ExtendedGSSCredential.IMPEXP_OPAQUE,
                                  GSSCredential.DEFAULT_LIFETIME,
                                  null, // use default mechanism - GSI
                                  GSSCredential.INITIATE_AND_ACCEPT);
if(m_proxy == null) {
System.out.println("!!!!!!!!!!!!!!!!!!mproxy is null!!!!!!!!!!!!!");
}
//System.out.println("created m_proxy:" + m_proxy);
//System.out.println("lifetime===" + m_proxy.getRemainingLifetime());

   // Start GASS server
   if (! startGassServer()) {
   throw new Exception("Unable to start GASS server.");
}

// setup Job Output listeners
    initJobOutListeners();
/****
   System.out.println("proxy Issuer=" + m_proxy.getIssuer()+ 
   "\nsubject=" + m_proxy.getSubject() );
    System.out.println("Strength=" + m_proxy.getStrength() +
    " Gass: " + m_gassServer.toString() );
    System.out.println("GASS URL: " + m_gassURL );
***/
// Append GASS URL to job String so we can get some output back
 String newRSL = null;

 // if non-batch, then get some output back
 if ( !m_batch) {
  newRSL = "&" + RSL.substring(0, RSL.indexOf('&')) +
  "(rsl_substitution=(GLOBUSRUN_GASS_URL " + m_gassURL + "))" +
 RSL.substring(RSL.indexOf('&') + 1, RSL.length()) +
 "(stdout=$(GLOBUSRUN_GASS_URL)/dev/stdout-" + m_jobid + ")" +
 "(stderr=$(GLOBUSRUN_GASS_URL)/dev/stderr-" + m_jobid + ")";
    }
    else {
// format batching RSL so output can be retrieved later on using any GTK commands
newRSL = RSL + "(stdout=x-gass-cache://$(GLOBUS_GRAM_JOB_CONTACT)stdout anExtraTag)"
  + "(stderr=x-gass-cache://$(GLOBUS_GRAM_JOB_CONTACT)stderr anExtraTag)";
}

m_job = new GramJob(m_proxy,newRSL);

//System.out.println("RSL is " + newRSL);

// set proxy. CoG kit and user credentials must be installed and set 
// up properly
 //m_job.setCredentials(m_proxy);

//System.out.println("set credentials and stuff");

 // if non-batch then listen for output
 if (!m_batch) m_job.addListener(this);

 //System.out.println("Sending job request to: " + m_remoteHost);
 m_job.request(m_remoteHost, m_batch, false);

 // Wait for job to complete
 if ( ! m_batch ) {
 synchronized(this) {
 try {
  wait();
 } catch(InterruptedException e) {
System.err.println("Caught Interrupted exception: "+ e);
            }
          }
        }
 else
  // do not wait for job. Return immediately
  m_jobOutput = "Job sent. (not waiting) url=" + m_job.getIDAsString();
  }
  catch (Exception ex) {
	System.err.println("Caught exception : " + ex);
  if ( m_gassServer != null ) {
  // unregister from gass server
  System.err.println("unregistering from gass servers.");
  m_gassServer.unregisterJobOutputStream("err-" + m_jobid);
  m_gassServer.unregisterJobOutputStream("out-" + m_jobid);
  }
  m_jobOutput =  "Error submitting job: " + ex.getClass() + ":"
   + ex.getMessage();
  }
 // cleanup
 Deactivator.deactivateAll();
 return m_jobOutput;
 }
/**********
 public static void main(String[] args) {
	String RSL = "& (executable = /bin/ls)(arguments=-l)";
 	GridJob Job1 = new GridJob("tf005i.sdsc.edu", false);

 	String jobOut = Job1.GlobusRun(RSL, );
 	System.out.println(Job1.getOut());
 }
****************/
}
